/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.routing;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.metadata.project.ProjectManager;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.query.relnode.OLAPContext;
import org.apache.kylin.query.routing.NoRealizationFoundException;
import org.apache.kylin.query.routing.RoutingRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryRouter {
    private static final Logger logger = LoggerFactory.getLogger(QueryRouter.class);

    public static IRealization selectRealization(OLAPContext olapContext) throws NoRealizationFoundException {
        ProjectManager prjMgr = ProjectManager.getInstance((KylinConfig)olapContext.olapSchema.getConfig());
        String factTableName = olapContext.firstTableScan.getTableName();
        String projectName = olapContext.olapSchema.getProjectName();
        ArrayList realizations = Lists.newArrayList((Iterable)prjMgr.getRealizationsByTable(projectName, factTableName));
        logger.info("Find candidates by table " + factTableName + " and project=" + projectName + " : " + StringUtils.join((Iterable)realizations, (String)","));
        RoutingRule.applyRules(realizations, olapContext);
        if (realizations.size() == 0) {
            throw new NoRealizationFoundException("Can't find any realization. Please confirm with providers. SQL digest: " + olapContext.getSQLDigest().toString());
        }
        logger.info("The realizations remaining: ");
        logger.info(RoutingRule.getPrintableText(realizations));
        logger.info("The realization being chosen: " + ((IRealization)realizations.get(0)).getName());
        return (IRealization)realizations.get(0);
    }
}

