/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.relnode;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.calcite.adapter.enumerable.EnumerableCalc;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexProgramBuilder;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.util.NlsString;
import org.apache.kylin.metadata.filter.CaseTupleFilter;
import org.apache.kylin.metadata.filter.ColumnTupleFilter;
import org.apache.kylin.metadata.filter.CompareTupleFilter;
import org.apache.kylin.metadata.filter.ConstantTupleFilter;
import org.apache.kylin.metadata.filter.DynamicTupleFilter;
import org.apache.kylin.metadata.filter.ExtractTupleFilter;
import org.apache.kylin.metadata.filter.LogicalTupleFilter;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.query.relnode.ColumnRowType;
import org.apache.kylin.query.relnode.OLAPContext;
import org.apache.kylin.query.relnode.OLAPRel;

public class OLAPFilterRel
extends Filter
implements OLAPRel {
    private ColumnRowType columnRowType;
    private OLAPContext context;

    public OLAPFilterRel(RelOptCluster cluster, RelTraitSet traits, RelNode child, RexNode condition) {
        super(cluster, traits, child, condition);
        Preconditions.checkArgument((this.getConvention() == CONVENTION ? 1 : 0) != 0);
        Preconditions.checkArgument((this.getConvention() == child.getConvention() ? 1 : 0) != 0);
        this.rowType = this.getRowType();
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner) {
        return super.computeSelfCost(planner).multiplyBy(0.05);
    }

    public Filter copy(RelTraitSet traitSet, RelNode input, RexNode condition) {
        return new OLAPFilterRel(this.getCluster(), traitSet, input, condition);
    }

    @Override
    public void implementOLAP(OLAPRel.OLAPImplementor implementor) {
        implementor.visitChild(this.getInput(), this);
        this.columnRowType = this.buildColumnRowType();
        this.context = implementor.getContext();
        if (!this.context.afterAggregate) {
            this.translateFilter(this.context);
        }
    }

    private ColumnRowType buildColumnRowType() {
        OLAPRel olapChild = (OLAPRel)this.getInput();
        ColumnRowType inputColumnRowType = olapChild.getColumnRowType();
        return inputColumnRowType;
    }

    private void translateFilter(OLAPContext context) {
        if (this.condition == null) {
            return;
        }
        TupleFilterVisitor visitor = new TupleFilterVisitor(this.columnRowType, context);
        context.filter = (TupleFilter)this.condition.accept((RexVisitor)visitor);
        context.filterColumns = this.collectColumns(context.filter);
    }

    private Set<TblColRef> collectColumns(TupleFilter filter) {
        HashSet ret = Sets.newHashSet();
        this.collectColumnsRecursively(filter, ret);
        return ret;
    }

    private void collectColumnsRecursively(TupleFilter filter, Set<TblColRef> collector) {
        if (filter instanceof ColumnTupleFilter) {
            collector.add(((ColumnTupleFilter)filter).getColumn());
        }
        for (TupleFilter child : filter.getChildren()) {
            this.collectColumnsRecursively(child, collector);
        }
    }

    @Override
    public EnumerableRel implementEnumerable(List<EnumerableRel> inputs) {
        RexBuilder rexBuilder = this.getCluster().getRexBuilder();
        RelDataType inputRowType = this.getInput().getRowType();
        RexProgramBuilder programBuilder = new RexProgramBuilder(inputRowType, rexBuilder);
        programBuilder.addIdentity();
        programBuilder.addCondition(this.condition);
        RexProgram program = programBuilder.getProgram();
        return new EnumerableCalc(this.getCluster(), this.getCluster().traitSetOf((RelTrait)EnumerableConvention.INSTANCE), (RelNode)OLAPFilterRel.sole(inputs), program);
    }

    @Override
    public void implementRewrite(OLAPRel.RewriteImplementor implementor) {
        implementor.visitChild(this, this.getInput());
        this.rowType = this.deriveRowType();
        this.columnRowType = this.buildColumnRowType();
    }

    @Override
    public OLAPContext getContext() {
        return this.context;
    }

    @Override
    public ColumnRowType getColumnRowType() {
        return this.columnRowType;
    }

    @Override
    public boolean hasSubQuery() {
        OLAPRel olapChild = (OLAPRel)this.getInput();
        return olapChild.hasSubQuery();
    }

    @Override
    public RelTraitSet replaceTraitSet(RelTrait trait) {
        RelTraitSet oldTraitSet = this.traitSet;
        this.traitSet = this.traitSet.replace(trait);
        return oldTraitSet;
    }

    private static class TupleFilterVisitor
    extends RexVisitorImpl<TupleFilter> {
        private final ColumnRowType inputRowType;
        private final OLAPContext context;

        public TupleFilterVisitor(ColumnRowType inputRowType, OLAPContext context) {
            super(true);
            this.inputRowType = inputRowType;
            this.context = context;
        }

        public TupleFilter visitCall(RexCall call) {
            CompareTupleFilter inFilter;
            CaseTupleFilter filter = null;
            SqlOperator op = call.getOperator();
            switch (op.getKind()) {
                case AND: {
                    filter = new LogicalTupleFilter(TupleFilter.FilterOperatorEnum.AND);
                    break;
                }
                case OR: {
                    filter = new LogicalTupleFilter(TupleFilter.FilterOperatorEnum.OR);
                    break;
                }
                case NOT: {
                    filter = new LogicalTupleFilter(TupleFilter.FilterOperatorEnum.NOT);
                    break;
                }
                case EQUALS: {
                    filter = new CompareTupleFilter(TupleFilter.FilterOperatorEnum.EQ);
                    break;
                }
                case GREATER_THAN: {
                    filter = new CompareTupleFilter(TupleFilter.FilterOperatorEnum.GT);
                    break;
                }
                case LESS_THAN: {
                    filter = new CompareTupleFilter(TupleFilter.FilterOperatorEnum.LT);
                    break;
                }
                case GREATER_THAN_OR_EQUAL: {
                    filter = new CompareTupleFilter(TupleFilter.FilterOperatorEnum.GTE);
                    break;
                }
                case LESS_THAN_OR_EQUAL: {
                    filter = new CompareTupleFilter(TupleFilter.FilterOperatorEnum.LTE);
                    break;
                }
                case NOT_EQUALS: {
                    filter = new CompareTupleFilter(TupleFilter.FilterOperatorEnum.NEQ);
                    break;
                }
                case IS_NULL: {
                    filter = new CompareTupleFilter(TupleFilter.FilterOperatorEnum.ISNULL);
                    break;
                }
                case IS_NOT_NULL: {
                    filter = new CompareTupleFilter(TupleFilter.FilterOperatorEnum.ISNOTNULL);
                    break;
                }
                case CAST: 
                case REINTERPRET: {
                    break;
                }
                case CASE: {
                    filter = new CaseTupleFilter();
                    break;
                }
                case OTHER: {
                    if (op.getName().equalsIgnoreCase("extract_date")) {
                        filter = new ExtractTupleFilter(TupleFilter.FilterOperatorEnum.EXTRACT);
                        break;
                    }
                    throw new UnsupportedOperationException(op.getName());
                }
                default: {
                    throw new UnsupportedOperationException(op.getName());
                }
            }
            for (RexNode operand : call.operands) {
                TupleFilter childFilter = (TupleFilter)operand.accept((RexVisitor)this);
                if (filter == null) {
                    filter = childFilter;
                    continue;
                }
                filter.addChild(childFilter);
            }
            if (op.getKind() == SqlKind.OR && (inFilter = this.mergeToInClause((TupleFilter)filter)) != null) {
                filter = inFilter;
            }
            return filter;
        }

        private CompareTupleFilter mergeToInClause(TupleFilter filter) {
            List children = filter.getChildren();
            TblColRef inColumn = null;
            LinkedList inValues = new LinkedList();
            for (TupleFilter child : children) {
                if (child.getOperator() == TupleFilter.FilterOperatorEnum.EQ) {
                    CompareTupleFilter compFilter = (CompareTupleFilter)child;
                    TblColRef column = compFilter.getColumn();
                    if (inColumn == null) {
                        inColumn = column;
                    }
                    if (column == null || !column.equals((Object)inColumn)) {
                        return null;
                    }
                    inValues.addAll(compFilter.getValues());
                    continue;
                }
                return null;
            }
            children.clear();
            CompareTupleFilter inFilter = new CompareTupleFilter(TupleFilter.FilterOperatorEnum.IN);
            inFilter.addChild((TupleFilter)new ColumnTupleFilter(inColumn));
            inFilter.addChild((TupleFilter)new ConstantTupleFilter(inValues));
            return inFilter;
        }

        public TupleFilter visitLocalRef(RexLocalRef localRef) {
            throw new UnsupportedOperationException("local ref:" + localRef);
        }

        public TupleFilter visitInputRef(RexInputRef inputRef) {
            TblColRef column = this.inputRowType.getColumnByIndex(inputRef.getIndex());
            this.context.allColumns.add(column);
            ColumnTupleFilter filter = new ColumnTupleFilter(column);
            return filter;
        }

        private String normToTwoDigits(int i) {
            if (i < 10) {
                return "0" + i;
            }
            return "" + i;
        }

        public TupleFilter visitLiteral(RexLiteral literal) {
            Object strValue = null;
            Comparable literalValue = literal.getValue();
            if (literalValue instanceof NlsString) {
                strValue = ((NlsString)literalValue).getValue();
            } else if (literalValue instanceof GregorianCalendar) {
                GregorianCalendar g = (GregorianCalendar)literalValue;
                strValue = "" + g.get(1) + "-" + this.normToTwoDigits(g.get(2) + 1) + "-" + this.normToTwoDigits(g.get(5));
            } else {
                strValue = literalValue instanceof TimeUnitRange ? ((TimeUnitRange)literalValue).name() : (literalValue == null ? null : literalValue.toString());
            }
            ConstantTupleFilter filter = new ConstantTupleFilter((String)strValue);
            return filter;
        }

        public TupleFilter visitDynamicParam(RexDynamicParam dynamicParam) {
            String name = dynamicParam.getName();
            DynamicTupleFilter filter = new DynamicTupleFilter(name);
            return filter;
        }
    }
}

