/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.relnode;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Stack;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.kylin.query.relnode.ColumnRowType;
import org.apache.kylin.query.relnode.OLAPContext;
import org.apache.kylin.query.relnode.OLAPTableScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface OLAPRel
extends RelNode {
    public static final Logger logger = LoggerFactory.getLogger(OLAPRel.class);
    public static final Convention CONVENTION = new Convention.Impl("OLAP", OLAPRel.class);

    public OLAPContext getContext();

    public ColumnRowType getColumnRowType();

    public boolean hasSubQuery();

    public RelTraitSet replaceTraitSet(RelTrait var1);

    public void implementOLAP(OLAPImplementor var1);

    public void implementRewrite(RewriteImplementor var1);

    public EnumerableRel implementEnumerable(List<EnumerableRel> var1);

    public static class JavaImplementor
    extends EnumerableRelImplementor {
        private IdentityHashMap<EnumerableRel, OLAPContext> relContexts = Maps.newIdentityHashMap();
        private boolean calciteDebug = System.getProperty("calcite.debug") != null;

        public JavaImplementor(EnumerableRelImplementor enumImplementor) {
            super(enumImplementor.getRexBuilder(), new LinkedHashMap());
        }

        public EnumerableRel createEnumerable(OLAPRel parent) {
            ArrayList enumInputs = null;
            List children = parent.getInputs();
            if (children != null) {
                enumInputs = Lists.newArrayListWithCapacity((int)children.size());
                for (RelNode child : children) {
                    enumInputs.add(this.createEnumerable((OLAPRel)child));
                }
            }
            EnumerableRel result = parent.implementEnumerable(enumInputs);
            this.relContexts.put(result, parent.getContext());
            return result;
        }

        public EnumerableRel.Result visitChild(EnumerableRel parent, int ordinal, EnumerableRel child, EnumerableRel.Prefer prefer) {
            OLAPContext parentContext;
            if (child instanceof OLAPTableScan && (parentContext = this.relContexts.get(parent)) != null) {
                ((OLAPTableScan)child).overrideContext(parentContext);
            }
            if (this.calciteDebug) {
                OLAPContext context = child instanceof OLAPRel ? ((OLAPRel)child).getContext() : this.relContexts.get(child);
                System.out.println(context + " - " + child);
            }
            return super.visitChild(parent, ordinal, child, prefer);
        }
    }

    public static class RewriteImplementor {
        private OLAPContext parentContext;

        public void visitChild(RelNode parent, RelNode child) {
            if (parent instanceof OLAPRel) {
                OLAPRel olapRel = (OLAPRel)parent;
                this.parentContext = olapRel.getContext();
            }
            OLAPRel olapChild = (OLAPRel)child;
            olapChild.implementRewrite(this);
        }

        public OLAPContext getParentContext() {
            return this.parentContext;
        }

        public static boolean needRewrite(OLAPContext ctx) {
            boolean hasFactTable = ctx.hasJoin || ctx.firstTableScan.getTableName().equals(ctx.realization.getFactTable());
            boolean hasRewriteFields = !ctx.rewriteFields.isEmpty();
            return hasRewriteFields && hasFactTable;
        }
    }

    public static class OLAPImplementor {
        private RelNode parentNode = null;
        private int ctxSeq = 0;
        private Stack<OLAPContext> ctxStack = new Stack();

        public void visitChild(RelNode input, RelNode parentNode) {
            this.parentNode = parentNode;
            ((OLAPRel)input).implementOLAP(this);
        }

        public RelNode getParentNode() {
            return this.parentNode;
        }

        public OLAPContext getContext() {
            if (this.ctxStack.isEmpty()) {
                return null;
            }
            return this.ctxStack.peek();
        }

        public void freeContext() {
            this.ctxStack.pop();
        }

        public void allocateContext() {
            OLAPContext context = new OLAPContext(this.ctxSeq++);
            this.ctxStack.push(context);
            OLAPContext.registerContext(context);
        }
    }
}

