/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.enumerator;

import org.apache.calcite.DataContext;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.kylin.query.enumerator.CubeEnumerator;
import org.apache.kylin.query.enumerator.HiveEnumerator;
import org.apache.kylin.query.enumerator.LookupTableEnumerator;
import org.apache.kylin.query.relnode.OLAPContext;

public class OLAPQuery
extends AbstractEnumerable<Object[]>
implements Enumerable<Object[]> {
    public static final String PROP_SCAN_THRESHOLD = "scan_threshold";
    private final DataContext optiqContext;
    private final EnumeratorTypeEnum type;
    private final int contextId;

    public OLAPQuery(DataContext optiqContext, EnumeratorTypeEnum type, int ctxId) {
        this.optiqContext = optiqContext;
        this.type = type;
        this.contextId = ctxId;
    }

    public OLAPQuery(EnumeratorTypeEnum type, int ctxSeq) {
        this(null, type, ctxSeq);
    }

    public Enumerator<Object[]> enumerator() {
        OLAPContext olapContext = OLAPContext.getThreadLocalContextById(this.contextId);
        switch (this.type) {
            case INDEX: {
                return new CubeEnumerator(olapContext, this.optiqContext);
            }
            case LOOKUP_TABLE: {
                return new LookupTableEnumerator(olapContext);
            }
            case HIVE: {
                return new HiveEnumerator(olapContext);
            }
        }
        throw new IllegalArgumentException("Wrong type " + (Object)((Object)this.type) + "!");
    }

    public static enum EnumeratorTypeEnum {
        INDEX,
        LOOKUP_TABLE,
        HIVE;

    }
}

