/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.enumerator;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.model.DimensionDesc;
import org.apache.kylin.dict.lookup.LookupStringTable;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.query.relnode.OLAPContext;
import org.apache.kylin.query.schema.OLAPTable;
import org.apache.kylin.storage.hybrid.HybridInstance;
import org.apache.kylin.storage.tuple.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LookupTableEnumerator
implements Enumerator<Object[]> {
    private final Collection<String[]> allRows;
    private final List<ColumnDesc> colDescs;
    private final Object[] current;
    private Iterator<String[]> iterator;
    private static final Logger logger = LoggerFactory.getLogger(LookupTableEnumerator.class);

    public LookupTableEnumerator(OLAPContext olapContext) {
        CubeInstance cube = null;
        if (olapContext.realization instanceof CubeInstance) {
            cube = (CubeInstance)olapContext.realization;
        } else if (olapContext.realization instanceof HybridInstance) {
            HybridInstance hybridInstance = (HybridInstance)olapContext.realization;
            IRealization latestRealization = hybridInstance.getLatestRealization();
            if (latestRealization instanceof CubeInstance) {
                cube = (CubeInstance)latestRealization;
            } else {
                throw new IllegalStateException();
            }
        }
        String lookupTableName = olapContext.firstTableScan.getTableName();
        DimensionDesc dim = cube.getDescriptor().findDimensionByTable(lookupTableName);
        if (dim == null) {
            throw new IllegalStateException("No dimension with derived columns found for lookup table " + lookupTableName + ", cube desc " + cube.getDescriptor());
        }
        CubeManager cubeMgr = CubeManager.getInstance((KylinConfig)cube.getConfig());
        LookupStringTable table = cubeMgr.getLookupTable(cube.getLatestReadySegment(), dim);
        this.allRows = table.getAllRows();
        OLAPTable olapTable = olapContext.firstTableScan.getOlapTable();
        this.colDescs = olapTable.getExposedColumns();
        this.current = new Object[this.colDescs.size()];
        this.reset();
    }

    public boolean moveNext() {
        boolean hasNext = this.iterator.hasNext();
        if (hasNext) {
            String[] row = this.iterator.next();
            int n = this.colDescs.size();
            for (int i = 0; i < n; ++i) {
                ColumnDesc colDesc = this.colDescs.get(i);
                int colIdx = colDesc.getZeroBasedIndex();
                this.current[i] = colIdx >= 0 ? Tuple.convertOptiqCellValue((String)row[colIdx], (String)colDesc.getType().getName()) : null;
            }
        }
        return hasNext;
    }

    public Object[] current() {
        return Arrays.copyOf(this.current, this.current.length);
    }

    public void reset() {
        this.iterator = this.allRows.iterator();
    }

    public void close() {
    }
}

