/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.routing.RoutingRules;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.query.relnode.OLAPContext;
import org.apache.kylin.query.routing.RoutingRule;
import org.apache.kylin.query.routing.RoutingRules.RealizationPriorityRule;
import org.apache.kylin.storage.hybrid.HybridInstance;

public class RealizationSortRule
extends RoutingRule {
    @Override
    public void apply(List<IRealization> realizations, final OLAPContext olapContext) {
        Collections.sort(realizations, new Comparator<IRealization>(){

            @Override
            public int compare(IRealization o1, IRealization o2) {
                int i2;
                int i1 = RealizationPriorityRule.priorities.get(o1.getType());
                int comp = i1 - (i2 = RealizationPriorityRule.priorities.get(o2.getType()).intValue());
                if (comp != 0) {
                    return comp;
                }
                comp = o1.getCost(olapContext.getSQLDigest()) - o2.getCost(olapContext.getSQLDigest());
                if (comp != 0) {
                    return comp;
                }
                if (o1 instanceof HybridInstance) {
                    return -1;
                }
                if (o2 instanceof HybridInstance) {
                    return 1;
                }
                return 0;
            }
        });
    }
}

