/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.relnode;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.adapter.enumerable.EnumerableCalc;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlCaseOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.validate.SqlUserDefinedFunction;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.query.relnode.ColumnRowType;
import org.apache.kylin.query.relnode.OLAPContext;
import org.apache.kylin.query.relnode.OLAPFilterRel;
import org.apache.kylin.query.relnode.OLAPRel;

public class OLAPProjectRel
extends Project
implements OLAPRel {
    private OLAPContext context;
    private List<RexNode> rewriteProjects;
    private boolean rewriting;
    private ColumnRowType columnRowType;
    private boolean hasJoin;
    private boolean afterJoin;
    private boolean afterAggregate;

    public OLAPProjectRel(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, List<RexNode> exps, RelDataType rowType) {
        super(cluster, traitSet, child, exps, rowType);
        Preconditions.checkArgument((this.getConvention() == OLAPRel.CONVENTION ? 1 : 0) != 0);
        Preconditions.checkArgument((child.getConvention() == OLAPRel.CONVENTION ? 1 : 0) != 0);
        this.rewriteProjects = exps;
        this.hasJoin = false;
        this.afterJoin = false;
        this.rowType = this.getRowType();
    }

    public List<RexNode> getChildExps() {
        return this.rewriteProjects;
    }

    public List<RexNode> getProjects() {
        return this.rewriteProjects;
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner) {
        return super.computeSelfCost(planner).multiplyBy(0.05);
    }

    public Project copy(RelTraitSet traitSet, RelNode child, List<RexNode> exps, RelDataType rowType) {
        return new OLAPProjectRel(this.getCluster(), traitSet, child, exps, rowType);
    }

    @Override
    public void implementOLAP(OLAPRel.OLAPImplementor implementor) {
        implementor.visitChild(this.getInput(), this);
        this.context = implementor.getContext();
        this.hasJoin = this.context.hasJoin;
        this.afterJoin = this.context.afterJoin;
        this.afterAggregate = this.context.afterAggregate;
        this.columnRowType = this.buildColumnRowType();
    }

    private ColumnRowType buildColumnRowType() {
        ArrayList<TblColRef> columns = new ArrayList<TblColRef>();
        ArrayList<Set<TblColRef>> sourceColumns = new ArrayList<Set<TblColRef>>();
        OLAPRel olapChild = (OLAPRel)this.getInput();
        ColumnRowType inputColumnRowType = olapChild.getColumnRowType();
        for (int i = 0; i < this.rewriteProjects.size(); ++i) {
            HashSet<TblColRef> sourceCollector;
            RelDataTypeField columnField;
            String fieldName;
            RexNode rex = this.rewriteProjects.get(i);
            TblColRef column = this.translateRexNode(rex, inputColumnRowType, fieldName = (columnField = (RelDataTypeField)this.rowType.getFieldList().get(i)).getName(), sourceCollector = new HashSet<TblColRef>());
            if (column == null) {
                throw new IllegalStateException("No TblColRef found in " + rex);
            }
            columns.add(column);
            sourceColumns.add(sourceCollector);
        }
        return new ColumnRowType(columns, sourceColumns);
    }

    private TblColRef translateFirstRexInputRef(RexCall call, ColumnRowType inputColumnRowType, String fieldName, Set<TblColRef> sourceCollector) {
        for (RexNode operand : call.getOperands()) {
            TblColRef r;
            if (operand instanceof RexInputRef) {
                return this.translateRexInputRef((RexInputRef)operand, inputColumnRowType, fieldName, sourceCollector);
            }
            if (!(operand instanceof RexCall) || (r = this.translateFirstRexInputRef((RexCall)operand, inputColumnRowType, fieldName, sourceCollector)) == null) continue;
            return r;
        }
        return null;
    }

    private TblColRef translateRexNode(RexNode rexNode, ColumnRowType inputColumnRowType, String fieldName, Set<TblColRef> sourceCollector) {
        TblColRef column = null;
        if (rexNode instanceof RexInputRef) {
            RexInputRef inputRef = (RexInputRef)rexNode;
            column = this.translateRexInputRef(inputRef, inputColumnRowType, fieldName, sourceCollector);
        } else if (rexNode instanceof RexLiteral) {
            RexLiteral literal = (RexLiteral)rexNode;
            column = this.translateRexLiteral(literal);
        } else if (rexNode instanceof RexCall) {
            RexCall call = (RexCall)rexNode;
            column = this.translateRexCall(call, inputColumnRowType, fieldName, sourceCollector);
        } else {
            throw new IllegalStateException("Unsupport RexNode " + rexNode);
        }
        return column;
    }

    private TblColRef translateRexInputRef(RexInputRef inputRef, ColumnRowType inputColumnRowType, String fieldName, Set<TblColRef> sourceCollector) {
        int index = inputRef.getIndex();
        if (index < inputColumnRowType.size()) {
            TblColRef column = inputColumnRowType.getColumnByIndex(index);
            if (!(column.isInnerColumn() || this.rewriting || this.afterAggregate)) {
                this.context.allColumns.add(column);
                sourceCollector.add(column);
            }
            return column;
        }
        throw new IllegalStateException("Can't find " + inputRef + " from child columnrowtype " + inputColumnRowType + " with fieldname " + fieldName);
    }

    private TblColRef translateRexLiteral(RexLiteral literal) {
        if (RexLiteral.isNullLiteral((RexNode)literal)) {
            return TblColRef.newInnerColumn((String)"null", (TblColRef.InnerDataTypeEnum)TblColRef.InnerDataTypeEnum.LITERAL);
        }
        return TblColRef.newInnerColumn((String)literal.getValue().toString(), (TblColRef.InnerDataTypeEnum)TblColRef.InnerDataTypeEnum.LITERAL);
    }

    private TblColRef translateRexCall(RexCall call, ColumnRowType inputColumnRowType, String fieldName, Set<TblColRef> sourceCollector) {
        SqlOperator operator = call.getOperator();
        if (operator == SqlStdOperatorTable.EXTRACT_DATE) {
            return this.translateFirstRexInputRef(call, inputColumnRowType, fieldName, sourceCollector);
        }
        if (operator instanceof SqlUserDefinedFunction) {
            if (operator.getName().equals("QUARTER")) {
                return this.translateFirstRexInputRef(call, inputColumnRowType, fieldName, sourceCollector);
            }
        } else if (operator instanceof SqlCaseOperator) {
            for (RexNode operand : call.getOperands()) {
                if (!(operand instanceof RexInputRef)) continue;
                RexInputRef inputRef = (RexInputRef)operand;
                return this.translateRexInputRef(inputRef, inputColumnRowType, fieldName, sourceCollector);
            }
        }
        for (RexNode operand : call.getOperands()) {
            this.translateRexNode(operand, inputColumnRowType, fieldName, sourceCollector);
        }
        return TblColRef.newInnerColumn((String)fieldName, (TblColRef.InnerDataTypeEnum)TblColRef.InnerDataTypeEnum.LITERAL);
    }

    @Override
    public EnumerableRel implementEnumerable(List<EnumerableRel> inputs) {
        if (this.getInput() instanceof OLAPFilterRel) {
            OLAPFilterRel filter = (OLAPFilterRel)this.getInput();
            RelNode inputOfFilter = inputs.get(0).getInput(0);
            RexProgram program = RexProgram.create((RelDataType)inputOfFilter.getRowType(), this.rewriteProjects, (RexNode)filter.getCondition(), (RelDataType)this.rowType, (RexBuilder)this.getCluster().getRexBuilder());
            return new EnumerableCalc(this.getCluster(), this.getCluster().traitSetOf((RelTrait)EnumerableConvention.INSTANCE), inputOfFilter, program);
        }
        EnumerableRel input = (EnumerableRel)OLAPProjectRel.sole(inputs);
        RexProgram program = RexProgram.create((RelDataType)input.getRowType(), this.rewriteProjects, null, (RelDataType)this.rowType, (RexBuilder)this.getCluster().getRexBuilder());
        return new EnumerableCalc(this.getCluster(), this.getCluster().traitSetOf((RelTrait)EnumerableConvention.INSTANCE), (RelNode)input, program);
    }

    @Override
    public ColumnRowType getColumnRowType() {
        return this.columnRowType;
    }

    @Override
    public void implementRewrite(OLAPRel.RewriteImplementor implementor) {
        implementor.visitChild(this, this.getInput());
        this.rewriting = true;
        if (!OLAPRel.RewriteImplementor.needRewrite(this.context) || this.hasJoin && !this.afterJoin || this.afterAggregate) {
            this.columnRowType = this.buildColumnRowType();
            return;
        }
        int paramIndex = this.rowType.getFieldList().size();
        LinkedList<RelDataTypeFieldImpl> newFieldList = new LinkedList<RelDataTypeFieldImpl>();
        LinkedList<RexInputRef> newExpList = new LinkedList<RexInputRef>();
        ColumnRowType inputColumnRowType = ((OLAPRel)this.getInput()).getColumnRowType();
        for (Map.Entry<String, RelDataType> rewriteField : this.context.rewriteFields.entrySet()) {
            int inputIndex;
            String rewriteFieldName = rewriteField.getKey();
            int rowIndex = this.columnRowType.getIndexByName(rewriteFieldName);
            if (rowIndex >= 0 || (inputIndex = inputColumnRowType.getIndexByName(rewriteFieldName)) < 0) continue;
            RelDataType fieldType = rewriteField.getValue();
            RelDataTypeFieldImpl newField = new RelDataTypeFieldImpl(rewriteFieldName, paramIndex++, fieldType);
            newFieldList.add(newField);
            RelDataTypeField inputField = (RelDataTypeField)this.getInput().getRowType().getFieldList().get(inputIndex);
            RexInputRef newFieldRef = new RexInputRef(inputField.getIndex(), inputField.getType());
            newExpList.add(newFieldRef);
        }
        if (!newFieldList.isEmpty()) {
            ArrayList<RexNode> newProjects = new ArrayList<RexNode>(this.rewriteProjects);
            newProjects.addAll(newExpList);
            this.rewriteProjects = newProjects;
            RelDataTypeFactory.FieldInfoBuilder fieldInfo = this.getCluster().getTypeFactory().builder();
            fieldInfo.addAll((Iterable)this.rowType.getFieldList());
            fieldInfo.addAll(newFieldList);
            this.rowType = this.getCluster().getTypeFactory().createStructType((RelDataTypeFactory.FieldInfo)fieldInfo);
        }
        this.columnRowType = this.buildColumnRowType();
        this.rewriting = false;
    }

    @Override
    public OLAPContext getContext() {
        return this.context;
    }

    @Override
    public boolean hasSubQuery() {
        OLAPRel olapChild = (OLAPRel)this.getInput();
        return olapChild.hasSubQuery();
    }

    @Override
    public RelTraitSet replaceTraitSet(RelTrait trait) {
        RelTraitSet oldTraitSet = this.traitSet;
        this.traitSet = this.traitSet.replace(trait);
        return oldTraitSet;
    }
}

