/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.relnode;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.kylin.metadata.model.TblColRef;

public class ColumnRowType {
    private List<TblColRef> columns;
    private List<Set<TblColRef>> sourceColumns;

    public ColumnRowType(List<TblColRef> columns) {
        this(columns, null);
    }

    public ColumnRowType(List<TblColRef> columns, List<Set<TblColRef>> sourceColumns) {
        this.columns = columns;
        this.sourceColumns = sourceColumns;
    }

    public TblColRef getColumnByIndex(int index) {
        return this.columns.get(index);
    }

    public int getIndexByName(String columnName) {
        for (int i = 0; i < this.columns.size(); ++i) {
            if (!this.columns.get(i).getName().equals(columnName)) continue;
            return i;
        }
        return -1;
    }

    public Set<TblColRef> getSourceColumnsByIndex(int i) {
        Set<TblColRef> result = null;
        if (this.sourceColumns != null) {
            result = this.sourceColumns.get(i);
        }
        if (result == null || result.isEmpty()) {
            result = Collections.singleton(this.getColumnByIndex(i));
        }
        return result;
    }

    public List<TblColRef> getAllColumns() {
        return this.columns;
    }

    public int size() {
        return this.columns.size();
    }

    public String toString() {
        return "ColumnRowType [" + this.columns + "]";
    }
}

