/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.test;

import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.LogManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.dbunit.Assertion;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.SortedTable;
import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.datatype.DataTypeException;
import org.dbunit.ext.h2.H2Connection;
import org.dbunit.ext.h2.H2DataTypeFactory;
import org.junit.Assert;

public class KylinTestBase {
    protected static final String resultTableName = "query result of ";
    protected static KylinConfig config = null;
    protected static Connection cubeConnection = null;
    protected static Connection h2Connection = null;
    protected static String joinType = "default";
    protected static int h2InstanceCount = 0;
    protected static int compQueryCount = 0;
    protected static ArrayList<String> zeroResultQueries = new ArrayList();

    protected static void closeConnection(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    protected static List<File> getFilesFromFolder(File folder, String fileType) {
        ArrayList<File> files = new ArrayList<File>();
        for (File fileEntry : folder.listFiles()) {
            if (!fileEntry.getName().toLowerCase().endsWith(fileType.toLowerCase())) continue;
            files.add(fileEntry);
        }
        return files;
    }

    protected static void getFilesFromFolderR(String directoryStr, List<File> files, String fileType) {
        File folder = new File(directoryStr);
        for (File fileEntry : folder.listFiles()) {
            if (fileEntry.isDirectory()) {
                KylinTestBase.getFilesFromFolderR(fileEntry.getAbsolutePath(), files, fileType);
                continue;
            }
            if (!fileEntry.isFile() || !fileEntry.getName().toLowerCase().endsWith(fileType.toLowerCase())) continue;
            files.add(fileEntry);
        }
    }

    protected static void putTextTofile(File file, String sql) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        writer.write(sql, 0, sql.length());
        writer.close();
    }

    protected static String getTextFromFile(File file) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String line = null;
        StringBuilder stringBuilder = new StringBuilder();
        String ls = System.getProperty("line.separator");
        while ((line = reader.readLine()) != null) {
            stringBuilder.append(line);
            stringBuilder.append(ls);
        }
        reader.close();
        return stringBuilder.toString();
    }

    protected static List<String> getParameterFromFile(File sqlFile) throws IOException {
        String sqlFileName = sqlFile.getAbsolutePath();
        int prefixIndex = sqlFileName.lastIndexOf(".sql");
        String dataFielName = sqlFileName.substring(0, prefixIndex) + ".dat";
        File dataFile = new File(dataFielName);
        List parameters = Files.readLines((File)dataFile, (Charset)Charset.defaultCharset());
        return parameters;
    }

    protected static void printInfo(String info) {
        System.out.println(new Timestamp(System.currentTimeMillis()) + " - " + info);
    }

    protected static void printResult(ITable resultTable) throws DataSetException {
        int i;
        StringBuilder sb = new StringBuilder();
        int columnCount = resultTable.getTableMetaData().getColumns().length;
        String[] columns = new String[columnCount];
        for (i = 0; i < columnCount; ++i) {
            sb.append(resultTable.getTableMetaData().getColumns()[i].getColumnName());
            sb.append("-");
            sb.append(resultTable.getTableMetaData().getColumns()[i].getDataType());
            sb.append("\t");
            columns[i] = resultTable.getTableMetaData().getColumns()[i].getColumnName();
        }
        sb.append("\n");
        for (i = 0; i < resultTable.getRowCount(); ++i) {
            for (int j = 0; j < columns.length; ++j) {
                sb.append(resultTable.getValue(i, columns[j]));
                sb.append("\t");
            }
            sb.append("\n");
        }
        System.out.println(sb.toString());
    }

    protected Set<String> buildExclusiveSet(String[] exclusiveQuerys) {
        HashSet<String> exclusiveSet = new HashSet<String>();
        if (exclusiveQuerys != null) {
            for (String query : exclusiveQuerys) {
                exclusiveSet.add(query);
            }
        }
        return exclusiveSet;
    }

    protected ITable executeQuery(IDatabaseConnection dbConn, String queryName, String sql, boolean needSort) throws Exception {
        sql = KylinTestBase.changeJoinType(sql, joinType);
        ITable queryTable = dbConn.createQueryTable(resultTableName + queryName, sql);
        String[] columnNames = new String[queryTable.getTableMetaData().getColumns().length];
        for (int i = 0; i < columnNames.length; ++i) {
            columnNames[i] = queryTable.getTableMetaData().getColumns()[i].getColumnName();
        }
        if (needSort) {
            queryTable = new SortedTable(queryTable, columnNames);
        }
        return queryTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int executeQuery(String sql, boolean needDisplay) throws SQLException {
        sql = KylinTestBase.changeJoinType(sql, joinType);
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            KylinTestBase.printInfo("start running...");
            statement = cubeConnection.createStatement();
            resultSet = statement.executeQuery(sql);
            KylinTestBase.printInfo("stop running...");
            int n = this.output(resultSet, needDisplay);
            return n;
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException e) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    protected ITable executeDynamicQuery(IDatabaseConnection dbConn, String queryName, String sql, List<String> parameters, boolean needSort) throws Exception {
        sql = KylinTestBase.changeJoinType(sql, joinType);
        PreparedStatement prepStat = dbConn.getConnection().prepareStatement(sql);
        for (int j = 1; j <= parameters.size(); ++j) {
            prepStat.setString(j, parameters.get(j - 1).trim());
        }
        ITable queryTable = dbConn.createTable(resultTableName + queryName, prepStat);
        String[] columnNames = new String[queryTable.getTableMetaData().getColumns().length];
        for (int i = 0; i < columnNames.length; ++i) {
            columnNames[i] = queryTable.getTableMetaData().getColumns()[i].getColumnName();
        }
        if (needSort) {
            queryTable = new SortedTable(queryTable, columnNames);
        }
        return queryTable;
    }

    protected static String changeJoinType(String sql, String targetType) {
        if (targetType.equalsIgnoreCase("default")) {
            return sql;
        }
        String specialStr = "changeJoinType_DELIMITERS";
        sql = sql.replaceAll(System.getProperty("line.separator"), " " + specialStr + " ");
        Object[] tokens = StringUtils.split((String)sql, null);
        for (int i = 0; i < tokens.length - 1; ++i) {
            if (!tokens[i].equalsIgnoreCase("inner") && !((String)tokens[i]).equalsIgnoreCase("left") || !((String)tokens[i + 1]).equalsIgnoreCase("join")) continue;
            tokens[i] = targetType.toLowerCase();
        }
        String ret = StringUtils.join((Object[])tokens, (String)" ");
        ret = ret.replaceAll(specialStr, System.getProperty("line.separator"));
        System.out.println("The actual sql executed is: " + ret);
        return ret;
    }

    protected static void batchChangeJoinType(String targetType) throws IOException {
        LinkedList<File> files = new LinkedList<File>();
        KylinTestBase.getFilesFromFolderR("src/test/resources/query", files, ".sql");
        for (File file : files) {
            String x = KylinTestBase.changeJoinType(KylinTestBase.getTextFromFile(file), targetType);
            KylinTestBase.putTextTofile(file, x);
        }
    }

    protected void execQueryUsingH2(String queryFolder, boolean needSort) throws Exception {
        KylinTestBase.printInfo("---------- Running H2 queries: " + queryFolder);
        List<File> sqlFiles = KylinTestBase.getFilesFromFolder(new File(queryFolder), ".sql");
        for (File sqlFile : sqlFiles) {
            String queryName = StringUtils.split((String)sqlFile.getName(), (char)'.')[0];
            String sql = KylinTestBase.getTextFromFile(sqlFile);
            KylinTestBase.printInfo("Query Result from H2 - " + queryName);
            H2Connection h2Conn = new H2Connection(h2Connection, null);
            h2Conn.getConfig().setProperty("http://www.dbunit.org/properties/datatypeFactory", (Object)new TestH2DataTypeFactory());
            this.executeQuery((IDatabaseConnection)h2Conn, queryName, sql, needSort);
        }
    }

    protected void verifyResultRowCount(String queryFolder) throws Exception {
        KylinTestBase.printInfo("---------- verify result count in folder: " + queryFolder);
        List<File> sqlFiles = KylinTestBase.getFilesFromFolder(new File(queryFolder), ".sql");
        for (File sqlFile : sqlFiles) {
            String queryName = StringUtils.split((String)sqlFile.getName(), (char)'.')[0];
            String sql = KylinTestBase.getTextFromFile(sqlFile);
            File expectResultFile = new File(sqlFile.getParent(), sqlFile.getName() + ".expected");
            int expectRowCount = Integer.parseInt(Files.readFirstLine((File)expectResultFile, (Charset)Charset.defaultCharset()));
            KylinTestBase.printInfo("Query Result from Kylin - " + queryName + "  (" + queryFolder + ")");
            DatabaseConnection kylinConn = new DatabaseConnection(cubeConnection);
            ITable kylinTable = this.executeQuery((IDatabaseConnection)kylinConn, queryName, sql, false);
            Assert.assertEquals((long)expectRowCount, (long)kylinTable.getRowCount());
        }
    }

    protected void execAndCompQuery(String queryFolder, String[] exclusiveQuerys, boolean needSort) throws Exception {
        KylinTestBase.printInfo("---------- test folder: " + queryFolder);
        Set<String> exclusiveSet = this.buildExclusiveSet(exclusiveQuerys);
        List<File> sqlFiles = KylinTestBase.getFilesFromFolder(new File(queryFolder), ".sql");
        for (File sqlFile : sqlFiles) {
            String queryName = StringUtils.split((String)sqlFile.getName(), (char)'.')[0];
            if (exclusiveSet.contains(queryName)) continue;
            String sql = KylinTestBase.getTextFromFile(sqlFile);
            KylinTestBase.printInfo("Query Result from Kylin - " + queryName + "  (" + queryFolder + ")");
            DatabaseConnection kylinConn = new DatabaseConnection(cubeConnection);
            ITable kylinTable = this.executeQuery((IDatabaseConnection)kylinConn, queryName, sql, needSort);
            KylinTestBase.printInfo("Query Result from H2 - " + queryName);
            H2Connection h2Conn = new H2Connection(h2Connection, null);
            h2Conn.getConfig().setProperty("http://www.dbunit.org/properties/datatypeFactory", (Object)new TestH2DataTypeFactory());
            ITable h2Table = this.executeQuery((IDatabaseConnection)h2Conn, queryName, sql, needSort);
            Assertion.assertEquals((ITable)h2Table, (ITable)kylinTable);
            ++compQueryCount;
            if (kylinTable.getRowCount() != 0) continue;
            zeroResultQueries.add(sql);
        }
    }

    protected void execAndCompDynamicQuery(String queryFolder, String[] exclusiveQuerys, boolean needSort) throws Exception {
        KylinTestBase.printInfo("---------- test folder: " + queryFolder);
        Set<String> exclusiveSet = this.buildExclusiveSet(exclusiveQuerys);
        List<File> sqlFiles = KylinTestBase.getFilesFromFolder(new File(queryFolder), ".sql");
        for (File sqlFile : sqlFiles) {
            String queryName = StringUtils.split((String)sqlFile.getName(), (char)'.')[0];
            if (exclusiveSet.contains(queryName)) continue;
            String sql = KylinTestBase.getTextFromFile(sqlFile);
            List<String> parameters = KylinTestBase.getParameterFromFile(sqlFile);
            KylinTestBase.printInfo("Query Result from Kylin - " + queryName + "  (" + queryFolder + ")");
            DatabaseConnection kylinConn = new DatabaseConnection(cubeConnection);
            ITable kylinTable = this.executeDynamicQuery((IDatabaseConnection)kylinConn, queryName, sql, parameters, needSort);
            KylinTestBase.printInfo("Query Result from H2 - " + queryName);
            DatabaseConnection h2Conn = new DatabaseConnection(h2Connection);
            h2Conn.getConfig().setProperty("http://www.dbunit.org/properties/datatypeFactory", (Object)new TestH2DataTypeFactory());
            ITable h2Table = this.executeDynamicQuery((IDatabaseConnection)h2Conn, queryName, sql, parameters, needSort);
            Assertion.assertEquals((ITable)h2Table, (ITable)kylinTable);
        }
    }

    protected int runSqlFile(String file) throws Exception {
        return this.runSQL(new File(file), true, false);
    }

    protected int runSQL(File sqlFile, boolean debug, boolean explain) throws Exception {
        if (debug) {
            System.setProperty("calcite.debug", "true");
            FileInputStream inputStream = new FileInputStream("src/test/resources/logging.properties");
            LogManager.getLogManager().readConfiguration(inputStream);
        }
        String queryName = StringUtils.split((String)sqlFile.getName(), (char)'.')[0];
        KylinTestBase.printInfo("Testing Query " + queryName);
        String sql = KylinTestBase.getTextFromFile(sqlFile);
        if (explain) {
            sql = "explain plan for " + sql;
        }
        int count = this.executeQuery(sql, true);
        if (debug) {
            System.clearProperty("calcite.debug");
        }
        return count;
    }

    protected void batchExecuteQuery(String queryFolder) throws Exception {
        List<File> sqlFiles = KylinTestBase.getFilesFromFolder(new File(queryFolder), ".sql");
        for (File sqlFile : sqlFiles) {
            this.runSQL(sqlFile, false, false);
        }
    }

    protected int output(ResultSet resultSet, boolean needDisplay) throws SQLException {
        int i;
        int count = 0;
        ResultSetMetaData metaData = resultSet.getMetaData();
        int columnCount = metaData.getColumnCount();
        StringBuilder sb = new StringBuilder("\n");
        if (needDisplay) {
            for (i = 1; i <= columnCount; ++i) {
                sb.append(metaData.getColumnName(i));
                sb.append("-");
                sb.append(metaData.getTableName(i));
                sb.append("-");
                sb.append(metaData.getColumnTypeName(i));
                if (i < columnCount) {
                    sb.append("\t");
                    continue;
                }
                sb.append("\n");
            }
        }
        while (resultSet.next()) {
            if (needDisplay) {
                for (i = 1; i <= columnCount; ++i) {
                    sb.append(resultSet.getString(i));
                    if (i < columnCount) {
                        sb.append("\t");
                        continue;
                    }
                    sb.append("\n");
                }
            }
            ++count;
        }
        KylinTestBase.printInfo(sb.toString());
        return count;
    }

    public static class TestH2DataTypeFactory
    extends H2DataTypeFactory {
        public DataType createDataType(int sqlType, String sqlTypeName, String tableName, String columnName) throws DataTypeException {
            if ((columnName.startsWith("COL") || columnName.startsWith("col")) && sqlType == -5) {
                return DataType.INTEGER;
            }
            return super.createDataType(sqlType, sqlTypeName);
        }
    }
}

