/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.test;

import java.io.File;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.HBaseMetadataTestCase;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.query.relnode.OLAPContext;
import org.apache.kylin.query.schema.OLAPSchemaFactory;
import org.apache.kylin.query.test.H2Database;
import org.apache.kylin.query.test.KylinTestBase;
import org.apache.kylin.storage.hbase.coprocessor.observer.ObserverEnabler;
import org.apache.kylin.storage.hybrid.HybridManager;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.IDatabaseConnection;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

@Ignore(value="KylinQueryTest is contained by CombinationTest")
public class KylinQueryTest
extends KylinTestBase {
    @BeforeClass
    public static void setUp() throws Exception {
        KylinQueryTest.printInfo("setUp in KylinQueryTest");
        joinType = "left";
        KylinQueryTest.setupAll();
        KylinQueryTest.preferCubeOf(joinType);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        KylinQueryTest.printInfo("tearDown");
        KylinQueryTest.printInfo("Closing connection...");
        KylinQueryTest.clean();
    }

    protected static void setupAll() throws Exception {
        KylinQueryTest.setUpEnv();
        KylinQueryTest.setUpCubeConn();
        KylinQueryTest.setUpH2Conn();
    }

    private static void setUpEnv() throws Exception {
        HBaseMetadataTestCase.staticCreateTestMetadata();
        config = KylinConfig.getInstanceFromEnv();
    }

    private static void setUpCubeConn() throws SQLException {
        File olapTmp = OLAPSchemaFactory.createTempOLAPJson((String)"DEFAULT", (KylinConfig)config);
        Properties props = new Properties();
        props.setProperty("scan_threshold", "10000");
        cubeConnection = DriverManager.getConnection("jdbc:calcite:model=" + olapTmp.getAbsolutePath(), props);
    }

    private static void setUpH2Conn() throws SQLException {
        h2Connection = DriverManager.getConnection("jdbc:h2:mem:db" + h2InstanceCount++, "sa", "");
        H2Database h2DB = new H2Database(h2Connection, config);
        h2DB.loadAllTables(joinType);
    }

    protected static void clean() {
        if (cubeConnection != null) {
            KylinQueryTest.closeConnection(cubeConnection);
        }
        if (h2Connection != null) {
            KylinQueryTest.closeConnection(h2Connection);
        }
        ObserverEnabler.forceCoprocessorUnset();
        HBaseMetadataTestCase.staticCleanupTestMetadata();
    }

    protected static void preferCubeOf(String joinType) {
        boolean cubesBuiltInBatch;
        CubeManager cubeManager = CubeManager.getInstance((KylinConfig)config);
        HybridManager hybridManager = HybridManager.getInstance((KylinConfig)config);
        boolean bl = cubesBuiltInBatch = cubeManager.getCube("test_kylin_cube_with_slr_empty") != null && cubeManager.getCube("test_kylin_cube_without_slr_empty") != null && cubeManager.getCube("test_kylin_cube_with_slr_left_join_empty") != null && cubeManager.getCube("test_kylin_cube_without_slr_left_join_empty") != null;
        if (!cubesBuiltInBatch) {
            KylinQueryTest.printInfo("Four empty cubes built in BuildCubeWithEngineTest is not complete, preferCubeOf being ignored");
            return;
        }
        if (joinType.equals("inner")) {
            hybridManager.getHybridInstance("test_kylin_hybrid_inner_join").setCost(10);
            hybridManager.getHybridInstance("test_kylin_hybrid_left_join").setCost(100);
            cubeManager.getCube("test_kylin_cube_with_slr_empty").setCost(20);
            cubeManager.getCube("test_kylin_cube_without_slr_empty").setCost(10);
            cubeManager.getCube("test_kylin_cube_with_slr_left_join_empty").setCost(100);
            cubeManager.getCube("test_kylin_cube_without_slr_left_join_empty").setCost(90);
        } else if (joinType.equals("left") || joinType.equals("default")) {
            hybridManager.getHybridInstance("test_kylin_hybrid_left_join").setCost(20);
            hybridManager.getHybridInstance("test_kylin_hybrid_inner_join").setCost(100);
            cubeManager.getCube("test_kylin_cube_with_slr_empty").setCost(100);
            cubeManager.getCube("test_kylin_cube_without_slr_empty").setCost(90);
            cubeManager.getCube("test_kylin_cube_with_slr_left_join_empty").setCost(20);
            cubeManager.getCube("test_kylin_cube_without_slr_left_join_empty").setCost(10);
        }
    }

    @Ignore(value="this is only for debug")
    @Test
    public void testTempQuery() throws Exception {
        this.execAndCompQuery("src/test/resources/query/temp", null, true);
    }

    @Test
    public void testSingleRunQuery() throws Exception {
        String queryFileName = "src/test/resources/query/sql/query62.sql";
        File sqlFile = new File(queryFileName);
        this.runSQL(sqlFile, true, true);
        this.runSQL(sqlFile, true, false);
    }

    @Test
    public void testSingleExecuteQuery() throws Exception {
        String queryFileName = "src/test/resources/query/sql/query39.sql";
        File sqlFile = new File(queryFileName);
        String sql = KylinQueryTest.getTextFromFile(sqlFile);
        DatabaseConnection kylinConn = new DatabaseConnection(cubeConnection);
        this.executeQuery((IDatabaseConnection)kylinConn, queryFileName, sql, true);
    }

    @Ignore
    @Test
    public void testTableauProbing() throws Exception {
        this.batchExecuteQuery("src/test/resources/query/tableau_probing");
    }

    @Test
    public void testCommonQuery() throws Exception {
        this.execAndCompQuery("src/test/resources/query/sql", null, true);
    }

    @Ignore
    @Test
    public void testSimpleQuery() throws Exception {
        this.verifyResultRowCount("src/test/resources/query/sql_verifyCount");
    }

    @Test
    public void testOrderByQuery() throws Exception {
        this.execAndCompQuery("src/test/resources/query/sql_orderby", null, true);
    }

    @Test
    public void testLookupQuery() throws Exception {
        this.execAndCompQuery("src/test/resources/query/sql_lookup", null, true);
    }

    @Test
    public void testDerivedColumnQuery() throws Exception {
        this.execAndCompQuery("src/test/resources/query/sql_derived", null, true);
    }

    @Test
    public void testDistinctCountQuery() throws Exception {
        this.batchExecuteQuery("src/test/resources/query/sql_distinct");
    }

    @Test
    public void testTableauQuery() throws Exception {
        this.batchExecuteQuery("src/test/resources/query/sql_tableau");
    }

    @Test
    public void testSubQuery() throws Exception {
        this.execAndCompQuery("src/test/resources/query/sql_subquery", null, true);
    }

    @Test
    public void testCaseWhen() throws Exception {
        this.execAndCompQuery("src/test/resources/query/sql_casewhen", null, true);
    }

    @Ignore
    @Test
    public void testHiveQuery() throws Exception {
        this.execAndCompQuery("src/test/resources/query/sql_hive", null, true);
    }

    @Test
    public void testH2Query() throws Exception {
        this.execQueryUsingH2("src/test/resources/query/sql_orderby", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInvalidQuery() throws Exception {
        KylinQueryTest.printInfo("-------------------- Test Invalid Query --------------------");
        String queryFolder = "src/test/resources/query/sql_invalid";
        List<File> sqlFiles = KylinQueryTest.getFilesFromFolder(new File(queryFolder), ".sql");
        for (File sqlFile : sqlFiles) {
            String queryName = StringUtils.split((String)sqlFile.getName(), (char)'.')[0];
            KylinQueryTest.printInfo("Testing Query " + queryName);
            String sql = KylinQueryTest.getTextFromFile(sqlFile);
            DatabaseConnection cubeConn = new DatabaseConnection(cubeConnection);
            try {
                cubeConn.createQueryTable(queryName, sql);
            }
            catch (Throwable t) {}
            continue;
            finally {
                cubeConn.close();
                continue;
            }
            throw new IllegalStateException(queryName + " should be error!");
        }
    }

    @Test
    public void testDynamicQuery() throws Exception {
        this.execAndCompDynamicQuery("src/test/resources/query/sql_dynamic", null, true);
    }

    @Ignore(value="simple query will be supported by ii")
    @Test
    public void testLimitEnabled() throws Exception {
        this.runSqlFile("src/test/resources/query/sql_optimize/enable-limit01.sql");
        this.assertLimitWasEnabled();
    }

    private void assertLimitWasEnabled() {
        OLAPContext context = this.getFirstOLAPContext();
        Assert.assertTrue((boolean)context.storageContext.isLimitEnabled());
    }

    private OLAPContext getFirstOLAPContext() {
        return (OLAPContext)OLAPContext.getThreadLocalContexts().iterator().next();
    }
}

