/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.test;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import org.apache.kylin.query.test.KylinQueryTest;
import org.apache.kylin.storage.hbase.coprocessor.observer.ObserverEnabler;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CombinationTest
extends KylinQueryTest {
    @BeforeClass
    public static void setUp() throws SQLException {
        System.out.println("setUp in CombinationTest");
    }

    @AfterClass
    public static void tearDown() {
        CombinationTest.clean();
    }

    @Parameterized.Parameters
    public static Collection<Object[]> configs() {
        return Arrays.asList({"inner", "unset"}, {"left", "unset"}, {"inner", "off"}, {"left", "off"}, {"inner", "on"}, {"left", "on"});
    }

    public CombinationTest(String joinType, String coprocessorToggle) throws Exception {
        KylinQueryTest.clean();
        KylinQueryTest.joinType = joinType;
        KylinQueryTest.setupAll();
        KylinQueryTest.preferCubeOf(joinType);
        if (coprocessorToggle.equals("on")) {
            ObserverEnabler.forceCoprocessorOn();
        } else if (coprocessorToggle.equals("off")) {
            ObserverEnabler.forceCoprocessorOff();
        } else if (coprocessorToggle.equals("unset")) {
            // empty if block
        }
    }
}

