/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata;

import java.util.List;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.LocalFileMetadataTestCase;
import org.apache.kylin.metadata.MetadataManager;
import org.apache.kylin.metadata.model.TableDesc;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MetadataManagerTest
extends LocalFileMetadataTestCase {
    @Before
    public void setUp() throws Exception {
        this.createTestMetadata();
    }

    @After
    public void after() throws Exception {
        this.cleanupTestMetadata();
    }

    @Test
    public void testListAllTables() throws Exception {
        List tables = MetadataManager.getInstance((KylinConfig)MetadataManagerTest.getTestConfig()).listAllTables();
        Assert.assertNotNull((Object)tables);
        Assert.assertTrue((tables.size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testFindTableByName() throws Exception {
        TableDesc table = MetadataManager.getInstance((KylinConfig)MetadataManagerTest.getTestConfig()).getTableDesc("EDW.TEST_CAL_DT");
        Assert.assertNotNull((Object)table);
        Assert.assertEquals((Object)"EDW.TEST_CAL_DT", (Object)table.getIdentity());
    }

    @Test
    public void testGetInstance() throws Exception {
        Assert.assertNotNull((Object)MetadataManager.getInstance((KylinConfig)MetadataManagerTest.getTestConfig()));
        Assert.assertNotNull((Object)MetadataManager.getInstance((KylinConfig)MetadataManagerTest.getTestConfig()).listAllTables());
        Assert.assertTrue((MetadataManager.getInstance((KylinConfig)MetadataManagerTest.getTestConfig()).listAllTables().size() > 0 ? 1 : 0) != 0);
    }
}

