/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller.open;

import com.google.common.annotations.VisibleForTesting;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.rest.controller.NBasicController;
import org.apache.kylin.rest.controller.NTableController;
import org.apache.kylin.rest.request.AWSTableLoadRequest;
import org.apache.kylin.rest.request.OpenReloadTableRequest;
import org.apache.kylin.rest.request.TableLoadRequest;
import org.apache.kylin.rest.request.UpdateAWSTableExtDescRequest;
import org.apache.kylin.rest.response.DataResult;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.apache.kylin.rest.response.LoadTableResponse;
import org.apache.kylin.rest.response.OpenPreReloadTableResponse;
import org.apache.kylin.rest.response.OpenReloadTableResponse;
import org.apache.kylin.rest.response.PreUnloadTableResponse;
import org.apache.kylin.rest.response.UpdateAWSTableExtDescResponse;
import org.apache.kylin.rest.service.ProjectService;
import org.apache.kylin.rest.service.TableSamplingService;
import org.apache.kylin.rest.service.TableService;
import org.apache.kylin.rest.util.TableUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/tables"}, produces={"application/vnd.apache.kylin-v4-public+json"})
public class OpenTableController
extends NBasicController {
    @Autowired
    private NTableController tableController;
    @Autowired
    private TableService tableService;
    @Autowired
    private ProjectService projectService;
    private static final Integer MAX_SAMPLING_ROWS = 20000000;
    private static final Integer MIN_SAMPLING_ROWS = 10000;

    @VisibleForTesting
    public TableDesc getTable(String project, String tableName) {
        TableDesc table = ((NTableMetadataManager)this.tableService.getManager(NTableMetadataManager.class, project)).getTableDesc(tableName);
        if (null == table) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_TABLE_NAME, String.format(Locale.ROOT, MsgPicker.getMsg().getTableNotFound(), tableName));
        }
        return table;
    }

    @VisibleForTesting
    public void updateDataSourceType(String project, int dataSourceType) {
        String sourceType = String.valueOf(dataSourceType);
        if (!sourceType.equals(this.projectService.getDataSourceType(project))) {
            this.projectService.setDataSourceType(project, sourceType);
        }
    }

    @ApiOperation(value="getTableDesc", tags={"AI"})
    @GetMapping(value={""})
    @ResponseBody
    public EnvelopeResponse<DataResult<List<TableDesc>>> getTableDesc(@RequestParam(value="project") String project, @RequestParam(value="table", required=false) String table, @RequestParam(value="database", required=false) String database, @RequestParam(value="is_fuzzy", required=false, defaultValue="false") boolean isFuzzy, @RequestParam(value="ext", required=false, defaultValue="true") boolean withExt, @RequestParam(value="page_offset", required=false, defaultValue="0") Integer offset, @RequestParam(value="page_size", required=false, defaultValue="10") Integer limit, @RequestParam(value="source_type", required=false, defaultValue="9") Integer sourceType) throws IOException {
        this.checkProjectName(project);
        this.checkNonNegativeIntegerArg("page_offset", offset);
        if (sourceType == 1) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.UNSUPPORTED_STREAMING_OPERATION, MsgPicker.getMsg().getStreamingOperationNotSupport());
        }
        int returnTableSize = TableUtils.calculateTableSize((int)offset, (int)limit);
        Pair tableDescWithActualSize = this.tableService.getTableDesc(project, withExt, StringUtils.upperCase((String)table, (Locale)Locale.ROOT), StringUtils.upperCase((String)database, (Locale)Locale.ROOT), isFuzzy, Collections.singletonList(sourceType), returnTableSize);
        return new EnvelopeResponse("000", (Object)DataResult.getCustom((Pair)tableDescWithActualSize, (int)offset, (int)limit), "");
    }

    @ApiOperation(value="loadTables", tags={"AI"})
    @PostMapping(value={""})
    @ResponseBody
    public EnvelopeResponse<LoadTableResponse> loadTables(@RequestBody TableLoadRequest tableLoadRequest) throws Exception {
        String projectName = this.checkProjectName(tableLoadRequest.getProject());
        tableLoadRequest.setProject(projectName);
        this.checkRequiredArg("need_sampling", tableLoadRequest.getNeedSampling());
        OpenTableController.validatePriority((int)tableLoadRequest.getPriority());
        if (Boolean.TRUE.equals(tableLoadRequest.getNeedSampling()) && (null == tableLoadRequest.getSamplingRows() || tableLoadRequest.getSamplingRows() > MAX_SAMPLING_ROWS || tableLoadRequest.getSamplingRows() < MIN_SAMPLING_ROWS)) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.JOB_SAMPLING_RANGE_INVALID, new Object[]{MIN_SAMPLING_ROWS, MAX_SAMPLING_ROWS});
        }
        if (9 != tableLoadRequest.getDataSourceType() && 8 != tableLoadRequest.getDataSourceType()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.UNSUPPORTED_DATA_SOURCE_TYPE, "Only support Hive as the data source. (data_source_type = 9 || 8)");
        }
        this.updateDataSourceType(tableLoadRequest.getProject(), tableLoadRequest.getDataSourceType());
        return this.tableController.loadTables(tableLoadRequest);
    }

    @ApiOperation(value="loadAWSTablesCompatibleCrossAccount", tags={"KC"})
    @PostMapping(value={"/compatibility/aws"})
    @ResponseBody
    public EnvelopeResponse<LoadTableResponse> loadAWSTablesCompatibleCrossAccount(@RequestBody AWSTableLoadRequest tableLoadRequest) throws Exception {
        boolean sampleConditionError;
        String projectName = this.checkProjectName(tableLoadRequest.getProject());
        tableLoadRequest.setProject(projectName);
        this.checkRequiredArg("need_sampling", tableLoadRequest.getNeedSampling());
        OpenTableController.validatePriority((int)tableLoadRequest.getPriority());
        boolean bl = sampleConditionError = null == tableLoadRequest.getSamplingRows() || tableLoadRequest.getSamplingRows() > MAX_SAMPLING_ROWS || tableLoadRequest.getSamplingRows() < MIN_SAMPLING_ROWS;
        if (Boolean.TRUE.equals(tableLoadRequest.getNeedSampling()) && sampleConditionError) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.JOB_SAMPLING_RANGE_INVALID, new Object[]{MIN_SAMPLING_ROWS, MAX_SAMPLING_ROWS});
        }
        if (9 != tableLoadRequest.getDataSourceType() && 8 != tableLoadRequest.getDataSourceType()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.UNSUPPORTED_DATA_SOURCE_TYPE, "Only support Hive as the data source. (data_source_type = 9 || 8)");
        }
        this.updateDataSourceType(tableLoadRequest.getProject(), tableLoadRequest.getDataSourceType());
        return this.tableController.loadAWSTablesCompatibleCrossAccount(tableLoadRequest);
    }

    @ApiOperation(value="preReloadTable", tags={"AI"})
    @GetMapping(value={"/pre_reload"})
    @ResponseBody
    public EnvelopeResponse<OpenPreReloadTableResponse> preReloadTable(@RequestParam(value="project") String project, @RequestParam(value="table") String table, @RequestParam(value="need_details", required=false, defaultValue="false") boolean needDetails) throws Exception {
        String projectName = this.checkProjectName(project);
        table = StringUtils.upperCase((String)table, (Locale)Locale.ROOT);
        this.checkStreamingOperation(project, table);
        OpenPreReloadTableResponse result = this.tableService.preProcessBeforeReloadWithoutFailFast(projectName, table, needDetails);
        return new EnvelopeResponse("000", (Object)result, "");
    }

    @ApiOperation(value="reloadTable", tags={"AI"})
    @PostMapping(value={"/reload"})
    @ResponseBody
    public EnvelopeResponse<OpenReloadTableResponse> reloadTable(@RequestBody OpenReloadTableRequest request) {
        String projectName = this.checkProjectName(request.getProject());
        request.setProject(projectName);
        this.checkRequiredArg("need_sampling", request.getNeedSampling());
        if (StringUtils.isEmpty((CharSequence)request.getTable())) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_TABLE_NAME, MsgPicker.getMsg().getTableNameCannotEmpty());
        }
        request.setTable(StringUtils.upperCase((String)request.getTable(), (Locale)Locale.ROOT));
        this.checkStreamingOperation(request.getProject(), request.getTable());
        OpenTableController.validatePriority((int)request.getPriority());
        if (request.getNeedSampling().booleanValue()) {
            TableSamplingService.checkSamplingRows((int)request.getSamplingRows());
        }
        Pair pair = this.tableService.reloadTable(request.getProject(), request.getTable(), request.getNeedSampling().booleanValue(), request.getSamplingRows(), request.getNeedBuilding().booleanValue(), request.getPriority(), request.getYarnQueue());
        OpenReloadTableResponse response = new OpenReloadTableResponse();
        response.setSamplingId((String)pair.getFirst());
        response.setJobIds((List)pair.getSecond());
        return new EnvelopeResponse("000", (Object)response, "");
    }

    @ApiOperation(value="reloadAWSTablesCompatibleCrossAccount", tags={"KC"})
    @PostMapping(value={"/reload/compatibility/aws"})
    @ResponseBody
    public EnvelopeResponse<OpenReloadTableResponse> reloadAWSTablesCompatibleCrossAccount(@RequestBody OpenReloadTableRequest request) {
        String projectName = this.checkProjectName(request.getProject());
        this.checkStreamingOperation(request.getProject(), request.getS3TableExtInfo().getName());
        request.setProject(projectName);
        this.checkRequiredArg("need_sampling", request.getNeedSampling());
        OpenTableController.validatePriority((int)request.getPriority());
        if (StringUtils.isEmpty((CharSequence)request.getS3TableExtInfo().getName())) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_TABLE_NAME, MsgPicker.getMsg().getTableNameCannotEmpty());
        }
        if (request.getNeedSampling().booleanValue()) {
            TableSamplingService.checkSamplingRows((int)request.getSamplingRows());
        }
        Pair pair = this.tableService.reloadAWSTableCompatibleCrossAccount(request.getProject(), request.getS3TableExtInfo(), request.getNeedSampling().booleanValue(), request.getSamplingRows(), request.getNeedBuilding().booleanValue(), request.getPriority(), request.getYarnQueue());
        OpenReloadTableResponse response = new OpenReloadTableResponse();
        response.setSamplingId((String)pair.getFirst());
        response.setJobIds((List)pair.getSecond());
        return new EnvelopeResponse("000", (Object)response, "");
    }

    @ApiOperation(value="prepareUnloadTable", tags={"AI"})
    @GetMapping(value={"/{database:.+}/{table:.+}/prepare_unload"})
    @ResponseBody
    public EnvelopeResponse<PreUnloadTableResponse> prepareUnloadTable(@RequestParam(value="project") String project, @PathVariable(value="database") String database, @PathVariable(value="table") String table) throws IOException {
        String projectName = this.checkProjectName(project);
        String dbTblName = String.format(Locale.ROOT, "%s.%s", StringUtils.upperCase((String)database, (Locale)Locale.ROOT), StringUtils.upperCase((String)table, (Locale)Locale.ROOT));
        PreUnloadTableResponse response = this.tableService.preUnloadTable(projectName, dbTblName);
        return new EnvelopeResponse("000", (Object)response, "");
    }

    @ApiOperation(value="unloadTable", tags={"AI"})
    @DeleteMapping(value={"/{database:.+}/{table:.+}"})
    @ResponseBody
    public EnvelopeResponse<String> unloadTable(@RequestParam(value="project") String project, @PathVariable(value="database") String database, @PathVariable(value="table") String table, @RequestParam(value="cascade", defaultValue="false") Boolean cascade) {
        String projectName = this.checkProjectName(project);
        String dbTblName = String.format(Locale.ROOT, "%s.%s", StringUtils.upperCase((String)database, (Locale)Locale.ROOT), StringUtils.upperCase((String)table, (Locale)Locale.ROOT));
        this.tableService.unloadTable(projectName, dbTblName, cascade);
        return new EnvelopeResponse("000", (Object)dbTblName, "");
    }

    @ApiOperation(value="updateLoadedAWSTableExtProp", tags={"KC"})
    @PutMapping(value={"/ext/prop/aws"})
    @ResponseBody
    public EnvelopeResponse<UpdateAWSTableExtDescResponse> updateLoadedAWSTableExtProp(@RequestBody UpdateAWSTableExtDescRequest request) {
        String projectName = this.checkProjectName(request.getProject());
        request.setProject(projectName);
        return this.tableController.updateLoadedAWSTableExtProp(request);
    }
}

