/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller.open;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.common.persistence.AclEntity;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.rest.aspect.InsensitiveNameAspect;
import org.apache.kylin.rest.controller.NBasicController;
import org.apache.kylin.rest.request.AccessRequest;
import org.apache.kylin.rest.request.BatchProjectPermissionRequest;
import org.apache.kylin.rest.request.ProjectPermissionRequest;
import org.apache.kylin.rest.response.AccessEntryResponse;
import org.apache.kylin.rest.response.DataResult;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.apache.kylin.rest.response.ProjectPermissionResponse;
import org.apache.kylin.rest.response.SidPermissionWithAclResponse;
import org.apache.kylin.rest.security.AclPermissionEnum;
import org.apache.kylin.rest.security.ExternalAclProvider;
import org.apache.kylin.rest.service.AccessService;
import org.apache.kylin.rest.service.AclTCRService;
import org.apache.kylin.rest.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.acls.domain.GrantedAuthoritySid;
import org.springframework.security.acls.domain.PrincipalSid;
import org.springframework.security.acls.model.Permission;
import org.springframework.security.acls.model.Sid;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/access"}, produces={"application/vnd.apache.kylin-v4-public+json"})
public class OpenAccessController
extends NBasicController {
    @Autowired
    @Qualifier(value="accessService")
    private AccessService accessService;
    @Autowired
    @Qualifier(value="aclTCRService")
    private AclTCRService aclTCRService;
    @Autowired
    @Qualifier(value="userService")
    protected UserService userService;

    @ApiOperation(value="getProjectAccessPermissions", tags={"MID"})
    @GetMapping(value={"/project"})
    @ResponseBody
    public EnvelopeResponse<DataResult<List<ProjectPermissionResponse>>> getProjectAccessPermissions(@RequestParam(value="project") String project, @RequestParam(value="name", required=false) String name, @RequestParam(value="is_case_sensitive", required=false) boolean isCaseSensitive, @RequestParam(value="page_offset", required=false, defaultValue="0") Integer pageOffset, @RequestParam(value="page_size", required=false, defaultValue="10") Integer pageSize) throws IOException {
        String projectName = this.checkProjectName(project);
        String projectUuid = this.getProjectUuid(projectName);
        RootPersistentEntity ae = this.accessService.getAclEntity("ProjectInstance", projectUuid);
        List aeResponses = this.accessService.generateAceResponsesByFuzzMatching((AclEntity)ae, name, isCaseSensitive);
        List<ProjectPermissionResponse> permissionResponses = this.convertAceResponseToProjectPermissionResponse(aeResponses);
        return new EnvelopeResponse("000", (Object)DataResult.get(permissionResponses, (int)pageOffset, (int)pageSize), "");
    }

    @ApiOperation(value="grantProjectPermission", tags={"MID"})
    @PostMapping(value={"/project"})
    @ResponseBody
    public EnvelopeResponse<String> grantProjectPermission(@RequestBody BatchProjectPermissionRequest permissionRequest) throws IOException {
        String projectName = this.checkProjectName(permissionRequest.getProject());
        permissionRequest.setProject(projectName);
        this.checkType(permissionRequest.getType());
        this.checkNames(permissionRequest.getNames());
        this.updateRequestCaseInsentive(permissionRequest);
        ExternalAclProvider.checkExternalPermission((String)permissionRequest.getPermission());
        String projectUuid = this.getProjectUuid(permissionRequest.getProject());
        RootPersistentEntity ae = this.accessService.getAclEntity("ProjectInstance", projectUuid);
        List<AccessRequest> accessRequests = this.convertBatchPermissionRequestToAccessRequests((AclEntity)ae, permissionRequest);
        this.accessService.checkAccessRequestList(accessRequests);
        this.accessService.remoteBatchGrantAccess(accessRequests, (AclEntity)ae);
        this.aclTCRService.updateAclTCR(projectUuid, accessRequests);
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="updateProjectPermission", tags={"MID"})
    @PutMapping(value={"/project"})
    @ResponseBody
    public EnvelopeResponse<String> updateProjectPermission(@RequestBody ProjectPermissionRequest permissionRequest) throws IOException {
        String projectName = this.checkProjectName(permissionRequest.getProject());
        permissionRequest.setProject(projectName);
        this.checkType(permissionRequest.getType());
        this.checkName(permissionRequest.getName());
        this.updateRequestCaseInsentive(permissionRequest);
        ExternalAclProvider.checkExternalPermission((String)permissionRequest.getPermission());
        AccessRequest accessRequest = this.convertPermissionRequestToAccessRequest(permissionRequest);
        this.accessService.checkAccessRequestList((List)Lists.newArrayList((Object[])new AccessRequest[]{accessRequest}));
        String projectUuid = this.getProjectUuid(permissionRequest.getProject());
        RootPersistentEntity ae = this.accessService.getAclEntity("ProjectInstance", projectUuid);
        this.accessService.remoteGrantAccess((AclEntity)ae, accessRequest.getSid(), Boolean.valueOf(accessRequest.isPrincipal()), accessRequest.getPermission());
        this.aclTCRService.updateAclTCR(projectUuid, (List)Lists.newArrayList((Object[])new AccessRequest[]{accessRequest}));
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="revokeProjectPermission", tags={"MID"})
    @DeleteMapping(value={"/project"})
    @ResponseBody
    public EnvelopeResponse<String> revokeProjectPermission(@RequestParam(value="project") String project, @RequestParam(value="type") String type, @RequestParam(value="name") String name) throws IOException {
        String projectName = this.checkProjectName(project);
        String projectUuid = this.getProjectUuid(projectName);
        this.checkType(type);
        this.checkSidExists(type, name);
        this.checkSidGranted(projectUuid, name);
        boolean principal = "user".equalsIgnoreCase(type);
        if (principal) {
            this.accessService.checkGlobalAdmin(name);
        }
        RootPersistentEntity ae = this.accessService.getAclEntity("ProjectInstance", projectUuid);
        this.accessService.remoteRevokeAccess((AclEntity)ae, name, principal);
        this.aclTCRService.revokeAclTCR(projectUuid, name, principal);
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="getUserOrGroupAclPermissions", tags={"MID"})
    @GetMapping(value={"/acls"})
    @ResponseBody
    public EnvelopeResponse<List<SidPermissionWithAclResponse>> getUserOrGroupAclPermissions(@RequestParam(value="type") String type, @RequestParam(value="name") String name, @RequestParam(value="project", required=false) String project) throws IOException {
        UserDetails userDetails;
        String projectName = "";
        if (StringUtils.isNotBlank((CharSequence)project)) {
            projectName = this.checkProjectName(project);
        }
        this.checkType(type);
        this.checkSidExists(type, name);
        boolean principal = "user".equalsIgnoreCase(type);
        if (principal && (userDetails = this.userService.loadUserByUsername(name)) != null) {
            name = userDetails.getUsername();
        }
        List<String> projects = new ArrayList<String>();
        if (StringUtils.isBlank((CharSequence)project)) {
            projects = this.accessService.getGrantedProjectsOfUserOrGroup(name, principal);
        } else {
            projects.add(projectName);
        }
        List response = this.accessService.getUserOrGroupAclPermissions(projects, name, principal);
        return new EnvelopeResponse("000", (Object)response, "");
    }

    private void updateRequestCaseInsentive(BatchProjectPermissionRequest permissionRequest) {
        permissionRequest.setType(InsensitiveNameAspect.getCaseInsentiveType((String)permissionRequest.getType()));
        boolean principal = "user".equalsIgnoreCase(permissionRequest.getType());
        if (principal) {
            permissionRequest.setNames(this.makeUserNameCaseInSentive(permissionRequest.getNames()));
        }
    }

    private void updateRequestCaseInsentive(ProjectPermissionRequest permissionRequest) {
        permissionRequest.setType(InsensitiveNameAspect.getCaseInsentiveType((String)permissionRequest.getType()));
        boolean principal = "user".equalsIgnoreCase(permissionRequest.getType());
        if (principal) {
            permissionRequest.setName(this.makeUserNameCaseInSentive(permissionRequest.getName()));
        }
    }

    private void checkSidExists(String type, String name) throws IOException {
        boolean principal = "user".equalsIgnoreCase(type);
        this.accessService.checkSid(name, principal);
    }

    private void checkSidGranted(String projectUuid, String name) throws IOException {
        RootPersistentEntity ae = this.accessService.getAclEntity("ProjectInstance", projectUuid);
        List aeResponses = this.accessService.generateAceResponsesByFuzzMatching((AclEntity)ae, name, false);
        if (CollectionUtils.isEmpty((Collection)aeResponses)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.UNAUTHORIZED_ENTITY, MsgPicker.getMsg().getUnauthorizedSid());
        }
    }

    private void checkType(String type) {
        if ("user".equalsIgnoreCase(type) || "group".equalsIgnoreCase(type)) {
            return;
        }
        throw new KylinException((ErrorCodeProducer)ErrorCodeServer.PARAMETER_INVALID_SUPPORT_LIST, new Object[]{"type", "user, group"});
    }

    private void checkNames(List<String> names) {
        if (CollectionUtils.isEmpty(names) || names.stream().anyMatch(StringUtils::isBlank)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.EMPTY_PARAMETER, MsgPicker.getMsg().getEmptySid());
        }
    }

    private void checkName(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.EMPTY_PARAMETER, MsgPicker.getMsg().getEmptySid());
        }
    }

    private String getProjectUuid(String project) {
        NProjectManager projectManager = NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
        ProjectInstance prjInstance = projectManager.getProject(project);
        return prjInstance.getUuid();
    }

    private AccessRequest convertPermissionRequestToAccessRequest(ProjectPermissionRequest permissionRequest) {
        AccessRequest accessRequest = new AccessRequest();
        accessRequest.setPrincipal("user".equalsIgnoreCase(permissionRequest.getType()));
        accessRequest.setSid(permissionRequest.getName());
        String permission = AclPermissionEnum.convertToAclPermission((String)permissionRequest.getPermission().toUpperCase(Locale.ROOT));
        accessRequest.setPermission(permission);
        return accessRequest;
    }

    @VisibleForTesting
    public List<AccessRequest> convertBatchPermissionRequestToAccessRequests(AclEntity ae, BatchProjectPermissionRequest permissionRequest) {
        ArrayList<AccessRequest> accessRequests = new ArrayList<AccessRequest>();
        String type = permissionRequest.getType();
        String externalPermission = permissionRequest.getPermission().toUpperCase(Locale.ROOT);
        String aclPermission = AclPermissionEnum.convertToAclPermission((String)externalPermission);
        List names = permissionRequest.getNames();
        for (String name : names) {
            AccessRequest accessRequest = new AccessRequest();
            accessRequest.setPermission(aclPermission);
            accessRequest.setPrincipal("user".equalsIgnoreCase(type));
            accessRequest.setSid(name);
            accessRequests.add(accessRequest);
        }
        if ("user".equalsIgnoreCase(type)) {
            List allAclSids = this.accessService.getAllAclSids(ae, type);
            accessRequests.forEach(request -> {
                for (String aclSid : allAclSids) {
                    if (!request.getSid().equalsIgnoreCase(aclSid)) continue;
                    request.setSid(aclSid);
                }
            });
        }
        return accessRequests;
    }

    private List<ProjectPermissionResponse> convertAceResponseToProjectPermissionResponse(List<AccessEntryResponse> aclResponseList) {
        ArrayList<ProjectPermissionResponse> responseList = new ArrayList<ProjectPermissionResponse>();
        for (AccessEntryResponse aclResponse : aclResponseList) {
            String type = "";
            String userOrGroupName = "";
            Sid sid = aclResponse.getSid();
            if (sid instanceof PrincipalSid) {
                type = "user";
                userOrGroupName = ((PrincipalSid)sid).getPrincipal();
            } else if (sid instanceof GrantedAuthoritySid) {
                type = "group";
                userOrGroupName = ((GrantedAuthoritySid)sid).getGrantedAuthority();
            }
            List extPermissionList = CollectionUtils.isEmpty((Collection)aclResponse.getExtPermissions()) ? Collections.EMPTY_LIST : aclResponse.getExtPermissions().stream().map(ExternalAclProvider::convertToExternalPermission).collect(Collectors.toList());
            String externalPermission = ExternalAclProvider.convertToExternalPermission((Permission)aclResponse.getPermission());
            responseList.add(new ProjectPermissionResponse(type, userOrGroupName, externalPermission, extPermissionList));
        }
        return responseList;
    }
}

