/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller;

import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.metadata.model.TableExtDesc;
import org.apache.kylin.rest.controller.NBasicController;
import org.apache.kylin.rest.request.StreamingRequest;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.apache.kylin.rest.response.LoadTableResponse;
import org.apache.kylin.rest.service.StreamingTableService;
import org.apache.kylin.rest.service.TableExtService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/streaming_tables"}, produces={"application/vnd.apache.kylin-v4+json", "application/vnd.apache.kylin-v4-public+json"})
public class StreamingTableController
extends NBasicController {
    @Autowired
    @Qualifier(value="streamingTableService")
    private StreamingTableService streamingTableService;
    @Autowired
    @Qualifier(value="tableExtService")
    private TableExtService tableExtService;

    @ApiOperation(value="loadTables")
    @PostMapping(value={"/table"}, produces={"application/vnd.apache.kylin-v4+json", "application/vnd.apache.kylin-v4-public+json"})
    @ResponseBody
    public EnvelopeResponse<LoadTableResponse> saveStreamingTable(@RequestBody StreamingRequest streamingRequest) {
        this.checkStreamingEnabled();
        String project = streamingRequest.getProject();
        this.checkProjectName(project);
        TableExtDesc tableExt = this.streamingTableService.getOrCreateTableExt(project, streamingRequest.getTableDesc());
        try {
            this.streamingTableService.decimalConvertToDouble(project, streamingRequest);
            this.streamingTableService.checkColumns(streamingRequest);
            this.tableExtService.checkAndLoadTable(project, streamingRequest.getTableDesc(), tableExt);
            this.streamingTableService.createKafkaConfig(project, streamingRequest.getKafkaConfig());
            LoadTableResponse loadTableResponse = new LoadTableResponse();
            loadTableResponse.getLoaded().add(streamingRequest.getTableDesc().getIdentity());
            return new EnvelopeResponse("000", (Object)loadTableResponse, "");
        }
        catch (Exception e) {
            Throwable root = ExceptionUtils.getRootCause((Throwable)e) == null ? e : ExceptionUtils.getRootCause((Throwable)e);
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.RELOAD_TABLE_FAILED, root.getMessage());
        }
    }

    @ApiOperation(value="updateTables")
    @PutMapping(value={"/table"}, produces={"application/vnd.apache.kylin-v4+json", "application/vnd.apache.kylin-v4-public+json"})
    @ResponseBody
    public EnvelopeResponse<LoadTableResponse> updateStreamingTable(@RequestBody StreamingRequest streamingRequest) {
        this.checkStreamingEnabled();
        String project = streamingRequest.getProject();
        this.checkProjectName(project);
        try {
            TableExtDesc tableExt = this.streamingTableService.getOrCreateTableExt(project, streamingRequest.getTableDesc());
            this.streamingTableService.reloadTable(project, streamingRequest.getTableDesc(), tableExt);
            this.streamingTableService.updateKafkaConfig(project, streamingRequest.getKafkaConfig());
            LoadTableResponse loadTableResponse = new LoadTableResponse();
            loadTableResponse.getLoaded().add(streamingRequest.getTableDesc().getIdentity());
            return new EnvelopeResponse("000", (Object)loadTableResponse, "");
        }
        catch (Exception e) {
            Throwable root = ExceptionUtils.getRootCause((Throwable)e) == null ? e : ExceptionUtils.getRootCause((Throwable)e);
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.RELOAD_TABLE_FAILED, root.getMessage());
        }
    }
}

