/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller;

import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.common.msg.Message;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.common.persistence.transaction.AclTCRRevokeEventNotifier;
import org.apache.kylin.common.scheduler.EventBusFactory;
import org.apache.kylin.common.scheduler.SchedulerEventNotifier;
import org.apache.kylin.metadata.user.ManagedUser;
import org.apache.kylin.rest.controller.NBasicController;
import org.apache.kylin.rest.request.UpdateGroupRequest;
import org.apache.kylin.rest.request.UserGroupRequest;
import org.apache.kylin.rest.response.DataResult;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.apache.kylin.rest.response.UserGroupResponseKI;
import org.apache.kylin.rest.service.AclTCRService;
import org.apache.kylin.rest.service.IUserGroupService;
import org.apache.kylin.rest.service.UserService;
import org.apache.kylin.rest.util.PagingUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/user_group"}, produces={"application/vnd.apache.kylin-v4+json"})
public class NUserGroupController
extends NBasicController {
    @Autowired
    @Qualifier(value="userGroupService")
    private IUserGroupService userGroupService;
    @Autowired
    @Qualifier(value="userService")
    private UserService userService;
    @Autowired
    @Qualifier(value="aclTCRService")
    private AclTCRService aclTCRService;

    @ApiOperation(value="getUsersByGroup", tags={"MID"}, notes="Update URL: group_members, group_name; Update Param: group_name, page_offset, page_size; Update Response: total_size")
    @GetMapping(value={"/group_members/{uuid:.+}"})
    @ResponseBody
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public EnvelopeResponse<DataResult<List<ManagedUser>>> getUsersByGroupName(@PathVariable(value="uuid") String groupUuid, @RequestParam(value="name", required=false) String name, @RequestParam(value="page_offset", required=false, defaultValue="0") Integer pageOffset, @RequestParam(value="page_size", required=false, defaultValue="10") Integer pageSize) throws IOException {
        String groupName = this.userGroupService.getGroupNameByUuid(groupUuid);
        List members = this.userGroupService.getGroupMembersByName(groupName);
        if (StringUtils.isNotBlank((String)name)) {
            members = members.stream().filter(user -> StringUtils.containsIgnoreCase((String)user.getUsername(), (String)name)).collect(Collectors.toList());
        }
        List subList = PagingUtil.cutPage((List)members, (int)pageOffset, (int)pageSize);
        for (ManagedUser user2 : subList) {
            this.userService.completeUserInfo(user2);
        }
        return new EnvelopeResponse("000", (Object)DataResult.get((Collection)subList, members, (int)pageOffset, (int)pageSize), "get groups members");
    }

    @ApiOperation(value="groups", tags={"MID"})
    @GetMapping(value={"/groups"})
    @ResponseBody
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public EnvelopeResponse<DataResult<List<String>>> listUserAuthorities(@RequestParam(value="name", required=false) String groupName, @RequestParam(value="is_case_sensitive", required=false) boolean isCaseSensitive, @RequestParam(value="page_offset", required=false, defaultValue="0") Integer pageOffset, @RequestParam(value="page_size", required=false, defaultValue="10") Integer pageSize) throws IOException {
        List groups = this.userGroupService.listAllAuthorities();
        if (StringUtils.isNotBlank((String)groupName)) {
            groups = groups.stream().filter(group -> isCaseSensitive ? group.contains(groupName) : StringUtils.containsIgnoreCase((String)group, (String)groupName)).collect(Collectors.toList());
        }
        return new EnvelopeResponse("000", (Object)DataResult.get((List)groups, (int)pageOffset, (int)pageSize), "get groups");
    }

    @ApiOperation(value="getUsersByGroup", tags={"MID"}, notes="Update URL: users_with_group; Update Param: page_offset, page_size, user_group_name; Update Response: total_size")
    @GetMapping(value={"/users_with_group"}, produces={"application/vnd.apache.kylin-v4+json", "application/vnd.apache.kylin-v4-public+json"})
    @ResponseBody
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public EnvelopeResponse<DataResult<List<UserGroupResponseKI>>> getUsersWithGroup(@RequestParam(value="page_offset", required=false, defaultValue="0") Integer pageOffset, @RequestParam(value="page_size", required=false, defaultValue="10") Integer pageSize, @RequestParam(value="user_group_name", required=false, defaultValue="") String userGroupName) throws IOException {
        List groups = this.userGroupService.getUserGroupsFilterByGroupName(userGroupName);
        List subList = PagingUtil.cutPage((List)groups, (int)pageOffset, (int)pageSize);
        List result = this.userGroupService.getUserGroupResponse(subList);
        return new EnvelopeResponse("000", (Object)DataResult.get((Collection)result, (int)groups.size()), "get users with group and id");
    }

    @ApiOperation(value="userAndGroup", tags={"MID"})
    @GetMapping(value={"/users_and_groups"})
    @ResponseBody
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public EnvelopeResponse<Map<String, List<String>>> getUsersAndGroups() throws IOException {
        return new EnvelopeResponse("000", (Object)this.userGroupService.getUserAndUserGroup(), "");
    }

    @ApiOperation(value="getUsersByGroup", tags={"MID"}, notes="Update URL: group_name; Update Param: group_name")
    @PostMapping(value={""})
    @ResponseBody
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public EnvelopeResponse<String> addUserGroup(@RequestBody UserGroupRequest addUserGroupRequest) throws IOException {
        this.checkGroupName(addUserGroupRequest.getGroupName());
        this.userGroupService.addGroup(addUserGroupRequest.getGroupName());
        return new EnvelopeResponse("000", (Object)"", "add user group");
    }

    @ApiOperation(value="getUsersByGroup", tags={"MID"}, notes="Update URL: group_name; Update Param: group_name")
    @DeleteMapping(value={"/{uuid:.+}"})
    @ResponseBody
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public EnvelopeResponse<String> delUserGroup(@PathVariable(value="uuid") String groupUuid) throws IOException {
        String groupName = this.userGroupService.getGroupNameByUuid(groupUuid);
        this.userGroupService.deleteGroup(groupName);
        this.aclTCRService.revokeAclTCR(groupName, false);
        EventBusFactory.getInstance().postAsync((SchedulerEventNotifier)new AclTCRRevokeEventNotifier(groupName, true));
        return new EnvelopeResponse("000", (Object)"", "del user group");
    }

    @ApiOperation(value="updateUserAndGroup", tags={"MID"})
    @PutMapping(value={"/users"})
    @ResponseBody
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public EnvelopeResponse<String> addOrDelUsers(@RequestBody UpdateGroupRequest updateGroupRequest) throws IOException {
        this.checkGroupName(updateGroupRequest.getGroup());
        this.userGroupService.modifyGroupUsers(updateGroupRequest.getGroup(), updateGroupRequest.getUsers());
        return new EnvelopeResponse("000", (Object)"", "modify users in user group");
    }

    @ApiOperation(value="getUsersByGroup", tags={"MID"}, notes="Update URL: group_name; Update Param: group_name")
    @PostMapping(value={"/batch"})
    @ResponseBody
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public EnvelopeResponse<String> batchAddUserGroups(@RequestBody List<String> groups) {
        groups.forEach(this::checkGroupName);
        this.userGroupService.addGroups(groups);
        return new EnvelopeResponse("000", (Object)"", "batch add user groups");
    }

    @ApiOperation(value="getUsersByGroup", tags={"MID"}, notes="Update URL: group_name; Update Param: group_name")
    @DeleteMapping(value={"/batch"})
    @ResponseBody
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public EnvelopeResponse<String> batchDelUserGroup(@RequestBody List<String> groups) throws IOException {
        for (String group : groups) {
            this.userGroupService.deleteGroup(group);
            this.aclTCRService.revokeAclTCR(group, false);
            EventBusFactory.getInstance().postAsync((SchedulerEventNotifier)new AclTCRRevokeEventNotifier(group, true));
        }
        return new EnvelopeResponse("000", (Object)"", "batch del user group");
    }

    public void checkGroupName(String groupName) {
        Message msg = MsgPicker.getMsg();
        if (StringUtils.isEmpty((String)groupName)) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.REQUEST_PARAMETER_EMPTY_OR_VALUE_EMPTY, new Object[]{"group_name"});
        }
        if (groupName.startsWith(".")) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_USERGROUP_NAME, msg.getInvalidNameStartWithDot());
        }
        if (!groupName.equals(groupName.trim())) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_USERGROUP_NAME, msg.getInvalidNameStartOrEndWithBlank());
        }
        if (Pattern.compile("[^\\x00-\\xff]").matcher(groupName).find()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_USERGROUP_NAME, msg.getInvalidNameContainsOtherCharacter());
        }
        if (Pattern.compile("[\\\\/:*?\"<>|]").matcher(groupName).find()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_USERGROUP_NAME, msg.getInvalidNameContainsInlegalCharacter());
        }
    }
}

