/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.common.msg.Message;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.common.persistence.transaction.AclTCRRevokeEventNotifier;
import org.apache.kylin.common.scheduler.EventBusFactory;
import org.apache.kylin.common.scheduler.SchedulerEventNotifier;
import org.apache.kylin.common.util.RandomUtil;
import org.apache.kylin.metadata.user.ManagedUser;
import org.apache.kylin.rest.config.initialize.AfterMetadataReadyEvent;
import org.apache.kylin.rest.controller.NBasicController;
import org.apache.kylin.rest.exception.UnauthorizedException;
import org.apache.kylin.rest.request.PasswordChangeRequest;
import org.apache.kylin.rest.request.UserRequest;
import org.apache.kylin.rest.response.DataResult;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.apache.kylin.rest.response.ManagedUserResponse;
import org.apache.kylin.rest.security.AclPermission;
import org.apache.kylin.rest.service.AccessService;
import org.apache.kylin.rest.service.AclTCRService;
import org.apache.kylin.rest.service.IUserGroupService;
import org.apache.kylin.rest.service.OpenUserService;
import org.apache.kylin.rest.service.UserAclService;
import org.apache.kylin.rest.service.UserService;
import org.apache.kylin.rest.util.AclEvaluate;
import org.apache.kylin.rest.util.CreateAdminUserUtils;
import org.apache.kylin.rest.util.PagingUtil;
import org.apache.kylin.util.PasswordEncodeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationListener;
import org.springframework.core.env.Environment;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Controller
@RequestMapping(value={"/api/user"}, produces={"application/vnd.apache.kylin-v4+json"})
public class NUserController
extends NBasicController
implements ApplicationListener<AfterMetadataReadyEvent> {
    private static final Logger logger = LoggerFactory.getLogger(NUserController.class);
    private static final String PROFILE_DEFAULT = "testing";
    private static final String PROFILE_CUSTOM = "custom";
    @Autowired
    @Qualifier(value="userService")
    private UserService userService;
    @Autowired
    private AclEvaluate aclEvaluate;
    @Autowired
    @Qualifier(value="accessService")
    private AccessService accessService;
    @Autowired
    @Qualifier(value="aclTCRService")
    private AclTCRService aclTCRService;
    @Autowired
    @Qualifier(value="userGroupService")
    private IUserGroupService userGroupService;
    @Autowired
    @Qualifier(value="userAclService")
    UserAclService userAclService;
    @Autowired
    private Environment env;
    private static final Pattern passwordPattern = Pattern.compile("^(?=.*\\d)(?=.*[a-zA-Z])(?=.*[~!@#$%^&*(){}|:\"<>?\\[\\];',./`]).{8,}$");
    private static final Pattern bcryptPattern = Pattern.compile("\\A\\$2a?\\$\\d\\d\\$[./0-9A-Za-z]{53}");
    private static final Pattern base64Pattern = Pattern.compile("^([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{4}|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)$");
    private static final PasswordEncoder pwdEncoder = PasswordEncodeFactory.newUserPasswordEncoder();
    private static final SimpleGrantedAuthority ALL_USERS_AUTH = new SimpleGrantedAuthority("ALL_USERS");

    public void onApplicationEvent(AfterMetadataReadyEvent event) {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        if (!config.isUTEnv()) {
            return;
        }
        CreateAdminUserUtils.createAllAdmins((UserService)this.userService, (Environment)this.env);
    }

    @ApiOperation(value="createUser", tags={"MID"}, notes="Update Body: default_password, locked_time, wrong_time, first_login_failed_time")
    @PostMapping(value={""})
    @ResponseBody
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public EnvelopeResponse<String> createUser(@RequestBody UserRequest user) throws IOException {
        this.checkRequiredArg("disabled", user.getDisabled());
        this.checkUsername(user.getUsername());
        this.checkRequiredArg("password", user.getPassword());
        String decodedPassword = this.pwdBase64Decode(user.getPassword());
        this.checkPasswordLength(decodedPassword);
        this.checkPasswordCharacter(decodedPassword);
        user.setPassword(decodedPassword);
        List simpleGrantedAuthorities = user.transformSimpleGrantedAuthorities();
        this.checkUserGroupNotEmpty(simpleGrantedAuthorities);
        this.checkUserGroupExists(simpleGrantedAuthorities, this.userGroupService.getAllUserGroups());
        this.checkUserGroupNotDuplicated(simpleGrantedAuthorities);
        return this.createAdminUser(user.updateManager(new ManagedUser()));
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public EnvelopeResponse<String> createAdminUser(@RequestBody ManagedUser user) {
        this.checkProfile();
        user.setUuid(RandomUtil.randomUUIDStr());
        user.setPassword(this.pwdEncode(user.getPassword()));
        logger.info("Creating user: {}", (Object)user);
        this.completeAuthorities(user);
        user.setDefaultPassword(true);
        this.userService.createUser((UserDetails)user);
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="updateUser", tags={"MID"}, notes="Update Body: default_password, locked_time, wrong_time, first_login_failed_time")
    @PutMapping(value={""})
    @ResponseBody
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public EnvelopeResponse<String> updateUser(@RequestBody UserRequest userRequest) throws IOException {
        Message msg = MsgPicker.getMsg();
        this.checkProfile();
        String username = userRequest.getUsername();
        this.checkUsername(username);
        ManagedUser existing = this.getManagedUser(username);
        ManagedUser mergeUser = userRequest.updateManager(existing);
        if (StringUtils.equals((String)this.getPrincipal(), (String)mergeUser.getUsername()) && mergeUser.isDisabled()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.FAILED_UPDATE_USER, msg.getSelfDisableForbidden());
        }
        if (StringUtils.equals((String)this.getPrincipal(), (String)userRequest.getUsername())) {
            boolean roleChange;
            Set userGroupSet = mergeUser.getAuthorities().stream().map(SimpleGrantedAuthority::getAuthority).collect(Collectors.toSet());
            Set currentUserGroupSet = this.userGroupService.listUserGroups(mergeUser.getUsername());
            boolean bl = roleChange = userGroupSet.size() != currentUserGroupSet.size() || !userGroupSet.containsAll(currentUserGroupSet);
            if (roleChange) {
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.FAILED_UPDATE_USER, msg.getSelfEditForbidden());
            }
        }
        if (existing == null) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.USER_NOT_EXIST, String.format(Locale.ROOT, msg.getUserNotFound(), username));
        }
        if (mergeUser.getAuthorities() == null || mergeUser.getAuthorities().isEmpty()) {
            mergeUser.setGrantedAuthorities((Collection)existing.getAuthorities());
        }
        mergeUser.setPassword(this.pwdBase64Decode(mergeUser.getPassword()));
        if (!mergeUser.isDefaultPassword()) {
            this.checkPasswordLength(mergeUser.getPassword());
            this.checkPasswordCharacter(mergeUser.getPassword());
        }
        mergeUser.setPassword(this.pwdEncode(mergeUser.getPassword()));
        List allGroups = this.userGroupService.getAllUserGroups();
        this.checkUserGroupExists(mergeUser.getAuthorities(), allGroups);
        this.checkUserGroupNotDuplicated(mergeUser.getAuthorities());
        this.completeAuthorities(mergeUser);
        boolean noAdminRight = mergeUser.getAuthorities().contains(new SimpleGrantedAuthority("ROLE_ADMIN"));
        this.accessService.checkDefaultAdmin(mergeUser.getUsername(), noAdminRight);
        logger.info("Saving user {}", (Object)mergeUser);
        this.userService.updateUser((UserDetails)mergeUser);
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="deleteUser", tags={"MID"})
    @DeleteMapping(value={"/{uuid:.+}"})
    @ResponseBody
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public EnvelopeResponse<String> deleteByUUID(@PathVariable(value="uuid") String userUUID) {
        Message msg = MsgPicker.getMsg();
        this.checkProfile();
        ManagedUser toBeDeleteUser = null;
        try {
            toBeDeleteUser = this.userService.listUsers().parallelStream().filter(user -> userUUID.equalsIgnoreCase(user.getUuid())).findAny().orElse(null);
        }
        catch (IOException e) {
            logger.error("List all users is failed!", (Throwable)e);
        }
        if (Objects.isNull(toBeDeleteUser)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.USER_NOT_EXIST, String.format(Locale.ROOT, msg.getUserNotExist(), userUUID));
        }
        if (StringUtils.equals((String)this.getPrincipal(), (String)toBeDeleteUser.getUsername())) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.FAILED_UPDATE_USER, msg.getSelfDeleteForbidden());
        }
        this.accessService.checkDefaultAdmin(toBeDeleteUser.getUsername(), false);
        this.accessService.revokeProjectPermission(toBeDeleteUser.getUsername(), "user");
        this.aclTCRService.revokeAclTCR(toBeDeleteUser.getUsername(), true);
        EventBusFactory.getInstance().postAsync((SchedulerEventNotifier)new AclTCRRevokeEventNotifier(toBeDeleteUser.getUsername(), true));
        this.userService.deleteUser(toBeDeleteUser.getUsername());
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="deleteUser", tags={"MID"})
    @DeleteMapping(value={"/batch"})
    @ResponseBody
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public EnvelopeResponse<String> batchDelete(@RequestBody List<String> usernames) throws IOException {
        Message msg = MsgPicker.getMsg();
        this.checkProfile();
        usernames.forEach(this::checkUsername);
        String currentUser = this.getPrincipal();
        usernames.forEach(username -> {
            if (StringUtils.equals((String)currentUser, (String)username)) {
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.FAILED_UPDATE_USER, msg.getSelfDeleteForbidden());
            }
        });
        List existedUsers = this.userService.listUsers();
        List notInList = usernames.stream().filter(t -> existedUsers.stream().map(ManagedUser::getUsername).noneMatch(a -> a.equalsIgnoreCase((String)t))).collect(Collectors.toList());
        if (notInList.size() > 0) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.USER_NOT_EXIST, String.format(Locale.ROOT, msg.getUserNotFound(), String.join((CharSequence)",", notInList)));
        }
        usernames.forEach(username -> {
            this.accessService.checkDefaultAdmin(username, false);
            this.accessService.revokeProjectPermission(username, "user");
            this.aclTCRService.revokeAclTCR(username, true);
            EventBusFactory.getInstance().postAsync((SchedulerEventNotifier)new AclTCRRevokeEventNotifier(username, true));
            this.userService.deleteUser(username);
        });
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="createUser", tags={"MID"}, notes="Update Body: default_password, locked_time, wrong_time, first_login_failed_time")
    @PostMapping(value={"/batch"})
    @ResponseBody
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public EnvelopeResponse<String> batchCreate(@RequestBody List<UserRequest> users) throws IOException {
        for (UserRequest user : users) {
            this.createUser(user);
        }
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public EnvelopeResponse<String> delete(@PathVariable(value="username") String username) {
        Message msg = MsgPicker.getMsg();
        this.checkProfile();
        this.checkUsername(username);
        ManagedUser managedUser = null;
        try {
            managedUser = this.getManagedUser(username);
        }
        catch (UsernameNotFoundException e) {
            logger.warn("Delete user failed, user {} not found.", (Object)username);
        }
        if (Objects.isNull(managedUser)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.USER_NOT_EXIST, String.format(Locale.ROOT, msg.getUserNotFound(), username));
        }
        if (StringUtils.equals((String)this.getPrincipal(), (String)username)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.FAILED_UPDATE_USER, msg.getSelfDeleteForbidden());
        }
        this.accessService.checkDefaultAdmin(username, false);
        this.accessService.revokeProjectPermission(username, "user");
        this.aclTCRService.revokeAclTCR(username, true);
        EventBusFactory.getInstance().postAsync((SchedulerEventNotifier)new AclTCRRevokeEventNotifier(username, true));
        this.userService.deleteUser(username);
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="listAllUsers", tags={"MID"}, notes="Update Param: is_case_sensitive, page_offset, page_size; Update Response: total_size")
    @GetMapping(value={""})
    @ResponseBody
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public EnvelopeResponse<DataResult<List<ManagedUserResponse>>> listAllUsers(@RequestParam(value="name", required=false) String nameSeg, @RequestParam(value="is_case_sensitive", required=false) boolean isCaseSensitive, @RequestParam(value="page_offset", required=false, defaultValue="0") Integer pageOffset, @RequestParam(value="page_size", required=false, defaultValue="10") Integer pageSize) throws IOException {
        List usersByFuzzyMatching = this.userService.getManagedUsersByFuzzMatching(nameSeg, isCaseSensitive);
        List subList = PagingUtil.cutPage((List)usersByFuzzyMatching, (int)pageOffset, (int)pageSize);
        if (this.userService instanceof OpenUserService) {
            this.userService.listAdminUsers();
        }
        List superAdminUsers = this.userService.listSuperAdminUsers();
        ArrayList<ManagedUserResponse> userList = new ArrayList<ManagedUserResponse>();
        for (ManagedUser u : subList) {
            ManagedUserResponse managedUserResponse = new ManagedUserResponse();
            managedUserResponse.setManagedUser(u);
            this.userService.completeUserInfo(u);
            if (this.userService.isGlobalAdmin(u.getUsername()) && this.userAclService.hasUserAclPermission(u.getUsername(), AclPermission.DATA_QUERY)) {
                managedUserResponse.setHasQueryPermission(true);
            }
            if (managedUserResponse.isHasQueryPermission() && CollectionUtils.isNotEmpty((Collection)superAdminUsers)) {
                managedUserResponse.setSuperAdmin(superAdminUsers.stream().anyMatch(adminUser -> StringUtils.equalsIgnoreCase((String)adminUser, (String)u.getUsername())));
            }
            userList.add(managedUserResponse);
        }
        int userSize = usersByFuzzyMatching == null ? 0 : usersByFuzzyMatching.size();
        return new EnvelopeResponse("000", (Object)new DataResult(userList, userSize, pageOffset.intValue(), pageSize.intValue()), "");
    }

    @ApiOperation(value="listSuperAdmin", tags={"MID"})
    @GetMapping(value={"/super_admin"})
    @ResponseBody
    public EnvelopeResponse<List<String>> listSuperAdmin() {
        return new EnvelopeResponse("000", (Object)this.userService.listSuperAdminUsers(), "");
    }

    @ApiOperation(value="changePassword", tags={"MID"})
    @PutMapping(value={"/password"})
    @ResponseBody
    public EnvelopeResponse<String> updateUserPassword(@RequestBody PasswordChangeRequest user) {
        Message msg = MsgPicker.getMsg();
        String username = user.getUsername();
        if (!NUserController.isAdmin() && !StringUtils.equals((String)this.getPrincipal(), (String)username)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.PERMISSION_DENIED, msg.getPermissionDenied());
        }
        this.accessService.checkDefaultAdmin(username, true);
        this.checkUsername(username);
        ManagedUser existingUser = this.getManagedUser(username);
        if (existingUser == null) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.USER_NOT_EXIST, String.format(Locale.ROOT, msg.getUserNotFound(), username));
        }
        String actualOldPassword = existingUser.getPassword();
        String oldPassword = this.pwdBase64Decode(StringUtils.isEmpty((String)user.getPassword()) ? "" : user.getPassword());
        if (StringUtils.equals((String)this.getPrincipal(), (String)username)) {
            this.checkRequiredArg("password", user.getPassword());
            if (!pwdEncoder.matches((CharSequence)oldPassword, actualOldPassword)) {
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.FAILED_UPDATE_PASSWORD, msg.getOldPasswordWrong());
            }
        }
        this.checkRequiredArg("new_password", user.getNewPassword());
        String newPassword = this.pwdBase64Decode(StringUtils.isEmpty((String)user.getNewPassword()) ? "" : user.getNewPassword());
        this.checkPasswordLength(newPassword);
        this.checkPasswordCharacter(newPassword);
        if (newPassword.equals(oldPassword)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.FAILED_UPDATE_PASSWORD, msg.getNewPasswordSameAsOld());
        }
        existingUser.setPassword(this.pwdEncode(newPassword));
        existingUser.setDefaultPassword(false);
        logger.info("update password for user {}", (Object)user);
        existingUser.clearAuthenticateFailedRecord();
        this.completeAuthorities(existingUser);
        this.userService.updateUser((UserDetails)existingUser);
        if (StringUtils.equals((String)this.getPrincipal(), (String)user.getUsername())) {
            UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)existingUser, (Object)newPassword, (Collection)existingUser.getAuthorities());
            token.setDetails(SecurityContextHolder.getContext().getAuthentication().getDetails());
            SecurityContextHolder.getContext().setAuthentication((Authentication)token);
        }
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="auth", tags={"MID"})
    @PostMapping(value={"/authentication"}, produces={"application/vnd.apache.kylin-v4+json", "application/vnd.apache.kylin-v4-public+json"})
    @ResponseBody
    public EnvelopeResponse<UserDetails> authenticate() {
        EnvelopeResponse<UserDetails> response = this.authenticatedUser();
        this.checkSessionStoreType(KylinConfig.getInstanceFromEnv());
        logger.debug("User login: {}", response.getData());
        return response;
    }

    @ApiOperation(value="updateUser", tags={"MID"})
    @PostMapping(value={"/update_user"})
    @ResponseBody
    public EnvelopeResponse<UserDetails> updateUserWithoutAuth(@RequestBody ManagedUser user) {
        this.userService.updateUser((UserDetails)user);
        return new EnvelopeResponse("000", null, "");
    }

    @ApiOperation(value="authentication", tags={"MID"})
    @GetMapping(value={"/authentication"}, produces={"application/vnd.apache.kylin-v4+json", "application/vnd.apache.kylin-v4-public+json"})
    @ResponseBody
    public EnvelopeResponse<UserDetails> authenticatedUser() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            throw new UnauthorizedException((ErrorCodeProducer)ErrorCodeServer.USER_AUTH_INFO_NOTFOUND, new Object[0]);
        }
        if (authentication.getPrincipal() instanceof UserDetails) {
            UserDetails data = (UserDetails)authentication.getPrincipal();
            return new EnvelopeResponse("000", (Object)data, "");
        }
        if (authentication.getDetails() instanceof UserDetails) {
            UserDetails data = (UserDetails)authentication.getDetails();
            return new EnvelopeResponse("000", (Object)data, "");
        }
        throw new UnauthorizedException((ErrorCodeProducer)ErrorCodeServer.USER_AUTH_INFO_NOTFOUND, new Object[0]);
    }

    private void checkPasswordCharacter(String password) {
        Message msg = MsgPicker.getMsg();
        if (!passwordPattern.matcher(password).matches()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PASSWORD, msg.getInvalidPassword());
        }
    }

    private void checkProfile() {
        Message msg = MsgPicker.getMsg();
        if (!this.env.acceptsProfiles(new String[]{PROFILE_DEFAULT, PROFILE_CUSTOM})) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.FAILED_UPDATE_USER, msg.getUserEditNotAllowed());
        }
    }

    private void checkPasswordLength(String password) {
        Message msg = MsgPicker.getMsg();
        if (password == null || password.length() < 8) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.SHORT_PASSWORD, msg.getShortPassword());
        }
    }

    private void checkUsername(String username) {
        if (this.env.acceptsProfiles(new String[]{PROFILE_CUSTOM})) {
            return;
        }
        Message msg = MsgPicker.getMsg();
        if (StringUtils.isEmpty((String)username)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.EMPTY_USER_NAME, msg.getEmptyUserName());
        }
        if (username.startsWith(".")) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_USER_NAME, msg.getInvalidNameStartWithDot());
        }
        if (!username.equals(username.trim())) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_USER_NAME, msg.getInvalidNameStartOrEndWithBlank());
        }
        if (username.length() > 180) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_USER_NAME, msg.getInvalidNameLength());
        }
        if (Pattern.compile("[^\\x00-\\xff]").matcher(username).find()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_USER_NAME, msg.getInvalidNameContainsOtherCharacter());
        }
        if (Pattern.compile("[\\\\/:*?\"<>|]").matcher(username).find()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_USER_NAME, msg.getInvalidNameContainsInlegalCharacter());
        }
    }

    private String getPrincipal() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            return null;
        }
        Object principal = authentication.getPrincipal();
        String userName = principal instanceof UserDetails ? ((UserDetails)principal).getUsername() : (authentication.getDetails() instanceof UserDetails ? ((UserDetails)authentication.getDetails()).getUsername() : principal.toString());
        return userName;
    }

    public ManagedUser getManagedUser(String userName) {
        UserDetails details = this.userService.loadUserByUsername(userName);
        if (details == null) {
            return null;
        }
        return (ManagedUser)details;
    }

    private void completeAuthorities(ManagedUser managedUser) {
        ArrayList detailRoles = Lists.newArrayList((Iterable)managedUser.getAuthorities());
        if (!detailRoles.contains(ALL_USERS_AUTH)) {
            detailRoles.add(ALL_USERS_AUTH);
        }
        managedUser.setGrantedAuthorities((Collection)detailRoles);
    }

    private String pwdEncode(String pwd) {
        if (bcryptPattern.matcher(pwd).matches()) {
            return pwd;
        }
        return pwdEncoder.encode((CharSequence)pwd);
    }

    private String pwdBase64Decode(String password) {
        boolean isMatch = base64Pattern.matcher(password).matches();
        if (isMatch) {
            return new String(Base64.decodeBase64((String)password), Charset.defaultCharset());
        }
        return password;
    }

    private void checkUserGroupNotEmpty(List<SimpleGrantedAuthority> groups) {
        boolean hasEmptyGroup;
        boolean bl = hasEmptyGroup = CollectionUtils.isEmpty(groups) || groups.stream().map(SimpleGrantedAuthority::getAuthority).anyMatch(StringUtils::isBlank);
        if (hasEmptyGroup) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.REQUEST_PARAMETER_EMPTY_OR_VALUE_EMPTY, new Object[]{"authorities"});
        }
    }

    private void checkUserGroupExists(List<SimpleGrantedAuthority> groups, List<String> allGroups) {
        for (SimpleGrantedAuthority group : groups) {
            if (allGroups.contains(group.getAuthority())) continue;
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.USER_GROUP_NOT_EXIST, new Object[]{group});
        }
    }

    private void checkUserGroupNotDuplicated(List<SimpleGrantedAuthority> groups) {
        List authorities = groups.stream().map(SimpleGrantedAuthority::getAuthority).collect(Collectors.toList());
        if (authorities.size() != Sets.newHashSet(authorities).size()) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.REPEATED_PARAMETER, new Object[]{"authorities"});
        }
    }

    private void checkSessionStoreType(KylinConfig env) {
        String type = env.getSpringStoreType();
        HttpServletRequest request = ((ServletRequestAttributes)Objects.requireNonNull(RequestContextHolder.getRequestAttributes())).getRequest();
        if ("jbdc".equals(type)) {
            request.getSession().setMaxInactiveInterval(env.getJdbcSessionMaxInactiveInterval());
        }
    }
}

