/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller;

import com.google.common.collect.Sets;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.validation.Valid;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.common.util.FileUtils;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.rest.controller.NBasicController;
import org.apache.kylin.rest.request.ComputedColumnConfigRequest;
import org.apache.kylin.rest.request.DataSourceTypeRequest;
import org.apache.kylin.rest.request.DefaultDatabaseRequest;
import org.apache.kylin.rest.request.FavoriteQueryThresholdRequest;
import org.apache.kylin.rest.request.GarbageCleanUpConfigRequest;
import org.apache.kylin.rest.request.JdbcRequest;
import org.apache.kylin.rest.request.JdbcSourceInfoRequest;
import org.apache.kylin.rest.request.JobNotificationConfigRequest;
import org.apache.kylin.rest.request.MultiPartitionConfigRequest;
import org.apache.kylin.rest.request.OwnerChangeRequest;
import org.apache.kylin.rest.request.ProjectConfigRequest;
import org.apache.kylin.rest.request.ProjectConfigResetRequest;
import org.apache.kylin.rest.request.ProjectExclusionRequest;
import org.apache.kylin.rest.request.ProjectGeneralInfoRequest;
import org.apache.kylin.rest.request.ProjectKerberosInfoRequest;
import org.apache.kylin.rest.request.ProjectRequest;
import org.apache.kylin.rest.request.PushDownConfigRequest;
import org.apache.kylin.rest.request.PushDownProjectConfigRequest;
import org.apache.kylin.rest.request.SCD2ConfigRequest;
import org.apache.kylin.rest.request.SegmentConfigRequest;
import org.apache.kylin.rest.request.ShardNumConfigRequest;
import org.apache.kylin.rest.request.SnapshotConfigRequest;
import org.apache.kylin.rest.request.StorageQuotaRequest;
import org.apache.kylin.rest.request.YarnQueueRequest;
import org.apache.kylin.rest.response.DataResult;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.apache.kylin.rest.response.FavoriteQueryThresholdResponse;
import org.apache.kylin.rest.response.ProjectConfigResponse;
import org.apache.kylin.rest.response.StorageVolumeInfoResponse;
import org.apache.kylin.rest.response.UserProjectPermissionResponse;
import org.apache.kylin.rest.security.AclPermissionEnum;
import org.apache.kylin.rest.security.AclPermissionFactory;
import org.apache.kylin.rest.service.EpochService;
import org.apache.kylin.rest.service.ModelService;
import org.apache.kylin.rest.service.ProjectModelSupporter;
import org.apache.kylin.rest.service.ProjectService;
import org.apache.kylin.rest.util.AclEvaluate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/api/projects"}, produces={"application/vnd.apache.kylin-v4+json", "application/vnd.apache.kylin-v4-public+json"})
public class NProjectController
extends NBasicController {
    private static final Logger logger = LoggerFactory.getLogger(NProjectController.class);
    private static final char[] VALID_PROJECT_NAME = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890_".toCharArray();
    @Autowired
    private AclEvaluate aclEvaluate;
    @Autowired
    @Qualifier(value="projectService")
    private ProjectService projectService;
    @Autowired
    @Qualifier(value="modelService")
    private ModelService modelService;
    @Autowired
    @Qualifier(value="epochService")
    private EpochService epochService;

    @ApiOperation(value="getProjects", tags={"SM"}, notes="Update Param: page_offset, page_size; Update Response: total_size")
    @GetMapping(value={""})
    @ResponseBody
    public EnvelopeResponse<DataResult<List<UserProjectPermissionResponse>>> getProjects(@RequestParam(value="project", required=false) String project, @RequestParam(value="page_offset", required=false, defaultValue="0") Integer offset, @RequestParam(value="page_size", required=false, defaultValue="10") Integer size, @RequestParam(value="exact", required=false, defaultValue="false") boolean exactMatch, @RequestParam(value="permission", required=false, defaultValue="READ") String permission) throws IOException {
        if (Objects.isNull(AclPermissionFactory.getPermission((String)permission))) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.PERMISSION_DENIED, "Operation failed, unknown permission:" + permission);
        }
        List projects = this.projectService.getProjectsFilterByExactMatchAndPermissionWrapperUserPermission(project, exactMatch, AclPermissionEnum.valueOf((String)permission));
        return new EnvelopeResponse("000", (Object)DataResult.get((List)projects, (int)offset, (int)size), "");
    }

    @ApiOperation(value="deleteProjects", tags={"SM"})
    @DeleteMapping(value={"/{project:.+}"})
    @ResponseBody
    public EnvelopeResponse<String> dropProject(@PathVariable(value="project") String project) {
        this.projectService.dropProject(project);
        this.projectService.clearManagerCache(project);
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="backupProject", tags={"SM"}, notes="Update URL, {project}")
    @PostMapping(value={"/{project:.+}/backup"})
    @ResponseBody
    public EnvelopeResponse<String> backupProject(@PathVariable(value="project") String project) throws Exception {
        this.checkProjectName(project);
        return new EnvelopeResponse("000", (Object)this.projectService.backupProject(project), "");
    }

    @ApiOperation(value="saveProject", tags={"SM"}, notes="Update Param: former_project_name, project_desc_data")
    @PostMapping(value={""})
    @ResponseBody
    public EnvelopeResponse<ProjectInstance> saveProject(@Valid @RequestBody ProjectRequest projectRequest) {
        ProjectInstance projectDesc = new ProjectInstance();
        BeanUtils.copyProperties((Object)projectRequest, (Object)projectDesc);
        this.checkRequiredArg("name", projectRequest.getName());
        if (StringUtils.isEmpty((String)projectRequest.getName()) || !StringUtils.containsOnly((String)projectDesc.getName(), (char[])VALID_PROJECT_NAME)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PROJECT_NAME, MsgPicker.getMsg().getInvalidProjectName());
        }
        if (projectRequest.getName().length() > 50) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.PROJECT_NAME_ILLEGAL, MsgPicker.getMsg().getProjectNameIsIllegal());
        }
        ProjectInstance createdProj = this.projectService.createProject(projectDesc.getName(), projectDesc);
        try {
            this.epochService.updateEpoch(Collections.singletonList(projectDesc.getName()), false, false);
        }
        catch (Exception e) {
            logger.warn("Transfer update epoch {} request failed, wait for schedule worker to update epoch.", (Object)projectDesc.getName(), (Object)e);
        }
        return new EnvelopeResponse("000", (Object)createdProj, "");
    }

    @ApiOperation(value="updateDefaultDatabase", tags={"SM"}, notes="Add URL: {project}; Update Param: default_database;")
    @PutMapping(value={"/{project:.+}/default_database"})
    @ResponseBody
    public EnvelopeResponse<String> updateDefaultDatabase(@PathVariable(value="project") String project, @RequestBody DefaultDatabaseRequest defaultDatabaseRequest) {
        this.checkRequiredArg("default_database", defaultDatabaseRequest.getDefaultDatabase());
        this.projectService.updateDefaultDatabase(project, defaultDatabaseRequest.getDefaultDatabase());
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="updateQueryAccelerateThresholdConfig", tags={"SM"}, notes="Add URL: {project}; ")
    @PutMapping(value={"/{project:.+}/query_accelerate_threshold"})
    @ResponseBody
    public EnvelopeResponse<String> updateQueryAccelerateThresholdConfig(@PathVariable(value="project") String project, @RequestBody FavoriteQueryThresholdRequest favoriteQueryThresholdRequest) {
        this.checkRequiredArg("tips_enabled", favoriteQueryThresholdRequest.getTipsEnabled());
        if (Boolean.TRUE.equals(favoriteQueryThresholdRequest.getTipsEnabled())) {
            this.checkRequiredArg("threshold", favoriteQueryThresholdRequest.getThreshold());
        }
        this.projectService.updateQueryAccelerateThresholdConfig(project, favoriteQueryThresholdRequest.getThreshold(), favoriteQueryThresholdRequest.getTipsEnabled().booleanValue());
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="getQueryAccelerateThresholdConfig", tags={"SM"}, notes="Add URL: {project}; ")
    @GetMapping(value={"/{project:.+}/query_accelerate_threshold"})
    @ResponseBody
    public EnvelopeResponse<FavoriteQueryThresholdResponse> getQueryAccelerateThresholdConfig(@PathVariable(value="project") String project) {
        return new EnvelopeResponse("000", (Object)this.projectService.getQueryAccelerateThresholdConfig(project), "");
    }

    @ApiOperation(value="getStorageVolumeInfo", tags={"SM"}, notes="Add URL: {project}; ")
    @GetMapping(value={"/{project:.+}/storage_volume_info"})
    @ResponseBody
    public EnvelopeResponse<StorageVolumeInfoResponse> getStorageVolumeInfo(@PathVariable(value="project") String project) {
        this.aclEvaluate.checkProjectReadPermission(project);
        return new EnvelopeResponse("000", (Object)this.projectService.getStorageVolumeInfoResponse(project), "");
    }

    @ApiOperation(value="cleanupProjectStorage", tags={"SM"}, notes="Add URL: {project}; ")
    @PutMapping(value={"/{project:.+}/storage"})
    @ResponseBody
    public EnvelopeResponse<Boolean> cleanupProjectStorage(@PathVariable(value="project") String project) throws Exception {
        ProjectInstance projectInstance = ((NProjectManager)this.projectService.getManager(NProjectManager.class)).getProject(project);
        if (projectInstance == null) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.PROJECT_NOT_EXIST, new Object[]{project});
        }
        this.projectService.cleanupGarbage(project);
        return new EnvelopeResponse("000", (Object)true, "");
    }

    @ApiOperation(value="updateStorageQuotaConfig", tags={"SM"}, notes="Add URL: {project}; ")
    @PutMapping(value={"/{project:.+}/storage_quota"})
    @ResponseBody
    public EnvelopeResponse<Boolean> updateStorageQuotaConfig(@PathVariable(value="project") String project, @RequestBody StorageQuotaRequest storageQuotaRequest) {
        this.checkProjectName(project);
        this.checkRequiredArg("storage_quota_size", storageQuotaRequest.getStorageQuotaSize());
        this.projectService.updateStorageQuotaConfig(project, storageQuotaRequest.getStorageQuotaSize().longValue());
        return new EnvelopeResponse("000", (Object)true, "");
    }

    @ApiOperation(value="updateShardNumConfig", tags={"SM"}, notes="Add URL: {project}; ")
    @PutMapping(value={"/{project:.+}/shard_num_config"})
    @ResponseBody
    public EnvelopeResponse<String> updateShardNumConfig(@PathVariable(value="project") String project, @RequestBody ShardNumConfigRequest req) {
        this.projectService.updateShardNumConfig(project, req);
        return new EnvelopeResponse("000", (Object)this.projectService.getShardNumConfig(project), "");
    }

    @ApiOperation(value="updateGarbageCleanupConfig", tags={"SM"}, notes="Add URL: {project}; ")
    @PutMapping(value={"/{project:.+}/garbage_cleanup_config"})
    @ResponseBody
    public EnvelopeResponse<Boolean> updateGarbageCleanupConfig(@PathVariable(value="project") String project, @RequestBody GarbageCleanUpConfigRequest garbageCleanUpConfigRequest) {
        this.checkRequiredArg("low_frequency_threshold", garbageCleanUpConfigRequest.getLowFrequencyThreshold());
        this.checkRequiredArg("frequency_time_window", garbageCleanUpConfigRequest.getFrequencyTimeWindow());
        this.projectService.updateGarbageCleanupConfig(project, garbageCleanUpConfigRequest);
        return new EnvelopeResponse("000", (Object)true, "");
    }

    @ApiOperation(value="updateJobNotificationConfig", tags={"DW"}, notes="Add URL: {project}; ")
    @PutMapping(value={"/{project:.+}/job_notification_config"})
    @ResponseBody
    public EnvelopeResponse<String> updateJobNotificationConfig(@PathVariable(value="project") String project, @RequestBody JobNotificationConfigRequest jobNotificationConfigRequest) {
        this.checkRequiredArg("data_load_empty_notification_enabled", jobNotificationConfigRequest.getDataLoadEmptyNotificationEnabled());
        this.checkRequiredArg("job_notification_states", jobNotificationConfigRequest.getJobNotificationStates());
        this.checkRequiredArg("job_notification_emails", jobNotificationConfigRequest.getJobNotificationEmails());
        this.checkRequiredArg("metadata_persist_notification_enabled", jobNotificationConfigRequest.getMetadataPersistNotificationEnabled());
        this.projectService.updateJobNotificationConfig(project, jobNotificationConfigRequest);
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="updatePushDownConfig", tags={"QE"}, notes="Add URL: {project}; ")
    @PutMapping(value={"/{project:.+}/push_down_config"})
    @ResponseBody
    public EnvelopeResponse<String> updatePushDownConfig(@PathVariable(value="project") String project, @RequestBody PushDownConfigRequest pushDownConfigRequest) {
        this.checkRequiredArg("push_down_enabled", pushDownConfigRequest.getPushDownEnabled());
        this.projectService.updatePushDownConfig(project, pushDownConfigRequest);
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="updateSCD2Config", tags={"AI"}, notes="Add URL: {project}; ")
    @PutMapping(value={"/{project:.+}/scd2_config"})
    @ResponseBody
    public EnvelopeResponse<String> updateSCD2Config(@PathVariable(value="project") String project, @RequestBody SCD2ConfigRequest scd2ConfigRequest) {
        this.checkRequiredArg("scd2_enabled", scd2ConfigRequest.getScd2Enabled());
        this.projectService.updateSCD2Config(project, scd2ConfigRequest, (ProjectModelSupporter)this.modelService);
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="updatePushDownProjectConfig", tags={"QE"}, notes="Add URL: {project}; ")
    @PutMapping(value={"/{project:.+}/push_down_project_config"})
    @ResponseBody
    public EnvelopeResponse<String> updatePushDownProjectConfig(@PathVariable(value="project") String project, @RequestBody PushDownProjectConfigRequest pushDownProjectConfigRequest) {
        this.checkRequiredArg("runner_class_name", pushDownProjectConfigRequest.getRunnerClassName());
        this.checkRequiredArg("converter_class_names", pushDownProjectConfigRequest.getConverterClassNames());
        this.projectService.updatePushDownProjectConfig(project, pushDownProjectConfigRequest);
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="updateSnapshotConfig", tags={"AI"}, notes="Add URL: {project}; ")
    @PutMapping(value={"/{project:.+}/snapshot_config"})
    @ResponseBody
    public EnvelopeResponse<String> updateSnapshotConfig(@PathVariable(value="project") String project, @RequestBody SnapshotConfigRequest snapshotConfigRequest) {
        this.checkBooleanArg("snapshot_manual_management_enabled", snapshotConfigRequest.getSnapshotManualManagementEnabled());
        this.checkBooleanArg("snapshot_automatic_refresh_enabled", snapshotConfigRequest.getSnapshotAutoRefreshEnabled());
        this.projectService.updateSnapshotConfig(project, snapshotConfigRequest);
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="updateExposeComputedColumnConfig", tags={"QE"}, notes="Add URL: {project}; ")
    @PutMapping(value={"/{project:.+}/computed_column_config"})
    @ResponseBody
    public EnvelopeResponse<String> updatePushDownConfig(@PathVariable(value="project") String project, @RequestBody ComputedColumnConfigRequest computedColumnConfigRequest) {
        this.checkRequiredArg("expose_computed_column", computedColumnConfigRequest.getExposeComputedColumn());
        this.projectService.updateComputedColumnConfig(project, computedColumnConfigRequest);
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="updateSegmentConfig", tags={"DW"}, notes="Add URL: {project}; ")
    @PutMapping(value={"/{project:.+}/segment_config"})
    @ResponseBody
    public EnvelopeResponse<String> updateSegmentConfig(@PathVariable(value="project") String project, @RequestBody SegmentConfigRequest segmentConfigRequest) {
        this.checkRequiredArg("auto_merge_enabled", segmentConfigRequest.getAutoMergeEnabled());
        this.checkRequiredArg("auto_merge_time_ranges", segmentConfigRequest.getAutoMergeTimeRanges());
        this.checkRequiredArg("create_empty_segment_enabled", segmentConfigRequest.getCreateEmptySegmentEnabled());
        this.projectService.updateSegmentConfig(project, segmentConfigRequest);
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="updateProjectGeneralInfo", tags={"SM"}, notes="Add URL: {project}; ")
    @PutMapping(value={"/{project:.+}/project_general_info"})
    @ResponseBody
    public EnvelopeResponse<String> updateProjectGeneralInfo(@PathVariable(value="project") String project, @RequestBody ProjectGeneralInfoRequest projectGeneralInfoRequest) {
        this.projectService.updateProjectGeneralInfo(project, projectGeneralInfoRequest);
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="getProjectConfig", tags={"SM"}, notes="Add URL: {project}; ")
    @GetMapping(value={"/{project:.+}/project_config"})
    @ResponseBody
    public EnvelopeResponse<ProjectConfigResponse> getProjectConfig(@PathVariable(value="project") String project) {
        return new EnvelopeResponse("000", (Object)this.projectService.getProjectConfig(project), "");
    }

    @ApiOperation(value="resetProjectConfig", tags={"SM"}, notes="Add URL: {project}; ")
    @PutMapping(value={"/{project:.+}/project_config"})
    @ResponseBody
    public EnvelopeResponse<ProjectConfigResponse> resetProjectConfig(@PathVariable(value="project") String project, @RequestBody ProjectConfigResetRequest projectConfigResetRequest) {
        this.checkRequiredArg("reset_item", projectConfigResetRequest.getResetItem());
        return new EnvelopeResponse("000", (Object)this.projectService.resetProjectConfig(project, projectConfigResetRequest.getResetItem()), "");
    }

    @ApiOperation(value="setDataSourceType", tags={"DW"}, notes="Add URL: {project}; ")
    @PutMapping(value={"/{project:.+}/source_type"})
    @ResponseBody
    public EnvelopeResponse<String> setDataSourceType(@PathVariable(value="project") String project, @RequestBody DataSourceTypeRequest request) {
        this.aclEvaluate.checkProjectWritePermission(project);
        this.projectService.setDataSourceType(project, request.getSourceType());
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="updateYarnQueue", tags={"DW"}, notes="Add URL: {project}; ")
    @PutMapping(value={"/{project:.+}/yarn_queue"})
    @ResponseBody
    public EnvelopeResponse<String> updateYarnQueue(@PathVariable(value="project") String project, @RequestBody YarnQueueRequest request) {
        this.checkRequiredArg("queue_name", request.getQueueName());
        this.projectService.updateYarnQueue(project, request.getQueueName());
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="updateProjectKerberosInfo", tags={"DW"}, notes="Add URL: {project}; ")
    @PutMapping(value={"/{project:.+}/project_kerberos_info"})
    @ResponseBody
    public EnvelopeResponse<String> updateProjectKerberosInfo(@PathVariable(value="project") String project, @RequestParam(value="file") MultipartFile keytabFile, ProjectKerberosInfoRequest projectKerberosInfoRequest) throws Exception {
        File file = this.projectService.generateTempKeytab(projectKerberosInfoRequest.getPrincipal(), keytabFile);
        projectKerberosInfoRequest.setKeytab(FileUtils.encodeBase64File((String)file.getAbsolutePath()));
        this.projectService.updateProjectKerberosInfo(project, projectKerberosInfoRequest);
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="updateProjectOwner", tags={"SM"})
    @PutMapping(value={"/{project:.+}/owner"})
    @ResponseBody
    public EnvelopeResponse<String> updateProjectOwner(@PathVariable(value="project") String project, @RequestBody OwnerChangeRequest request) {
        this.checkProjectName(project);
        this.checkRequiredArg("owner", request.getOwner());
        this.projectService.updateProjectOwner(project, request);
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="updateProjectConfig", tags={"SM"}, notes="Add URL: {project}; ")
    @PutMapping(value={"/{project:.+}/config"})
    @ResponseBody
    public EnvelopeResponse<String> updateProjectConfig(@PathVariable(value="project") String project, @RequestBody Map<String, String> request) {
        this.checkProjectName(project);
        if (MapUtils.isEmpty(request)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.EMPTY_PARAMETER, MsgPicker.getMsg().getConfigMapEmpty());
        }
        HashSet keySet = Sets.newHashSet(request.keySet());
        if (!Collections.disjoint(keySet, KylinConfig.getInstanceFromEnv().getNonCustomProjectConfigs())) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.CONFIG_NOT_SUPPORT_EDIT, new Object[]{keySet.iterator().next()});
        }
        this.projectService.updateProjectConfig(project, request);
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="deleteProjectConfig", tags={"SM"})
    @PostMapping(value={"/config/deletion"})
    @ResponseBody
    public EnvelopeResponse<String> deleteProjectConfig(@RequestBody ProjectConfigRequest request) {
        this.checkProjectName(request.getProject());
        this.checkRequiredArg("config_name", request.getConfigName());
        if (KylinConfig.getInstanceFromEnv().getNonCustomProjectConfigs().contains(request.getConfigName())) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.CONFIG_NOT_SUPPORT_DELETE, new Object[]{request.getConfigName()});
        }
        this.projectService.deleteProjectConfig(request.getProject(), request.getConfigName());
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="nonCustomConfig", tags={"SM"})
    @GetMapping(value={"/default_configs"})
    @ResponseBody
    public EnvelopeResponse<Set<String>> getNonCustomProjectConfigs() {
        return new EnvelopeResponse("000", (Object)KylinConfig.getInstanceFromEnv().getNonCustomProjectConfigs(), "");
    }

    @ApiOperation(value="update jdbc config (update)", tags={"QE"}, notes="Add URL: {project}; ")
    @PutMapping(value={"/{project}/jdbc_config"})
    @ResponseBody
    public EnvelopeResponse<Object> updateJdbcConfig(@RequestBody JdbcRequest jdbcRequest, @PathVariable(value="project") String project) {
        this.checkRequiredArg("project", project);
        this.projectService.updateJdbcConfig(project, jdbcRequest);
        return new EnvelopeResponse("000", null, "");
    }

    @ApiOperation(value="updateMultiPartitionConfig", tags={"DW"}, notes="Add URL: {project}; ")
    @PutMapping(value={"/{project:.+}/multi_partition_config"})
    @ResponseBody
    public EnvelopeResponse<String> updateMultiPartitionConfig(@PathVariable(value="project") String project, @RequestBody MultiPartitionConfigRequest request) {
        this.checkRequiredArg("multi_partition_enabled", request.getMultiPartitionEnabled());
        this.projectService.updateMultiPartitionConfig(project, request, (ProjectModelSupporter)this.modelService);
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="updateJdbcSourceInfoConfig", tags={"DW"}, notes="Add URL: {project}; ")
    @PutMapping(value={"/{project:.+}/jdbc_source_info_config"})
    @ResponseBody
    public EnvelopeResponse<String> updateJdbcSourceConfig(@PathVariable(value="project") String project, @RequestBody JdbcSourceInfoRequest request) {
        this.checkRequiredArg("jdbc_source_enabled", request.getJdbcSourceEnable());
        this.projectService.updateJdbcInfo(project, request);
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="updateProjectExclusionInfo", notes="Add URL: {project}; ")
    @PutMapping(value={"/{project:.+}/exclusion_enabled"})
    @ResponseBody
    public EnvelopeResponse<String> updateTableExclusionConfig(@PathVariable(value="project") String project, @RequestBody ProjectExclusionRequest request) {
        this.projectService.updateTableExclusionRule(project, request);
        return new EnvelopeResponse("000", (Object)"", "");
    }
}

