/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller;

import com.google.common.collect.Lists;
import io.swagger.annotations.ApiOperation;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.util.ZipFileUtils;
import org.apache.kylin.metadata.model.schema.SchemaChangeCheckResult;
import org.apache.kylin.rest.controller.NBasicController;
import org.apache.kylin.rest.request.MetadataCleanupRequest;
import org.apache.kylin.rest.request.ModelImportRequest;
import org.apache.kylin.rest.request.ModelPreviewRequest;
import org.apache.kylin.rest.request.StorageCleanupRequest;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.apache.kylin.rest.response.ModelPreviewResponse;
import org.apache.kylin.rest.service.MetaStoreService;
import org.apache.kylin.tool.util.HashFunction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/api/metastore"}, produces={"application/vnd.apache.kylin-v4+json"})
public class NMetaStoreController
extends NBasicController {
    @Autowired
    @Qualifier(value="metaStoreService")
    private MetaStoreService metaStoreService;
    private static final List<ModelImportRequest.ImportType> IMPORT_TYPE = Lists.newArrayList((Object[])new ModelImportRequest.ImportType[]{ModelImportRequest.ImportType.NEW, ModelImportRequest.ImportType.OVERWRITE});

    @ApiOperation(value="previewModels", tags={"MID"})
    @GetMapping(value={"/previews/models"})
    @ResponseBody
    public EnvelopeResponse<List<ModelPreviewResponse>> previewModels(@RequestParam(value="project") String project, @RequestParam(value="model_ids", required=false, defaultValue="") List<String> modeIds) {
        this.checkProjectName(project);
        List simplifiedModels = this.metaStoreService.getPreviewModels(project, modeIds);
        return new EnvelopeResponse("000", (Object)simplifiedModels, "");
    }

    @ApiOperation(value="backupModels", tags={"MID"})
    @PostMapping(value={"/backup/models"}, consumes={"application/x-www-form-urlencoded"})
    @ResponseBody
    public void exportModelMetadata(@RequestParam(value="project") String project, ModelPreviewRequest request, HttpServletResponse response) throws Exception {
        String filename;
        String projectName = this.checkProjectName(project);
        if (CollectionUtils.isEmpty((Collection)request.getIds())) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.EMPTY_MODEL_ID, "At least one model should be selected to export!");
        }
        ByteArrayOutputStream byteArrayOutputStream = this.metaStoreService.getCompressedModelMetadata(projectName, request.getIds(), request.isExportRecommendations(), request.isExportOverProps(), request.isExportMultiplePartitionValues());
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());){
            byte[] md5 = HashFunction.MD5.checksum((InputStream)byteArrayInputStream);
            filename = String.format(Locale.ROOT, "%s_model_metadata_%s_%s.zip", projectName.toLowerCase(Locale.ROOT), new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss", Locale.getDefault(Locale.Category.FORMAT)).format(new Date()), DatatypeConverter.printHexBinary((byte[])md5));
        }
        byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        var8_7 = null;
        try {
            this.setDownloadResponse(byteArrayInputStream, filename, "application/x-www-form-urlencoded", response);
        }
        catch (Throwable throwable) {
            var8_7 = throwable;
            throw throwable;
        }
        finally {
            if (byteArrayInputStream != null) {
                if (var8_7 != null) {
                    try {
                        byteArrayInputStream.close();
                    }
                    catch (Throwable throwable) {
                        var8_7.addSuppressed(throwable);
                    }
                } else {
                    byteArrayInputStream.close();
                }
            }
        }
    }

    @ApiOperation(value="validationModels", tags={"MID"})
    @PostMapping(value={"/validation/models"})
    @ResponseBody
    public EnvelopeResponse<SchemaChangeCheckResult> uploadAndCheckModelMetadata(@RequestParam(value="project") String project, @RequestPart(value="file") MultipartFile uploadFile, @RequestPart(value="request", required=false) ModelImportRequest request) throws Exception {
        this.checkProjectName(project);
        this.checkUploadFile(uploadFile);
        SchemaChangeCheckResult modelMetadataCheckResponse = this.metaStoreService.checkModelMetadata(project, uploadFile, request);
        return new EnvelopeResponse("000", (Object)modelMetadataCheckResponse, "");
    }

    @ApiOperation(value="uploadModels", tags={"MID"})
    @PostMapping(value={"/models"}, consumes={"multipart/form-data"})
    @ResponseBody
    public EnvelopeResponse<String> importModelMetadata(@RequestParam(value="project") String project, @RequestPart(value="file") MultipartFile metadataFile, @RequestPart(value="request") ModelImportRequest request) throws Exception {
        this.checkProjectName(project);
        this.checkUploadFile(metadataFile);
        if (request.getModels().stream().noneMatch(modelImport -> IMPORT_TYPE.contains(modelImport.getImportType()))) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.EMPTY_MODEL_ID, "At least one model should be selected to import!");
        }
        this.metaStoreService.importModelMetadata(project, metadataFile, request);
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="cleanupModels", tags={"SM"})
    @PostMapping(value={"/cleanup"})
    @ResponseBody
    public EnvelopeResponse<String> cleanUpMetaStore(@RequestBody MetadataCleanupRequest request) throws Exception {
        String project = request.getProject();
        if (!"_global".equals(project)) {
            this.checkProjectName(project);
        }
        this.metaStoreService.cleanupMeta(project);
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="cleanupStorage", tags={"SM"})
    @PostMapping(value={"/cleanup_storage"})
    @ResponseBody
    public EnvelopeResponse<String> cleanupStorage(@RequestBody StorageCleanupRequest request) {
        this.metaStoreService.cleanupStorage(request.getProjectsToClean(), request.isCleanupStorage());
        return new EnvelopeResponse("000", (Object)"", "");
    }

    private void checkUploadFile(MultipartFile uploadFile) {
        if (Objects.isNull(uploadFile) || uploadFile.isEmpty()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.FILE_NOT_EXIST, "please select a file");
        }
        if (!ZipFileUtils.validateZipFilename((String)uploadFile.getOriginalFilename())) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.FILE_FORMAT_ERROR, "upload file must end with .zip");
        }
    }
}

