/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller;

import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Set;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.metadata.cube.model.IndexEntity;
import org.apache.kylin.metadata.cube.model.RuleBasedIndex;
import org.apache.kylin.rest.controller.NBasicController;
import org.apache.kylin.rest.request.CreateBaseIndexRequest;
import org.apache.kylin.rest.request.CreateTableIndexRequest;
import org.apache.kylin.rest.request.UpdateRuleBasedCuboidRequest;
import org.apache.kylin.rest.response.AggIndexResponse;
import org.apache.kylin.rest.response.BuildBaseIndexResponse;
import org.apache.kylin.rest.response.BuildIndexResponse;
import org.apache.kylin.rest.response.DataResult;
import org.apache.kylin.rest.response.DiffRuleBasedIndexResponse;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.apache.kylin.rest.response.FusionRuleDataResult;
import org.apache.kylin.rest.response.IndexGraphResponse;
import org.apache.kylin.rest.response.IndexResponse;
import org.apache.kylin.rest.response.IndexStatResponse;
import org.apache.kylin.rest.response.TableIndexResponse;
import org.apache.kylin.rest.service.FusionIndexService;
import org.apache.kylin.rest.service.IndexPlanService;
import org.apache.kylin.rest.service.ModelService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/index_plans"}, produces={"application/vnd.apache.kylin-v4+json", "application/vnd.apache.kylin-v4-public+json"})
public class NIndexPlanController
extends NBasicController {
    private static final String MODEL_ID = "modelId";
    @Autowired
    @Qualifier(value="indexPlanService")
    private IndexPlanService indexPlanService;
    @Autowired
    @Qualifier(value="fusionIndexService")
    private FusionIndexService fusionIndexService;
    @Autowired
    @Qualifier(value="modelService")
    private ModelService modelService;

    @ApiOperation(value="updateRule", tags={"AI"}, notes="Update Body: model_id")
    @PutMapping(value={"/rule"})
    public EnvelopeResponse<BuildIndexResponse> updateRule(@RequestBody UpdateRuleBasedCuboidRequest request) {
        this.checkProjectName(request.getProject());
        this.checkRequiredArg(MODEL_ID, request.getModelId());
        this.modelService.validateCCType(request.getModelId(), request.getProject());
        this.indexPlanService.checkIndexCountWithinLimit(request);
        BuildIndexResponse response = (BuildIndexResponse)this.fusionIndexService.updateRuleBasedCuboid(request.getProject(), request).getSecond();
        return new EnvelopeResponse("000", (Object)response, "");
    }

    @ApiOperation(value="getRule", tags={"AI"})
    @GetMapping(value={"/rule"})
    public EnvelopeResponse<RuleBasedIndex> getRule(@RequestParam(value="project") String project, @RequestParam(value="model") String modelId) {
        this.checkProjectName(project);
        this.checkRequiredArg(MODEL_ID, modelId);
        RuleBasedIndex rule = this.fusionIndexService.getRule(project, modelId);
        return new EnvelopeResponse("000", (Object)rule, "");
    }

    @ApiOperation(value="diffRule", tags={"AI"})
    @PutMapping(value={"/rule_based_index_diff"})
    public EnvelopeResponse<DiffRuleBasedIndexResponse> calculateDiffRuleBasedIndex(@RequestBody UpdateRuleBasedCuboidRequest request) {
        this.checkProjectName(request.getProject());
        this.checkRequiredArg(MODEL_ID, request.getModelId());
        DiffRuleBasedIndexResponse diffRuleBasedIndexResponse = this.fusionIndexService.calculateDiffRuleBasedIndex(request);
        return new EnvelopeResponse("000", (Object)diffRuleBasedIndexResponse, "");
    }

    @ApiOperation(value="calculateAggIndexCombination", tags={"AI"}, notes="Update Body: model_id")
    @PutMapping(value={"/agg_index_count"})
    public EnvelopeResponse<AggIndexResponse> calculateAggIndexCombination(@RequestBody UpdateRuleBasedCuboidRequest request) {
        this.checkProjectName(request.getProject());
        this.checkRequiredArg(MODEL_ID, request.getModelId());
        AggIndexResponse aggIndexCount = this.fusionIndexService.calculateAggIndexCount(request);
        return new EnvelopeResponse("000", (Object)aggIndexCount, "");
    }

    @ApiOperation(value="createTableIndex", tags={"AI"}, notes="Update Body: model_id")
    @PostMapping(value={"/table_index"})
    public EnvelopeResponse<BuildIndexResponse> createTableIndex(@Valid @RequestBody CreateTableIndexRequest request) {
        this.checkProjectName(request.getProject());
        this.checkRequiredArg(MODEL_ID, request.getModelId());
        this.modelService.validateCCType(request.getModelId(), request.getProject());
        BuildIndexResponse response = this.fusionIndexService.createTableIndex(request.getProject(), request);
        return new EnvelopeResponse("000", (Object)response, "");
    }

    @ApiOperation(value="updateTableIndex", tags={"AI"}, notes="Update Body: model_id")
    @PutMapping(value={"/table_index"})
    public EnvelopeResponse<BuildIndexResponse> updateTableIndex(@Valid @RequestBody CreateTableIndexRequest request) {
        this.checkProjectName(request.getProject());
        this.checkRequiredArg(MODEL_ID, request.getModelId());
        this.checkRequiredArg("id", request.getId());
        this.modelService.validateCCType(request.getModelId(), request.getProject());
        BuildIndexResponse response = this.fusionIndexService.updateTableIndex(request.getProject(), request);
        return new EnvelopeResponse("000", (Object)response, "");
    }

    @Deprecated
    @ApiOperation(value="deleteTableIndex", tags={"AI"}, notes="Update URL: {project}, Update Param: project")
    @DeleteMapping(value={"/table_index/{id:.+}"})
    public EnvelopeResponse<String> deleteTableIndex(@PathVariable(value="id") Long id, @RequestParam(value="model") String modelId, @RequestParam(value="project") String project) {
        this.checkProjectName(project);
        this.checkRequiredArg(MODEL_ID, modelId);
        this.checkRequiredArg("id", id);
        this.indexPlanService.removeTableIndex(project, modelId, id.longValue());
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @Deprecated
    @ApiOperation(value="getTableIndex", tags={"AI"}, notes="Update Param: page_offset, page_size; Update response: total_size")
    @GetMapping(value={"/table_index"})
    public EnvelopeResponse<DataResult<List<TableIndexResponse>>> getTableIndex(@RequestParam(value="project") String project, @RequestParam(value="model") String modelId, @RequestParam(value="page_offset", required=false, defaultValue="0") Integer offset, @RequestParam(value="page_size", required=false, defaultValue="10") Integer limit) {
        this.checkProjectName(project);
        this.checkRequiredArg(MODEL_ID, modelId);
        List tableIndexs = this.indexPlanService.getTableIndexs(project, modelId);
        return new EnvelopeResponse("000", (Object)DataResult.get((List)tableIndexs, (int)offset, (int)limit), "");
    }

    @ApiOperation(value="getIndex", tags={"AI"}, notes="Update response: total_size")
    @GetMapping(value={"/index"})
    public EnvelopeResponse<FusionRuleDataResult<List<IndexResponse>>> getIndex(@RequestParam(value="project") String project, @RequestParam(value="model") String modelId, @RequestParam(value="sort_by", required=false, defaultValue="") String order, @RequestParam(value="reverse", required=false, defaultValue="false") Boolean desc, @RequestParam(value="sources", required=false, defaultValue="") List<IndexEntity.Source> sources, @RequestParam(value="key", required=false, defaultValue="") String key, @RequestParam(value="status", required=false, defaultValue="") List<IndexEntity.Status> status, @RequestParam(value="ids", required=false, defaultValue="") List<Long> ids, @RequestParam(value="page_offset", required=false, defaultValue="0") Integer offset, @RequestParam(value="page_size", required=false, defaultValue="10") Integer limit, @RequestParam(value="range", required=false, defaultValue="") List<IndexEntity.Range> range) {
        this.checkProjectName(project);
        this.checkRequiredArg(MODEL_ID, modelId);
        List indexes = this.fusionIndexService.getIndexes(project, modelId, key, status, order, desc, sources, ids, range);
        boolean indexUpdateEnabled = FusionIndexService.checkUpdateIndexEnabled((String)project, (String)modelId);
        return new EnvelopeResponse("000", (Object)FusionRuleDataResult.get((List)indexes, (int)offset, (int)limit, (boolean)indexUpdateEnabled), "");
    }

    @ApiOperation(value="indexGraph", tags={"AI"})
    @GetMapping(value={"/index_graph"})
    public EnvelopeResponse<IndexGraphResponse> getIndexGraph(@RequestParam(value="project") String project, @RequestParam(value="model") String modelId, @RequestParam(value="order", required=false, defaultValue="100") Integer size) {
        this.checkProjectName(project);
        this.checkRequiredArg(MODEL_ID, modelId);
        IndexGraphResponse indexes = this.indexPlanService.getIndexGraph(project, modelId, size.intValue());
        return new EnvelopeResponse("000", (Object)indexes, "");
    }

    @ApiOperation(value="deleteIndex", tags={"AI"}, notes="Update response: need to update total_size")
    @DeleteMapping(value={"/index/{layout_id:.+}"})
    public EnvelopeResponse<String> deleteIndex(@PathVariable(value="layout_id") long layoutId, @RequestParam(value="project") String project, @RequestParam(value="model") String modelId, @RequestParam(value="index_range") IndexEntity.Range indexRange) {
        this.checkProjectName(project);
        this.checkRequiredArg(MODEL_ID, modelId);
        this.fusionIndexService.removeIndex(project, modelId, layoutId, indexRange);
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="batch deleteIndex", tags={"AI"})
    @DeleteMapping(value={"/index"})
    public EnvelopeResponse<String> batchDeleteIndex(@RequestParam(value="layout_ids") Set<Long> layoutIds, @RequestParam(value="project") String project, @RequestParam(value="model") String modelId) {
        this.checkProjectName(project);
        this.checkRequiredArg(MODEL_ID, modelId);
        if (CollectionUtils.isEmpty(layoutIds)) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.LAYOUT_LIST_EMPTY, new Object[0]);
        }
        this.fusionIndexService.removeIndexes(project, modelId, layoutIds);
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="create base index", tags={"AI"})
    @PostMapping(value={"/base_index"})
    @ResponseBody
    public EnvelopeResponse<BuildBaseIndexResponse> createBaseIndex(@RequestBody CreateBaseIndexRequest request) {
        this.checkProjectName(request.getProject());
        this.checkRequiredArg(MODEL_ID, request.getModelId());
        BuildBaseIndexResponse response = this.indexPlanService.createBaseIndex(request.getProject(), request);
        return new EnvelopeResponse("000", (Object)response, "");
    }

    @ApiOperation(value="update base index", tags={"AI"})
    @PutMapping(value={"/base_index"})
    @ResponseBody
    public EnvelopeResponse<BuildBaseIndexResponse> updateBaseIndex(@RequestBody CreateBaseIndexRequest request) {
        this.checkProjectName(request.getProject());
        this.checkRequiredArg(MODEL_ID, request.getModelId());
        BuildBaseIndexResponse response = this.indexPlanService.updateBaseIndex(request.getProject(), request, false);
        return new EnvelopeResponse("000", (Object)response, "");
    }

    @ApiOperation(value="getIndex", tags={"AI"})
    @GetMapping(value={"/index_stat"})
    public EnvelopeResponse<IndexStatResponse> getIndexStat(@RequestParam(value="project") String project, @RequestParam(value="model_id") String modelId) {
        this.checkProjectName(project);
        this.checkRequiredArg(MODEL_ID, modelId);
        IndexStatResponse response = this.indexPlanService.getStat(project, modelId);
        return new EnvelopeResponse("000", (Object)response, "");
    }
}

