/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.kylin.metadata.streaming.KafkaConfig;
import org.apache.kylin.rest.controller.NBasicController;
import org.apache.kylin.rest.request.StreamingRequest;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.apache.kylin.rest.service.KafkaService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/kafka"}, produces={"application/vnd.apache.kylin-v4+json", "application/vnd.apache.kylin-v4-public+json"})
public class KafkaController
extends NBasicController {
    @Autowired
    @Qualifier(value="kafkaService")
    private KafkaService kafkaService;

    @PostMapping(value={"topics"}, produces={"application/vnd.apache.kylin-v4+json", "application/vnd.apache.kylin-v4-public+json"})
    @ResponseBody
    public EnvelopeResponse<Map<String, List<String>>> getTopics(@RequestBody StreamingRequest streamingRequest) {
        this.checkStreamingEnabled();
        KafkaConfig kafkaConfig = streamingRequest.getKafkaConfig();
        return new EnvelopeResponse("000", (Object)this.kafkaService.getTopics(kafkaConfig, streamingRequest.getProject(), streamingRequest.getFuzzyKey()), "");
    }

    @PostMapping(value={"messages"}, produces={"application/vnd.apache.kylin-v4+json", "application/vnd.apache.kylin-v4-public+json"})
    @ResponseBody
    public EnvelopeResponse getMessages(@RequestBody StreamingRequest streamingRequest) {
        this.checkStreamingEnabled();
        String projectName = this.checkProjectName(streamingRequest.getProject());
        List messages = this.kafkaService.getMessages(streamingRequest.getKafkaConfig(), projectName);
        if (CollectionUtils.isEmpty((Collection)messages)) {
            return new EnvelopeResponse("000", (Object)"", "There is no message in this topic");
        }
        Map resp = this.kafkaService.decodeMessage(messages);
        return new EnvelopeResponse("000", (Object)resp, "");
    }

    @PostMapping(value={"convert"}, produces={"application/vnd.apache.kylin-v4+json", "application/vnd.apache.kylin-v4-public+json"})
    @ResponseBody
    public EnvelopeResponse<Map<String, Object>> convertMessage(@RequestBody StreamingRequest streamingRequest) {
        this.checkStreamingEnabled();
        String projectName = this.checkProjectName(streamingRequest.getProject());
        String message = streamingRequest.getMessage();
        KafkaConfig kafkaConfig = streamingRequest.getKafkaConfig();
        Map result = this.kafkaService.parserMessage(projectName, kafkaConfig, message);
        return new EnvelopeResponse("000", (Object)result, "");
    }

    @GetMapping(value={"parsers"}, produces={"application/vnd.apache.kylin-v4+json", "application/vnd.apache.kylin-v4-public+json"})
    @ResponseBody
    public EnvelopeResponse<List<String>> getParser(@RequestParam(value="project") String project) {
        this.checkStreamingEnabled();
        String projectName = this.checkProjectName(project);
        List classList = this.kafkaService.getParsers(projectName);
        return new EnvelopeResponse("000", (Object)classList, "");
    }

    @DeleteMapping(value={"parser"}, produces={"application/vnd.apache.kylin-v4+json", "application/vnd.apache.kylin-v4-public+json"})
    @ResponseBody
    public EnvelopeResponse<String> removeParser(@RequestParam(value="project") String project, @RequestParam(value="class_name") String className) {
        this.checkStreamingEnabled();
        String projectName = this.checkProjectName(project);
        String removedClassName = this.kafkaService.removeParser(projectName, className);
        return new EnvelopeResponse("000", (Object)removedClassName, "");
    }
}

