/*
 * Decompiled with CFR 0.152.
 */
package io.kyligence.kap.rest.controller.open;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.metadata.cube.model.IndexEntity;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.model.exception.LookupTableException;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.rest.constant.ModelAttributeEnum;
import org.apache.kylin.rest.controller.NBasicController;
import org.apache.kylin.rest.controller.NModelController;
import org.apache.kylin.rest.request.ModelParatitionDescRequest;
import org.apache.kylin.rest.request.ModelRequest;
import org.apache.kylin.rest.request.ModelUpdateRequest;
import org.apache.kylin.rest.request.MultiPartitionMappingRequest;
import org.apache.kylin.rest.request.OpenModelRequest;
import org.apache.kylin.rest.request.PartitionColumnRequest;
import org.apache.kylin.rest.request.UpdateMultiPartitionValueRequest;
import org.apache.kylin.rest.response.BuildBaseIndexResponse;
import org.apache.kylin.rest.response.ComputedColumnConflictResponse;
import org.apache.kylin.rest.response.DataResult;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.apache.kylin.rest.response.IndexResponse;
import org.apache.kylin.rest.response.NModelDescResponse;
import org.apache.kylin.rest.response.OpenGetIndexResponse;
import org.apache.kylin.rest.response.SynchronizedCommentsResponse;
import org.apache.kylin.rest.service.FusionIndexService;
import org.apache.kylin.rest.service.FusionModelService;
import org.apache.kylin.rest.service.ModelService;
import org.apache.kylin.rest.service.ModelTdsService;
import org.apache.kylin.rest.util.AclPermissionUtil;
import org.apache.kylin.tool.bisync.SyncContext;
import org.apache.kylin.tool.bisync.model.SyncModel;
import org.apache.kylin.util.DataRangeUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/models"}, produces={"application/vnd.apache.kylin-v4-public+json"})
public class OpenModelController
extends NBasicController {
    private static final String LAST_MODIFY = "last_modified";
    private static final String USAGE = "usage";
    private static final String DATA_SIZE = "data_size";
    private static final String ALIAS = "alias";
    private static final Set<String> INDEX_SORT_BY_SET = ImmutableSet.of((Object)"usage", (Object)"last_modified", (Object)"data_size");
    private static final Set<String> INDEX_SOURCE_SET = Arrays.stream(IndexEntity.Source.values()).map(Enum::name).collect(Collectors.toSet());
    private static final Set<String> INDEX_STATUS_SET = Arrays.stream(IndexEntity.Status.values()).map(Enum::name).collect(Collectors.toSet());
    public static final String MODEL_ID = "modelId";
    public static final String FACT_TABLE = "fact_table";
    @Autowired
    private NModelController modelController;
    @Autowired
    @Qualifier(value="modelTdsService")
    private ModelTdsService tdsService;
    @Autowired
    private FusionIndexService fusionIndexService;
    @Autowired
    private FusionModelService fusionModelService;
    @Autowired
    private ModelService modelService;

    @ApiOperation(value="createModel", tags={"AI"})
    @PostMapping
    @ResponseBody
    public EnvelopeResponse<BuildBaseIndexResponse> createModel(@RequestBody ModelRequest modelRequest) {
        modelRequest.setProject(this.checkProjectName(modelRequest.getProject()));
        this.checkRequiredArg(ALIAS, modelRequest.getRawAlias());
        this.modelService.checkCCEmpty(modelRequest);
        Pair pair = this.modelService.checkCCConflict(modelRequest);
        EnvelopeResponse<BuildBaseIndexResponse> response = this.modelController.createModel((ModelRequest)pair.getFirst());
        ((BuildBaseIndexResponse)response.getData()).setCcConflict((ComputedColumnConflictResponse)pair.getSecond());
        return response;
    }

    @ApiOperation(value="getModels", tags={"AI"})
    @GetMapping(value={""})
    @ResponseBody
    public EnvelopeResponse<DataResult<List<NDataModel>>> getModels(@RequestParam(value="project") String project, @RequestParam(value="model_id", required=false) String modelId, @RequestParam(value="model_name", required=false) String modelAlias, @RequestParam(value="exact", required=false, defaultValue="true") boolean exactMatch, @RequestParam(value="owner", required=false) String owner, @RequestParam(value="status", required=false) List<String> status, @RequestParam(value="table", required=false) String table, @RequestParam(value="page_offset", required=false, defaultValue="0") Integer offset, @RequestParam(value="page_size", required=false, defaultValue="10") Integer limit, @RequestParam(value="sort_by", required=false, defaultValue="last_modify") String sortBy, @RequestParam(value="reverse", required=false, defaultValue="true") Boolean reverse, @RequestParam(value="model_alias_or_owner", required=false) String modelAliasOrOwner, @RequestParam(value="last_modify_from", required=false) Long lastModifyFrom, @RequestParam(value="last_modify_to", required=false) Long lastModifyTo, @RequestParam(value="only_normal_dim", required=false, defaultValue="true") boolean onlyNormalDim) {
        String projectName = this.checkProjectName(project);
        return this.modelController.getModels(modelId, modelAlias, exactMatch, projectName, owner, status, table, offset, limit, sortBy, reverse, modelAliasOrOwner, Collections.singletonList(ModelAttributeEnum.BATCH), lastModifyFrom, lastModifyTo, onlyNormalDim);
    }

    @ApiOperation(value="getIndexes", tags={"AI"})
    @GetMapping(value={"/{model_name:.+}/indexes"})
    @ResponseBody
    public EnvelopeResponse<OpenGetIndexResponse> getIndexes(@RequestParam(value="project") String project, @PathVariable(value="model_name") String modelAlias, @RequestParam(value="status", required=false) List<String> status, @RequestParam(value="page_offset", required=false, defaultValue="0") Integer offset, @RequestParam(value="page_size", required=false, defaultValue="10") Integer limit, @RequestParam(value="sources", required=false) List<String> sources, @RequestParam(value="sort_by", required=false, defaultValue="last_modified") String sortBy, @RequestParam(value="key", required=false, defaultValue="") String key, @RequestParam(value="reverse", required=false, defaultValue="true") Boolean reverse, @RequestParam(value="batch_index_ids", required=false) List<Long> batchIndexIds) {
        String projectName = this.checkProjectName(project);
        NDataModel model = this.getModel(modelAlias, projectName);
        this.checkNonNegativeIntegerArg("page_offset", offset);
        this.checkNonNegativeIntegerArg("page_size", limit);
        List<IndexEntity.Status> statuses = OpenModelController.checkIndexStatus(status);
        String modifiedSortBy = OpenModelController.checkIndexSortBy(sortBy);
        List<IndexEntity.Source> modifiedSources = OpenModelController.checkSources(sources);
        List indexes = this.fusionIndexService.getIndexesWithRelatedTables(projectName, model.getUuid(), key, statuses, modifiedSortBy, reverse, modifiedSources, batchIndexIds);
        List listDataResult = (List)DataResult.get((List)indexes, (int)offset, (int)limit).getValue();
        OpenGetIndexResponse response = new OpenGetIndexResponse();
        response.setModelId(model.getUuid());
        response.setModelAlias(model.getAlias());
        response.setProject(projectName);
        response.setOwner(model.getOwner());
        response.setLimit(limit.intValue());
        response.setOffset(offset.intValue());
        response.setTotalSize(indexes.size());
        ArrayList detailList = Lists.newArrayList();
        listDataResult.forEach(indexResponse -> detailList.add(OpenGetIndexResponse.IndexDetail.newIndexDetail((IndexResponse)indexResponse)));
        response.setIndexDetailList((List)detailList);
        if (CollectionUtils.isNotEmpty(batchIndexIds)) {
            Set batchIndexIdsSet = indexes.stream().filter(index -> index.getIndexRange() == null || index.getIndexRange() == IndexEntity.Range.BATCH).map(IndexResponse::getId).collect(Collectors.toSet());
            List absentBatchIndexIds = batchIndexIds.stream().filter(id -> !batchIndexIdsSet.contains(id)).collect(Collectors.toList());
            response.setAbsentBatchIndexIds(absentBatchIndexIds);
        }
        return new EnvelopeResponse("000", (Object)response, "");
    }

    static List<IndexEntity.Status> checkIndexStatus(List<String> statusList) {
        if (statusList == null || statusList.isEmpty()) {
            return Lists.newArrayList();
        }
        ArrayList statuses = Lists.newArrayList();
        statusList.forEach(status -> {
            if (status != null) {
                String s = status.toUpperCase(Locale.ROOT);
                if (INDEX_STATUS_SET.contains(s)) {
                    statuses.add(IndexEntity.Status.valueOf((String)s));
                } else {
                    throw new KylinException((ErrorCodeProducer)ErrorCodeServer.INDEX_PARAMETER_INVALID, new Object[]{"status", String.join((CharSequence)", ", INDEX_STATUS_SET)});
                }
            }
        });
        return statuses;
    }

    static List<IndexEntity.Source> checkSources(List<String> sources) {
        if (sources == null || sources.isEmpty()) {
            return Lists.newArrayList();
        }
        ArrayList sourceList = Lists.newArrayList();
        sources.forEach(source -> {
            if (source != null) {
                String s = source.toUpperCase(Locale.ROOT);
                if (INDEX_SOURCE_SET.contains(s)) {
                    sourceList.add(IndexEntity.Source.valueOf((String)s));
                } else {
                    throw new KylinException((ErrorCodeProducer)ErrorCodeServer.INDEX_PARAMETER_INVALID, new Object[]{"sources", String.join((CharSequence)", ", INDEX_SOURCE_SET)});
                }
            }
        });
        return sourceList;
    }

    static String checkIndexSortBy(String sortBy) {
        if (sortBy == null) {
            return LAST_MODIFY;
        }
        if ((sortBy = sortBy.toLowerCase(Locale.ROOT).trim()).length() == 0) {
            return LAST_MODIFY;
        }
        if (INDEX_SORT_BY_SET.contains(sortBy)) {
            return sortBy;
        }
        throw new KylinException((ErrorCodeProducer)ErrorCodeServer.INDEX_PARAMETER_INVALID, new Object[]{"sort_by", String.join((CharSequence)", ", INDEX_SORT_BY_SET)});
    }

    @VisibleForTesting
    public NDataModel getModel(String modelAlias, String project) {
        NDataModel model = ((NDataModelManager)this.modelService.getManager(NDataModelManager.class, project)).listAllModels().stream().filter(dataModel -> dataModel.getUuid().equals(modelAlias) || dataModel.getAlias().equalsIgnoreCase(modelAlias)).findFirst().orElse(null);
        if (model == null) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.MODEL_NAME_NOT_EXIST, new Object[]{modelAlias});
        }
        if (model.isBroken()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.MODEL_BROKEN, String.format(Locale.ROOT, MsgPicker.getMsg().getBrokenModelOperationDenied(), modelAlias));
        }
        return model;
    }

    @ApiOperation(value="getModelDesc", tags={"AI"})
    @GetMapping(value={"/{project}/{model}/model_desc"})
    @ResponseBody
    public EnvelopeResponse<NModelDescResponse> getModelDesc(@PathVariable(value="project") String project, @PathVariable(value="model") String modelAlias) {
        String projectName = this.checkProjectName(project);
        NDataModel dataModel = this.getModel(modelAlias, projectName);
        if (dataModel.isStreaming()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.UNSUPPORTED_STREAMING_OPERATION, MsgPicker.getMsg().getStreamingOperationNotSupport());
        }
        NModelDescResponse result = this.modelService.getModelDesc(dataModel.getAlias(), projectName);
        return new EnvelopeResponse("000", (Object)result, "");
    }

    @ApiOperation(value="update partition for single-partition model and forward compatible", tags={"DW"})
    @PutMapping(value={"/{project}/{model}/partition_desc"})
    @ResponseBody
    public EnvelopeResponse<String> updatePartitionDesc(@PathVariable(value="project") String project, @PathVariable(value="model") String modelAlias, @RequestBody ModelParatitionDescRequest modelParatitionDescRequest) {
        String projectName = this.checkProjectName(project);
        String partitionDateFormat = null;
        if (modelParatitionDescRequest.getPartitionDesc() != null) {
            this.checkRequiredArg("partition_date_column", modelParatitionDescRequest.getPartitionDesc().getPartitionDateColumn());
            this.checkRequiredArg("partition_date_format", modelParatitionDescRequest.getPartitionDesc().getPartitionDateFormat());
            partitionDateFormat = modelParatitionDescRequest.getPartitionDesc().getPartitionDateFormat();
        }
        DataRangeUtils.validateDataRange((String)modelParatitionDescRequest.getStart(), (String)modelParatitionDescRequest.getEnd(), partitionDateFormat);
        NDataModel dataModel = this.getModel(modelAlias, projectName);
        this.modelService.updateModelPartitionColumn(projectName, dataModel.getAlias(), modelParatitionDescRequest);
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="deleteModel", tags={"AI"})
    @DeleteMapping(value={"/{model_name:.+}"})
    @ResponseBody
    public EnvelopeResponse<String> deleteModel(@PathVariable(value="model_name") String modelAlias, @RequestParam(value="project") String project) {
        String projectName = this.checkProjectName(project);
        String modelId = this.getModel(modelAlias, projectName).getId();
        return this.modelController.deleteModel(modelId, projectName);
    }

    @ApiOperation(value="updateMultiPartitionMapping", tags={"QE"})
    @PutMapping(value={"/{model_name:.+}/multi_partition/mapping"})
    @ResponseBody
    public EnvelopeResponse<String> updateMultiPartitionMapping(@PathVariable(value="model_name") String modelAlias, @RequestBody MultiPartitionMappingRequest mappingRequest) {
        this.checkValidityOfMultiPartitionMappingRequest(mappingRequest);
        String projectName = this.checkProjectName(mappingRequest.getProject());
        this.checkProjectMLP(projectName);
        mappingRequest.setProject(projectName);
        String modelId = this.getModel(modelAlias, mappingRequest.getProject()).getId();
        return this.modelController.updateMultiPartitionMapping(modelId, mappingRequest);
    }

    @ApiOperation(value="addMultiPartitionValues", notes="Add URL: {model}", tags={"DW"})
    @PostMapping(value={"/{model_name:.+}/segments/multi_partition/sub_partition_values"})
    @ResponseBody
    public EnvelopeResponse<String> addMultiPartitionValues(@PathVariable(value="model_name") String modelAlias, @RequestBody UpdateMultiPartitionValueRequest request) {
        String projectName = this.checkProjectName(request.getProject());
        this.checkProjectMLP(projectName);
        String modelId = this.getModel(modelAlias, projectName).getId();
        return this.modelController.addMultiPartitionValues(modelId, request);
    }

    @ApiOperation(value="update partition for multi partition and single partition", tags={"DW"})
    @PutMapping(value={"/{model_name:.+}/partition"})
    @ResponseBody
    public EnvelopeResponse<String> updatePartitionSemantic(@PathVariable(value="model_name") String modelAlias, @RequestBody PartitionColumnRequest param) throws Exception {
        String projectName = this.checkProjectName(param.getProject());
        if (param.getMultiPartitionDesc() != null) {
            this.checkProjectMLP(projectName);
        }
        param.setProject(projectName);
        String modelId = this.getModel(modelAlias, param.getProject()).getId();
        return this.modelController.updatePartitionSemantic(modelId, param);
    }

    @ApiOperation(value="export model", tags={"QE"}, notes="Add URL: {model}")
    @GetMapping(value={"/{model_name:.+}/export"})
    @ResponseBody
    public void exportModel(@PathVariable(value="model_name") String modelAlias, @RequestParam(value="project") String project, @RequestParam(value="export_as") SyncContext.BI exportAs, @RequestParam(value="element", required=false, defaultValue="AGG_INDEX_COL") SyncContext.ModelElement element, @RequestParam(value="server_host", required=false) String serverHost, @RequestParam(value="server_port", required=false) Integer serverPort, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String projectName = this.checkProjectName(project);
        String modelId = this.getModel(modelAlias, projectName).getId();
        String host = this.getHost(serverHost, request.getServerName());
        int port = this.getPort(serverPort, request.getServerPort());
        SyncContext syncContext = this.tdsService.prepareSyncContext(projectName, modelId, exportAs, element, host, port);
        SyncModel syncModel = this.tdsService.exportModel(syncContext);
        this.tdsService.preCheckNameConflict(syncModel);
        this.tdsService.dumpSyncModel(syncContext, syncModel, response);
    }

    @ApiOperation(value="bi export", tags={"QE"})
    @GetMapping(value={"/bi_export"})
    @ResponseBody
    public void biExport(@RequestParam(value="model_name") String modelAlias, @RequestParam(value="project") String project, @RequestParam(value="export_as") SyncContext.BI exportAs, @RequestParam(value="element", required=false, defaultValue="AGG_INDEX_COL") SyncContext.ModelElement element, @RequestParam(value="server_host", required=false) String serverHost, @RequestParam(value="server_port", required=false) Integer serverPort, @RequestParam(value="dimensions", required=false) List<String> dimensions, @RequestParam(value="measures", required=false) List<String> measures, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String projectName = this.checkProjectName(project);
        String modelId = this.getModel(modelAlias, projectName).getId();
        String host = this.getHost(serverHost, request.getServerName());
        int port = this.getPort(serverPort, request.getServerPort());
        if (dimensions == null) {
            dimensions = ImmutableList.of();
        }
        if (measures == null) {
            measures = ImmutableList.of();
        }
        SyncContext syncContext = this.tdsService.prepareSyncContext(projectName, modelId, exportAs, element, host, port);
        SyncModel syncModel = AclPermissionUtil.isAdmin() ? this.tdsService.exportTDSDimensionsAndMeasuresByAdmin(syncContext, (List)dimensions, (List)measures) : this.tdsService.exportTDSDimensionsAndMeasuresByNormalUser(syncContext, (List)dimensions, (List)measures);
        this.tdsService.preCheckNameConflict(syncModel);
        this.tdsService.dumpSyncModel(syncContext, syncModel, response);
    }

    @ApiOperation(value="updateModelName", tags={"AI"})
    @PutMapping(value={"/{model_name}/name"})
    @ResponseBody
    public EnvelopeResponse<String> updateModelName(@PathVariable(value="model_name") String modelAlias, @RequestBody ModelUpdateRequest modelRenameRequest) {
        this.checkRequiredArg("new_model_name", modelRenameRequest.getNewModelName());
        String projectName = this.checkProjectName(modelRenameRequest.getProject());
        String modelId = this.getModel(modelAlias, projectName).getId();
        this.checkRequiredArg(MODEL_ID, modelId);
        return this.modelController.updateModelName(modelId, modelRenameRequest);
    }

    @ApiOperation(value="updateModelStatus", tags={"AI"})
    @PutMapping(value={"/{model_name}/status"})
    @ResponseBody
    public EnvelopeResponse<String> updateModelStatus(@PathVariable(value="model_name") String modelAlias, @RequestBody ModelUpdateRequest modelRenameRequest) {
        String projectName = this.checkProjectName(modelRenameRequest.getProject());
        String modelId = this.getModel(modelAlias, projectName).getId();
        return this.modelController.updateModelStatus(modelId, modelRenameRequest);
    }

    private void checkValidityOfMultiPartitionMappingRequest(MultiPartitionMappingRequest mappingRequest) {
        this.checkListRequiredArg("alias_columns", mappingRequest.getAliasCols());
        this.checkListRequiredArg("multi_partition_columns", mappingRequest.getPartitionCols());
        this.checkListRequiredArg("value_mapping", mappingRequest.getValueMapping());
        for (MultiPartitionMappingRequest.MappingRequest value_mapping : mappingRequest.getValueMapping()) {
            this.checkListRequiredArg("origin", (Collection)value_mapping.getOrigin());
            this.checkListRequiredArg("target", (Collection)value_mapping.getTarget());
        }
    }

    private void checkProjectMLP(String project) {
        ProjectInstance projectInstance = NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).getProject(project);
        if (!projectInstance.getConfig().isMultiPartitionEnabled()) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.PROJECT_MULTI_PARTITION_DISABLE, new Object[]{projectInstance.getName()});
        }
    }

    static void checkMLP(String fieldName, List<String[]> subPartitionValues) {
        if (subPartitionValues.isEmpty()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARAMETER, String.format(Locale.ROOT, "'%s' cannot be empty.", fieldName));
        }
    }

    @ApiOperation(value="updateModelSemantic", tags={"AI"})
    @PutMapping(value={"/modification"})
    @ResponseBody
    public EnvelopeResponse<BuildBaseIndexResponse> updateSemantic(@RequestBody OpenModelRequest request) {
        String projectName = this.checkProjectName(request.getProject());
        request.setProject(projectName);
        NDataModel model = this.getModel(request.getModelName(), request.getProject());
        request.setUuid(model.getId());
        request.setOwner(model.getOwner());
        request.setManagementType(model.getManagementType());
        request.setCanvas(model.getCanvas());
        String partitionColumnFormat = this.modelService.getPartitionColumnFormatById(request.getProject(), request.getId());
        DataRangeUtils.validateDataRange((String)request.getStart(), (String)request.getEnd(), (String)partitionColumnFormat);
        this.modelService.validatePartitionDesc(request.getPartitionDesc());
        this.checkRequiredArg(MODEL_ID, request.getUuid());
        try {
            BuildBaseIndexResponse response = BuildBaseIndexResponse.EMPTY;
            if (request.getBrokenReason() == NDataModel.BrokenReason.SCHEMA) {
                this.modelService.repairBrokenModel(request.getProject(), (ModelRequest)request);
            } else {
                response = this.fusionModelService.updateDataModelSemantic(request.getProject(), (ModelRequest)request);
            }
            return new EnvelopeResponse("000", (Object)response, "");
        }
        catch (LookupTableException e) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.FAILED_UPDATE_MODEL, (Throwable)e);
        }
        catch (Exception e) {
            Throwable root = ExceptionUtils.getRootCause((Throwable)e) == null ? e : ExceptionUtils.getRootCause((Throwable)e);
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.FAILED_UPDATE_MODEL, root);
        }
    }

    @ApiOperation(value="comments synchronization", tags={"AI"})
    @PostMapping(value={"/comments_synchronization"})
    @ResponseBody
    public EnvelopeResponse<SynchronizedCommentsResponse> commentsSynchronization(@RequestBody ModelRequest modelRequest) {
        modelRequest.setProject(this.checkProjectName(modelRequest.getProject()));
        this.checkRequiredArg(ALIAS, modelRequest.getRawAlias());
        this.checkRequiredArg(FACT_TABLE, modelRequest.getRootFactTableName());
        SynchronizedCommentsResponse synchronizedCommentsResponse = new SynchronizedCommentsResponse();
        synchronizedCommentsResponse.syncComment(modelRequest);
        this.modelService.checkBeforeModelSave(synchronizedCommentsResponse.getModelRequest());
        return new EnvelopeResponse("000", (Object)synchronizedCommentsResponse, "");
    }
}

