/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.tools;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mrunit.mapreduce.ReduceDriver;
import org.apache.hadoop.mrunit.types.Pair;
import org.apache.kylin.common.hll.HyperLogLogPlusCounter;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.job.hadoop.cardinality.ColumnCardinalityReducer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ColumnCardinalityReducerTest {
    ReduceDriver<IntWritable, BytesWritable, IntWritable, LongWritable> reduceDriver;
    String localTempDir = System.getProperty("java.io.tmpdir") + File.separator;

    @Before
    public void setUp() {
        ColumnCardinalityReducer reducer = new ColumnCardinalityReducer();
        this.reduceDriver = ReduceDriver.newReduceDriver((Reducer)reducer);
    }

    private byte[] getBytes(String str) throws IOException {
        HyperLogLogPlusCounter hllc = new HyperLogLogPlusCounter();
        StringTokenizer tokenizer = new StringTokenizer(str, ",");
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            String temp = i + "_" + tokenizer.nextToken();
            ++i;
            hllc.add(Bytes.toBytes((String)temp));
        }
        ByteBuffer buf = ByteBuffer.allocate(0x100000);
        buf.clear();
        hllc.writeRegisters(buf);
        buf.flip();
        return buf.array();
    }

    @Test
    public void testReducer() throws IOException {
        IntWritable key1 = new IntWritable(1);
        ArrayList<BytesWritable> values1 = new ArrayList<BytesWritable>();
        values1.add(new BytesWritable(this.getBytes("abc,tests,test,test,as,sts,test,tss,sets")));
        IntWritable key2 = new IntWritable(2);
        ArrayList<BytesWritable> values2 = new ArrayList<BytesWritable>();
        values2.add(new BytesWritable(this.getBytes("abc,tests,test,test,as,sts,test,tss,sets x")));
        IntWritable key3 = new IntWritable(3);
        ArrayList<BytesWritable> values3 = new ArrayList<BytesWritable>();
        values3.add(new BytesWritable(this.getBytes("abc,tests,test,test,as,sts,test,tss,sets xx")));
        IntWritable key4 = new IntWritable(4);
        ArrayList<BytesWritable> values4 = new ArrayList<BytesWritable>();
        values4.add(new BytesWritable(this.getBytes("abc,tests,test,test,as,sts,test,tss,sets xxx")));
        IntWritable key5 = new IntWritable(5);
        ArrayList<BytesWritable> values5 = new ArrayList<BytesWritable>();
        values5.add(new BytesWritable(this.getBytes("abc,tests,test,test,as,sts,test,tss,sets xxxx")));
        this.reduceDriver.withInput((Object)key1, values1);
        this.reduceDriver.withInput((Object)key2, values2);
        this.reduceDriver.withInput((Object)key3, values3);
        this.reduceDriver.withInput((Object)key4, values4);
        this.reduceDriver.withInput((Object)key5, values5);
        List result = this.reduceDriver.run();
        Assert.assertEquals((long)5L, (long)result.size());
        int outputKey1 = ((IntWritable)((Pair)result.get(0)).getFirst()).get();
        LongWritable value1 = (LongWritable)((Pair)result.get(0)).getSecond();
        Assert.assertTrue((outputKey1 == 1 ? 1 : 0) != 0);
        Assert.assertTrue((10L == value1.get() || 9L == value1.get() ? 1 : 0) != 0);
    }
}

