/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.manager;

import java.util.List;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.LocalFileMetadataTestCase;
import org.apache.kylin.job.SucceedTestExecutable;
import org.apache.kylin.job.exception.IllegalStateTranferException;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ChainedExecutable;
import org.apache.kylin.job.execution.DefaultChainedExecutable;
import org.apache.kylin.job.execution.Executable;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.job.manager.ExecutableManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ExecutableManagerTest
extends LocalFileMetadataTestCase {
    private ExecutableManager service;

    @Before
    public void setup() throws Exception {
        this.createTestMetadata();
        this.service = ExecutableManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
        for (String jobId : this.service.getAllJobIds()) {
            System.out.println("deleting " + jobId);
            this.service.deleteJob(jobId);
        }
    }

    @After
    public void after() throws Exception {
        this.cleanupTestMetadata();
    }

    @Test
    public void test() throws Exception {
        Assert.assertNotNull((Object)this.service);
        SucceedTestExecutable executable = new SucceedTestExecutable();
        executable.setParam("test1", "test1");
        executable.setParam("test2", "test2");
        executable.setParam("test3", "test3");
        this.service.addJob((AbstractExecutable)executable);
        List result = this.service.getAllExecutables();
        Assert.assertEquals((long)1L, (long)result.size());
        AbstractExecutable another = this.service.getJob(executable.getId());
        ExecutableManagerTest.assertJobEqual((Executable)executable, (Executable)another);
        this.service.updateJobOutput(executable.getId(), ExecutableState.RUNNING, null, "test output");
        ExecutableManagerTest.assertJobEqual((Executable)executable, (Executable)this.service.getJob(executable.getId()));
    }

    @Test
    public void testDefaultChainedExecutable() throws Exception {
        DefaultChainedExecutable job = new DefaultChainedExecutable();
        job.addTask((AbstractExecutable)new SucceedTestExecutable());
        job.addTask((AbstractExecutable)new SucceedTestExecutable());
        this.service.addJob((AbstractExecutable)job);
        Assert.assertEquals((long)2L, (long)job.getTasks().size());
        AbstractExecutable anotherJob = this.service.getJob(job.getId());
        Assert.assertEquals(DefaultChainedExecutable.class, anotherJob.getClass());
        Assert.assertEquals((long)2L, (long)((DefaultChainedExecutable)anotherJob).getTasks().size());
        ExecutableManagerTest.assertJobEqual((Executable)job, (Executable)anotherJob);
    }

    @Test
    public void testValidStateTransfer() throws Exception {
        SucceedTestExecutable job = new SucceedTestExecutable();
        String id = job.getId();
        this.service.addJob((AbstractExecutable)job);
        this.service.updateJobOutput(id, ExecutableState.RUNNING, null, null);
        this.service.updateJobOutput(id, ExecutableState.ERROR, null, null);
        this.service.updateJobOutput(id, ExecutableState.READY, null, null);
        this.service.updateJobOutput(id, ExecutableState.RUNNING, null, null);
        this.service.updateJobOutput(id, ExecutableState.READY, null, null);
        this.service.updateJobOutput(id, ExecutableState.RUNNING, null, null);
        this.service.updateJobOutput(id, ExecutableState.SUCCEED, null, null);
    }

    @Test(expected=IllegalStateTranferException.class)
    public void testInvalidStateTransfer() {
        SucceedTestExecutable job = new SucceedTestExecutable();
        this.service.addJob((AbstractExecutable)job);
        this.service.updateJobOutput(job.getId(), ExecutableState.RUNNING, null, null);
        this.service.updateJobOutput(job.getId(), ExecutableState.STOPPED, null, null);
    }

    private static void assertJobEqual(Executable one, Executable another) {
        Assert.assertEquals(one.getClass(), another.getClass());
        Assert.assertEquals((Object)one.getId(), (Object)another.getId());
        Assert.assertEquals((Object)one.getStatus(), (Object)another.getStatus());
        Assert.assertEquals((Object)one.isRunnable(), (Object)another.isRunnable());
        Assert.assertEquals((Object)one.getOutput(), (Object)another.getOutput());
        Assert.assertTrue((one.getParams() == null && another.getParams() == null || one.getParams() != null && another.getParams() != null ? 1 : 0) != 0);
        if (one.getParams() != null) {
            Assert.assertEquals((long)one.getParams().size(), (long)another.getParams().size());
            for (String key : one.getParams().keySet()) {
                Assert.assertEquals(one.getParams().get(key), another.getParams().get(key));
            }
        }
        if (one instanceof ChainedExecutable) {
            Assert.assertTrue((boolean)(another instanceof ChainedExecutable));
            List onesSubs = ((ChainedExecutable)one).getTasks();
            List anotherSubs = ((ChainedExecutable)another).getTasks();
            Assert.assertTrue((onesSubs == null && anotherSubs == null || onesSubs != null && anotherSubs != null ? 1 : 0) != 0);
            if (onesSubs != null) {
                Assert.assertEquals((long)onesSubs.size(), (long)anotherSubs.size());
                for (int i = 0; i < onesSubs.size(); ++i) {
                    ExecutableManagerTest.assertJobEqual((Executable)onesSubs.get(i), (Executable)anotherSubs.get(i));
                }
            }
        }
    }
}

