/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.impl.threadpool;

import org.apache.kylin.job.ErrorTestExecutable;
import org.apache.kylin.job.FailedTestExecutable;
import org.apache.kylin.job.SelfStopExecutable;
import org.apache.kylin.job.SucceedTestExecutable;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.DefaultChainedExecutable;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.job.impl.threadpool.BaseSchedulerTest;
import org.junit.Assert;
import org.junit.Test;

public class DefaultSchedulerTest
extends BaseSchedulerTest {
    @Test
    public void testSingleTaskJob() throws Exception {
        DefaultChainedExecutable job = new DefaultChainedExecutable();
        SucceedTestExecutable task1 = new SucceedTestExecutable();
        job.addTask((AbstractExecutable)task1);
        this.jobService.addJob((AbstractExecutable)job);
        this.waitForJobFinish(job.getId());
        Assert.assertEquals((Object)ExecutableState.SUCCEED, (Object)this.jobService.getOutput(job.getId()).getState());
        Assert.assertEquals((Object)ExecutableState.SUCCEED, (Object)this.jobService.getOutput(task1.getId()).getState());
    }

    @Test
    public void testSucceed() throws Exception {
        DefaultChainedExecutable job = new DefaultChainedExecutable();
        SucceedTestExecutable task1 = new SucceedTestExecutable();
        SucceedTestExecutable task2 = new SucceedTestExecutable();
        job.addTask((AbstractExecutable)task1);
        job.addTask((AbstractExecutable)task2);
        this.jobService.addJob((AbstractExecutable)job);
        this.waitForJobFinish(job.getId());
        Assert.assertEquals((Object)ExecutableState.SUCCEED, (Object)this.jobService.getOutput(job.getId()).getState());
        Assert.assertEquals((Object)ExecutableState.SUCCEED, (Object)this.jobService.getOutput(task1.getId()).getState());
        Assert.assertEquals((Object)ExecutableState.SUCCEED, (Object)this.jobService.getOutput(task2.getId()).getState());
    }

    @Test
    public void testSucceedAndFailed() throws Exception {
        DefaultChainedExecutable job = new DefaultChainedExecutable();
        SucceedTestExecutable task1 = new SucceedTestExecutable();
        FailedTestExecutable task2 = new FailedTestExecutable();
        job.addTask((AbstractExecutable)task1);
        job.addTask((AbstractExecutable)task2);
        this.jobService.addJob((AbstractExecutable)job);
        this.waitForJobFinish(job.getId());
        Assert.assertEquals((Object)ExecutableState.ERROR, (Object)this.jobService.getOutput(job.getId()).getState());
        Assert.assertEquals((Object)ExecutableState.SUCCEED, (Object)this.jobService.getOutput(task1.getId()).getState());
        Assert.assertEquals((Object)ExecutableState.ERROR, (Object)this.jobService.getOutput(task2.getId()).getState());
    }

    @Test
    public void testSucceedAndError() throws Exception {
        DefaultChainedExecutable job = new DefaultChainedExecutable();
        ErrorTestExecutable task1 = new ErrorTestExecutable();
        SucceedTestExecutable task2 = new SucceedTestExecutable();
        job.addTask((AbstractExecutable)task1);
        job.addTask((AbstractExecutable)task2);
        this.jobService.addJob((AbstractExecutable)job);
        this.waitForJobFinish(job.getId());
        Assert.assertEquals((Object)ExecutableState.ERROR, (Object)this.jobService.getOutput(job.getId()).getState());
        Assert.assertEquals((Object)ExecutableState.ERROR, (Object)this.jobService.getOutput(task1.getId()).getState());
        Assert.assertEquals((Object)ExecutableState.READY, (Object)this.jobService.getOutput(task2.getId()).getState());
    }

    @Test
    public void testDiscard() throws Exception {
        DefaultChainedExecutable job = new DefaultChainedExecutable();
        SelfStopExecutable task1 = new SelfStopExecutable();
        job.addTask((AbstractExecutable)task1);
        this.jobService.addJob((AbstractExecutable)job);
        this.waitForJobStatus(job.getId(), ExecutableState.RUNNING, 500L);
        this.jobService.discardJob(job.getId());
        this.waitForJobFinish(job.getId());
        Assert.assertEquals((Object)ExecutableState.DISCARDED, (Object)this.jobService.getOutput(job.getId()).getState());
        Assert.assertEquals((Object)ExecutableState.DISCARDED, (Object)this.jobService.getOutput(task1.getId()).getState());
        Thread.sleep(5000L);
        System.out.println(job);
    }
}

