/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.impl.threadpool;

import java.lang.reflect.Field;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.HBaseMetadataTestCase;
import org.apache.kylin.job.constant.ExecutableConstants;
import org.apache.kylin.job.engine.JobEngineConfig;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.job.impl.threadpool.DefaultScheduler;
import org.apache.kylin.job.manager.ExecutableManager;
import org.junit.After;
import org.junit.Before;

public abstract class BaseSchedulerTest
extends HBaseMetadataTestCase {
    private DefaultScheduler scheduler;
    protected ExecutableManager jobService;

    static void setFinalStatic(Field field, Object newValue) throws Exception {
        field.setAccessible(true);
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        modifiersField.setAccessible(true);
        modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        field.set(null, newValue);
    }

    protected void waitForJobFinish(String jobId) {
        AbstractExecutable job;
        ExecutableState status;
        while ((status = (job = this.jobService.getJob(jobId)).getStatus()) != ExecutableState.SUCCEED && status != ExecutableState.ERROR && status != ExecutableState.STOPPED && status != ExecutableState.DISCARDED) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    protected void waitForJobStatus(String jobId, ExecutableState state, long interval) {
        AbstractExecutable job;
        while ((job = this.jobService.getJob(jobId)).getStatus() != state) {
            try {
                Thread.sleep(interval);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    @Before
    public void setup() throws Exception {
        this.createTestMetadata();
        BaseSchedulerTest.setFinalStatic(ExecutableConstants.class.getField("DEFAULT_SCHEDULER_INTERVAL_SECONDS"), 10);
        this.jobService = ExecutableManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
        this.scheduler = DefaultScheduler.getInstance();
        this.scheduler.init(new JobEngineConfig(KylinConfig.getInstanceFromEnv()));
        if (!this.scheduler.hasStarted()) {
            throw new RuntimeException("scheduler has not been started");
        }
    }

    @After
    public void after() throws Exception {
        this.cleanupTestMetadata();
    }
}

