/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.hadoop.hdfs;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.LocalFileMetadataTestCase;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class HdfsOpsTest
extends LocalFileMetadataTestCase {
    FileSystem fileSystem;

    @Before
    public void setup() throws Exception {
        this.createTestMetadata();
        Configuration hconf = new Configuration();
        this.fileSystem = FileSystem.get((Configuration)hconf);
    }

    @Test
    public void TestPath() throws IOException {
        String hdfsWorkingDirectory = KylinConfig.getInstanceFromEnv().getHdfsWorkingDirectory();
        Path coprocessorDir = new Path(hdfsWorkingDirectory, "test");
        this.fileSystem.mkdirs(coprocessorDir);
        Path newFile = new Path(coprocessorDir, "test_file");
        newFile = newFile.makeQualified(this.fileSystem.getUri(), null);
        FSDataOutputStream stream = this.fileSystem.create(newFile);
        stream.write(new byte[]{0, 1, 2});
        stream.close();
    }

    @After
    public void after() throws Exception {
        this.cleanupTestMetadata();
    }
}

