/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.hadoop.hbase;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.util.LocalFileMetadataTestCase;
import org.apache.kylin.job.hadoop.hbase.CreateHTableJob;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CreateHTableTest
extends LocalFileMetadataTestCase {
    private Configuration conf;

    @Before
    public void setup() throws Exception {
        this.conf = new Configuration();
        this.conf.set("fs.default.name", "file:///");
        this.conf.set("mapred.job.tracker", "local");
        this.createTestMetadata();
    }

    @After
    public void after() throws Exception {
        this.cleanupTestMetadata();
    }

    @Test
    public void testGetSplits() throws IllegalArgumentException, Exception {
        CreateHTableJob c = new CreateHTableJob();
        String input = "src/test/resources/partition_list/part-r-00000";
        byte[][] splits = c.getSplits(this.conf, new Path(input));
        Assert.assertEquals((long)497L, (long)splits.length);
        Assert.assertArrayEquals((byte[])new byte[]{0, 0, 0, 0, 0, 0, 15, -1, 11, 51, -45, 2}, (byte[])splits[0]);
        Assert.assertArrayEquals((byte[])new byte[]{0, 0, 0, 0, 0, 3, -1, -1, -54, -61, 109, -44, 1}, (byte[])splits[496]);
    }
}

