/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.hadoop.cube;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mrunit.mapreduce.MapReduceDriver;
import org.apache.hadoop.mrunit.types.Pair;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.common.util.LocalFileMetadataTestCase;
import org.apache.kylin.job.hadoop.cube.CuboidReducer;
import org.apache.kylin.job.hadoop.cube.NDCuboidMapper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NDCuboidMapperTest
extends LocalFileMetadataTestCase {
    MapReduceDriver<Text, Text, Text, Text, Text, Text> mapReduceDriver;
    String localTempDir = System.getProperty("java.io.tmpdir") + File.separator;

    @Before
    public void setUp() throws Exception {
        this.createTestMetadata();
        FileUtils.deleteDirectory((File)new File("../job/meta"));
        FileUtils.copyDirectory((File)new File(NDCuboidMapperTest.getTestConfig().getMetadataUrl()), (File)new File("../job/meta"));
        NDCuboidMapper mapper = new NDCuboidMapper();
        CuboidReducer reducer = new CuboidReducer();
        this.mapReduceDriver = MapReduceDriver.newMapReduceDriver((Mapper)mapper, (Reducer)reducer);
    }

    @After
    public void after() throws Exception {
        this.cleanupTestMetadata();
        FileUtils.deleteDirectory((File)new File("../job/meta"));
    }

    @Test
    public void testMapReduceWithSlr() throws IOException {
        String cubeName = "test_kylin_cube_with_slr_1_new_segment";
        String segmentName = "20130331080000_20131212080000";
        this.mapReduceDriver.getConfiguration().set("cube.name", cubeName);
        this.mapReduceDriver.getConfiguration().set("cube.segment.name", segmentName);
        byte[] key = new byte[]{0, 0, 0, 0, 0, 0, 1, -1, 49, 48, 48, 48, 48, 48, 48, 48, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 11, 54, -105, 55, 13, 71, 114, 65, 66, 73, 78, 9, 9, 9, 9, 9, 9, 9, 9, 0, 10, 0};
        byte[] value = new byte[]{14, 7, 23, -16, 56, 92, 114, -80, 118, 14, 7, 23, -16, 56, 92, 114, -80, 118, 14, 7, 23, -16, 56, 92, 114, -80, 118, 1};
        Pair input1 = new Pair((Object)new Text(key), (Object)new Text(value));
        this.mapReduceDriver.addInput(input1);
        List result = this.mapReduceDriver.run();
        Assert.assertEquals((long)4L, (long)result.size());
        byte[] resultKey = new byte[]{0, 0, 0, 0, 0, 0, 1, 127, 49, 48, 48, 48, 48, 48, 48, 48, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 55, 13, 71, 114, 65, 66, 73, 78, 9, 9, 9, 9, 9, 9, 9, 9, 0, 10, 0};
        byte[] resultValue = new byte[]{14, 7, 23, -16, 56, 92, 114, -80, 118, 14, 7, 23, -16, 56, 92, 114, -80, 118, 14, 7, 23, -16, 56, 92, 114, -80, 118, 1};
        Pair output1 = new Pair((Object)new Text(resultKey), (Object)new Text(resultValue));
        Assert.assertTrue((boolean)result.contains(output1));
        long[] keySet = new long[result.size()];
        System.out.println(Bytes.toLong((byte[])new byte[]{0, 0, 0, 0, 0, 0, 1, -1}));
        for (int i = 0; i < result.size(); ++i) {
            byte[] bytes = new byte[((Text)((Pair)result.get(i)).getFirst()).getLength()];
            System.arraycopy(((Text)((Pair)result.get(i)).getFirst()).getBytes(), 0, bytes, 0, ((Text)((Pair)result.get(i)).getFirst()).getLength());
            System.out.println(Bytes.toLong((byte[])bytes));
            keySet[i] = Bytes.toLong((byte[])bytes);
        }
        Assert.assertArrayEquals((long[])new long[]{383L, 447L, 503L, 504L}, (long[])keySet);
    }
}

