/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.hadoop.cube;

import java.io.File;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.kylin.common.util.LocalFileMetadataTestCase;
import org.apache.kylin.job.hadoop.cube.NDCuboidJob;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NDCuboidJobTest
extends LocalFileMetadataTestCase {
    private Configuration conf;

    @Before
    public void setup() throws Exception {
        this.conf = new Configuration();
        this.conf.set("fs.default.name", "file:///");
        this.conf.set("mapred.job.tracker", "local");
        this.conf.set("mapreduce.task.io.sort.mb", "10");
        this.createTestMetadata();
    }

    @After
    public void after() throws Exception {
        this.cleanupTestMetadata();
    }

    @Test
    public void testJob6D() throws Exception {
        String input = "src/test/resources/data/base_cuboid/";
        String output = "target/test-output/6d_cuboid";
        String cubeName = "test_kylin_cube_with_slr_1_new_segment";
        String segmentName = "20130331080000_20131212080000";
        String jobname = "6d_cuboid";
        String level = "1";
        FileUtil.fullyDelete((File)new File(output));
        String[] args = new String[]{"-input", input, "-cubename", cubeName, "-segmentname", segmentName, "-output", output, "-jobname", jobname, "-level", level};
        Assert.assertEquals((String)"Job failed", (long)0L, (long)ToolRunner.run((Configuration)this.conf, (Tool)new NDCuboidJob(), (String[])args));
    }

    @Test
    public void testJob5D() throws Exception {
        String input = "src/test/resources/data/6d_cuboid/";
        String output = "target/test-output/5d_cuboid";
        String cubeName = "test_kylin_cube_with_slr_1_new_segment";
        String segmentName = "20130331080000_20131212080000";
        String jobname = "5d_cuboid";
        String level = "2";
        FileUtil.fullyDelete((File)new File("target/test-output/5d_cuboid"));
        String[] args = new String[]{"-input", "src/test/resources/data/6d_cuboid/", "-cubename", "test_kylin_cube_with_slr_1_new_segment", "-segmentname", segmentName, "-output", "target/test-output/5d_cuboid", "-jobname", jobname, "-level", level};
        Assert.assertEquals((String)"Job failed", (long)0L, (long)ToolRunner.run((Configuration)this.conf, (Tool)new NDCuboidJob(), (String[])args));
    }
}

