/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.hadoop.cube;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mrunit.mapreduce.MapDriver;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.LocalFileMetadataTestCase;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.dict.Dictionary;
import org.apache.kylin.dict.DictionaryGenerator;
import org.apache.kylin.dict.DictionaryInfo;
import org.apache.kylin.dict.DictionaryManager;
import org.apache.kylin.dict.TrieDictionary;
import org.apache.kylin.dict.lookup.TableSignature;
import org.apache.kylin.job.hadoop.cube.MergeCuboidMapper;
import org.apache.kylin.metadata.MetadataManager;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.project.ProjectManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeCuboidMapperTest
extends LocalFileMetadataTestCase {
    private static final Logger logger = LoggerFactory.getLogger(MergeCuboidMapperTest.class);
    MapDriver<Text, Text, Text, Text> mapDriver;
    CubeManager cubeManager;
    CubeInstance cube;
    DictionaryManager dictionaryManager;
    TblColRef lfn;
    TblColRef lsi;
    TblColRef ssc;

    private DictionaryInfo makeSharedDict() throws IOException {
        TableSignature signature = new TableSignature();
        signature.setSize(100L);
        signature.setLastModifiedTime(System.currentTimeMillis());
        signature.setPath("fake_common_dict");
        DictionaryInfo newDictInfo = new DictionaryInfo("", "", 0, "string", signature, "");
        ArrayList<byte[]> values = new ArrayList<byte[]>();
        values.add(new byte[]{101, 101, 101});
        values.add(new byte[]{102, 102, 102});
        Dictionary dict = DictionaryGenerator.buildDictionaryFromValueList((DictionaryInfo)newDictInfo, values);
        this.dictionaryManager.trySaveNewDict(dict, newDictInfo);
        ((TrieDictionary)dict).dump(System.out);
        return newDictInfo;
    }

    @Before
    public void setUp() throws Exception {
        this.createTestMetadata();
        logger.info("The metadataUrl is : " + MergeCuboidMapperTest.getTestConfig());
        MetadataManager.clearCache();
        CubeManager.clearCache();
        ProjectManager.clearCache();
        DictionaryManager.clearCache();
        FileUtils.deleteDirectory((File)new File("../job/meta"));
        MergeCuboidMapper mapper = new MergeCuboidMapper();
        this.mapDriver = MapDriver.newMapDriver((Mapper)mapper);
        this.cubeManager = CubeManager.getInstance((KylinConfig)MergeCuboidMapperTest.getTestConfig());
        this.cube = this.cubeManager.getCube("test_kylin_cube_without_slr_left_join_ready_2_segments");
        this.dictionaryManager = DictionaryManager.getInstance((KylinConfig)MergeCuboidMapperTest.getTestConfig());
        this.lfn = this.cube.getDescriptor().findColumnRef("DEFAULT.TEST_KYLIN_FACT", "LSTG_FORMAT_NAME");
        this.lsi = this.cube.getDescriptor().findColumnRef("DEFAULT.TEST_KYLIN_FACT", "CAL_DT");
        this.ssc = this.cube.getDescriptor().findColumnRef("DEFAULT.TEST_CATEGORY_GROUPINGS", "META_CATEG_NAME");
        DictionaryInfo sharedDict = this.makeSharedDict();
        boolean isFirstSegment = true;
        for (CubeSegment segment : this.cube.getSegments()) {
            TableSignature signature = new TableSignature();
            signature.setSize(100L);
            signature.setLastModifiedTime(System.currentTimeMillis());
            signature.setPath("fake_dict_for" + this.lfn.getName() + segment.getName());
            DictionaryInfo newDictInfo = new DictionaryInfo(this.lfn.getTable(), this.lfn.getColumn().getName(), this.lfn.getColumn().getZeroBasedIndex(), "string", signature, "");
            ArrayList<byte[]> values = new ArrayList<byte[]>();
            values.add(new byte[]{97, 97, 97});
            if (isFirstSegment) {
                values.add(new byte[]{99, 99, 99});
            } else {
                values.add(new byte[]{98, 98, 98});
            }
            Dictionary dict = DictionaryGenerator.buildDictionaryFromValueList((DictionaryInfo)newDictInfo, values);
            this.dictionaryManager.trySaveNewDict(dict, newDictInfo);
            ((TrieDictionary)dict).dump(System.out);
            segment.putDictResPath(this.lfn, newDictInfo.getResourcePath());
            segment.putDictResPath(this.lsi, sharedDict.getResourcePath());
            segment.putDictResPath(this.ssc, sharedDict.getResourcePath());
            this.cubeManager.updateCube(this.cube);
            isFirstSegment = false;
        }
    }

    @After
    public void after() throws Exception {
        this.cleanupTestMetadata();
        FileUtils.deleteDirectory((File)new File("../job/meta"));
    }

    @Test
    public void test() throws IOException, ParseException {
        String cubeName = "test_kylin_cube_without_slr_left_join_ready_2_segments";
        CubeSegment newSeg = this.cubeManager.mergeSegments(this.cube, 0L, 1386835200000L);
        String segmentName = newSeg.getName();
        Dictionary dictionary = this.cubeManager.getDictionary(newSeg, this.lfn);
        Assert.assertTrue((dictionary == null ? 1 : 0) != 0);
    }
}

