/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.hadoop.cube;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.kylin.common.util.LocalFileMetadataTestCase;
import org.apache.kylin.job.hadoop.cube.MergeCuboidJob;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MergeCuboidJobTest
extends LocalFileMetadataTestCase {
    private Configuration conf;

    @Before
    public void setup() throws Exception {
        this.conf = new Configuration();
        this.conf.set("fs.default.name", "file:///");
        this.conf.set("mapred.job.tracker", "local");
        this.conf.set("mapreduce.task.io.sort.mb", "10");
        this.createTestMetadata();
    }

    @After
    public void after() throws Exception {
        this.cleanupTestMetadata();
    }

    @Test
    public void test() throws Exception {
        String output = "target/test-output/merged_cuboid";
        String cubeName = "test_kylin_cube_with_slr_ready";
        String jobname = "merge_cuboid";
        File baseFolder = File.createTempFile("kylin-f24668f6-dcff-4cb6-a89b-77f1119df8fa-", "base");
        baseFolder.delete();
        baseFolder.mkdir();
        FileUtils.copyDirectory((File)new File("src/test/resources/data/base_cuboid"), (File)baseFolder);
        baseFolder.deleteOnExit();
        File sixDFolder = File.createTempFile("kylin-f24668f6-dcff-4cb6-a89b-77f1119df8fa-", "6d");
        sixDFolder.delete();
        sixDFolder.mkdir();
        FileUtils.copyDirectory((File)new File("src/test/resources/data/base_cuboid"), (File)sixDFolder);
        sixDFolder.deleteOnExit();
        FileUtil.fullyDelete((File)new File(output));
        String[] args = new String[]{"-input", baseFolder.getAbsolutePath() + "," + sixDFolder.getAbsolutePath(), "-cubename", cubeName, "-segmentname", "20130331080000_20131212080000", "-output", output, "-jobname", jobname};
        Assert.assertEquals((String)"Job failed", (long)0L, (long)ToolRunner.run((Configuration)this.conf, (Tool)new MergeCuboidJob(), (String[])args));
    }
}

