/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.hadoop.cube;

import java.io.File;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mrunit.mapreduce.ReduceDriver;
import org.apache.hadoop.mrunit.types.Pair;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.LocalFileMetadataTestCase;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.job.hadoop.cube.CuboidReducer;
import org.apache.kylin.metadata.measure.MeasureCodec;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CubeReducerTest
extends LocalFileMetadataTestCase {
    ReduceDriver<Text, Text, Text, Text> reduceDriver;
    String localTempDir = System.getProperty("java.io.tmpdir") + File.separator;
    ByteBuffer buf = ByteBuffer.allocate(0x100000);

    @Before
    public void setUp() throws Exception {
        this.createTestMetadata();
        FileUtils.deleteDirectory((File)new File("../job/meta"));
        FileUtils.copyDirectory((File)new File(CubeReducerTest.getTestConfig().getMetadataUrl()), (File)new File("../job/meta"));
        CuboidReducer reducer = new CuboidReducer();
        this.reduceDriver = ReduceDriver.newReduceDriver((Reducer)reducer);
    }

    @After
    public void after() throws Exception {
        this.cleanupTestMetadata();
        FileUtils.deleteDirectory((File)new File("../job/meta"));
    }

    @Test
    public void testReducer() throws Exception {
        this.reduceDriver.getConfiguration().set("cube.name", "test_kylin_cube_with_slr_ready");
        CubeDesc cubeDesc = CubeManager.getInstance((KylinConfig)CubeReducerTest.getTestConfig()).getCube("test_kylin_cube_with_slr_ready").getDescriptor();
        MeasureCodec codec = new MeasureCodec((Collection)cubeDesc.getMeasures());
        Text key1 = new Text("7\u00072010\u0007us\u0007tech");
        ArrayList<Text> values1 = new ArrayList<Text>();
        values1.add(this.newValueText(codec, "15.09", "15.09", "15.09", 1));
        values1.add(this.newValueText(codec, "20.34", "20.34", "20.34", 1));
        values1.add(this.newValueText(codec, "10", "10", "10", 1));
        Text key2 = new Text("1\u0007tech");
        ArrayList<Text> values2 = new ArrayList<Text>();
        values2.add(this.newValueText(codec, "15.09", "15.09", "15.09", 1));
        values2.add(this.newValueText(codec, "20.34", "20.34", "20.34", 1));
        Text key3 = new Text("0");
        ArrayList<Text> values3 = new ArrayList<Text>();
        values3.add(this.newValueText(codec, "146.52", "146.52", "146.52", 4));
        this.reduceDriver.withInput((Object)key1, values1);
        this.reduceDriver.withInput((Object)key2, values2);
        this.reduceDriver.withInput((Object)key3, values3);
        List result = this.reduceDriver.run();
        Pair p1 = new Pair((Object)new Text("7\u00072010\u0007us\u0007tech"), (Object)this.newValueText(codec, "45.43", "10", "20.34", 3));
        Pair p2 = new Pair((Object)new Text("1\u0007tech"), (Object)this.newValueText(codec, "35.43", "15.09", "20.34", 2));
        Pair p3 = new Pair((Object)new Text("0"), (Object)this.newValueText(codec, "146.52", "146.52", "146.52", 4));
        Assert.assertEquals((long)3L, (long)result.size());
        Assert.assertTrue((boolean)result.contains(p1));
        Assert.assertTrue((boolean)result.contains(p2));
        Assert.assertTrue((boolean)result.contains(p3));
    }

    private Text newValueText(MeasureCodec codec, String sum, String min, String max, int count) {
        Object[] values = new Object[]{new BigDecimal(sum), new BigDecimal(min), new BigDecimal(max), new LongWritable((long)count)};
        this.buf.clear();
        codec.encode(values, this.buf);
        Text t = new Text();
        t.set(this.buf.array(), 0, this.buf.position());
        return t;
    }
}

