/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.hadoop.cube;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.util.ReflectionUtils;

public class CopySeq {
    public static void main(String[] args) throws IOException {
        CopySeq.copyTo64MB(args[0], args[1]);
    }

    public static void copyTo64MB(String src, String dst) throws IOException {
        Configuration hconf = new Configuration();
        Path srcPath = new Path(src);
        Path dstPath = new Path(dst);
        FileSystem fs = FileSystem.get((Configuration)hconf);
        long srcSize = fs.getFileStatus(srcPath).getLen();
        int copyTimes = (int)(0x4000000L / srcSize);
        System.out.println("Copy " + copyTimes + " times");
        SequenceFile.Reader reader = new SequenceFile.Reader(hconf, new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)srcPath)});
        Writable key = (Writable)ReflectionUtils.newInstance((Class)reader.getKeyClass(), (Configuration)hconf);
        Text value = new Text();
        SequenceFile.Writer writer = SequenceFile.createWriter((Configuration)hconf, (SequenceFile.Writer.Option[])new SequenceFile.Writer.Option[]{SequenceFile.Writer.file((Path)dstPath), SequenceFile.Writer.keyClass(key.getClass()), SequenceFile.Writer.valueClass(Text.class), SequenceFile.Writer.compression((SequenceFile.CompressionType)SequenceFile.CompressionType.BLOCK, (CompressionCodec)CopySeq.getLZOCodec(hconf))});
        int count = 0;
        while (reader.next(key, (Writable)value)) {
            for (int i = 0; i < copyTimes; ++i) {
                writer.append(key, (Writable)value);
                ++count;
            }
        }
        System.out.println("Len: " + writer.getLength());
        System.out.println("Rows: " + count);
        reader.close();
        writer.close();
    }

    static CompressionCodec getLZOCodec(Configuration hconf) {
        CompressionCodecFactory factory = new CompressionCodecFactory(hconf);
        return factory.getCodecByClassName("org.apache.hadoop.io.compress.LzoCodec");
    }
}

