/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.hadoop.cube;

import java.io.File;
import java.math.BigDecimal;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mrunit.mapreduce.MapDriver;
import org.apache.hadoop.mrunit.types.Pair;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.common.util.LocalFileMetadataTestCase;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.kv.RowKeyDecoder;
import org.apache.kylin.job.hadoop.cube.BaseCuboidMapper;
import org.apache.kylin.metadata.measure.MeasureCodec;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BaseCuboidMapperTest
extends LocalFileMetadataTestCase {
    MapDriver<Text, Text, Text, Text> mapDriver;
    String localTempDir = System.getProperty("java.io.tmpdir") + File.separator;

    @Before
    public void setUp() throws Exception {
        this.createTestMetadata();
        FileUtils.deleteDirectory((File)new File("../job/meta"));
        FileUtils.copyDirectory((File)new File(BaseCuboidMapperTest.getTestConfig().getMetadataUrl()), (File)new File("../job/meta"));
        BaseCuboidMapper mapper = new BaseCuboidMapper();
        this.mapDriver = MapDriver.newMapDriver((Mapper)mapper);
    }

    @After
    public void after() throws Exception {
        this.cleanupTestMetadata();
        FileUtils.deleteDirectory((File)new File("../job/meta"));
    }

    @Test
    public void testMapperWithHeader() throws Exception {
        String cubeName = "test_kylin_cube_with_slr_1_new_segment";
        String segmentName = "20130331080000_20131212080000";
        this.mapDriver.getConfiguration().set("cube.name", cubeName);
        this.mapDriver.getConfiguration().set("cube.segment.name", segmentName);
        this.mapDriver.withInput((Object)new Text("key"), (Object)new Text("2012-12-15\u007f11848\u007f0\u007fHealth & Beauty\u007fFragrances\u007fWomen\u007fAuction\u007f15\u007f123456789\u007f132.33"));
        List result = this.mapDriver.run();
        CubeManager cubeMgr = CubeManager.getInstance((KylinConfig)BaseCuboidMapperTest.getTestConfig());
        CubeInstance cube = cubeMgr.getCube(cubeName);
        Assert.assertEquals((long)1L, (long)result.size());
        Text rowkey = (Text)((Pair)result.get(0)).getFirst();
        byte[] key = rowkey.getBytes();
        byte[] header = Bytes.head((byte[])key, (int)26);
        byte[] sellerId = Bytes.tail((byte[])header, (int)18);
        byte[] cuboidId = Bytes.head((byte[])header, (int)8);
        byte[] restKey = Bytes.tail((byte[])key, (int)(rowkey.getLength() - 26));
        RowKeyDecoder decoder = new RowKeyDecoder(cube.getFirstSegment());
        decoder.decode(key);
        Assert.assertEquals((Object)"[123456789, 2012-12-15, 11848, Health & Beauty, Fragrances, Women, Auction, 0, 15]", (Object)decoder.getValues().toString());
        Assert.assertTrue((boolean)Bytes.toString((byte[])sellerId).startsWith("123456789"));
        Assert.assertEquals((long)511L, (long)Bytes.toLong((byte[])cuboidId));
        Assert.assertEquals((long)22L, (long)restKey.length);
        this.verifyMeasures(cube.getDescriptor().getMeasures(), (Text)((Pair)result.get(0)).getSecond(), "132.33", "132.33", "132.33");
    }

    private void verifyMeasures(List<MeasureDesc> measures, Text valueBytes, String m1, String m2, String m3) {
        MeasureCodec codec = new MeasureCodec(measures);
        Object[] values = new Object[measures.size()];
        codec.decode(valueBytes, values);
        Assert.assertTrue((boolean)new BigDecimal(m1).equals(values[0]));
        Assert.assertTrue((boolean)new BigDecimal(m2).equals(values[1]));
        Assert.assertTrue((boolean)new BigDecimal(m3).equals(values[2]));
    }

    @Test
    public void testMapperWithNull() throws Exception {
        String cubeName = "test_kylin_cube_with_slr_1_new_segment";
        String segmentName = "20130331080000_20131212080000";
        this.mapDriver.getConfiguration().set("cube.name", cubeName);
        this.mapDriver.getConfiguration().set("cube.segment.name", segmentName);
        this.mapDriver.withInput((Object)new Text("key"), (Object)new Text("2012-12-15\u007f11848\u007f0\u007fHealth & Beauty\u007fFragrances\u007f\\N\u007fAuction\u007f15\u007f123456789\u007f\\N"));
        List result = this.mapDriver.run();
        CubeManager cubeMgr = CubeManager.getInstance((KylinConfig)BaseCuboidMapperTest.getTestConfig());
        CubeInstance cube = cubeMgr.getCube(cubeName);
        Assert.assertEquals((long)1L, (long)result.size());
        Text rowkey = (Text)((Pair)result.get(0)).getFirst();
        byte[] key = rowkey.getBytes();
        byte[] header = Bytes.head((byte[])key, (int)26);
        byte[] sellerId = Bytes.tail((byte[])header, (int)18);
        byte[] cuboidId = Bytes.head((byte[])header, (int)8);
        byte[] restKey = Bytes.tail((byte[])key, (int)(rowkey.getLength() - 26));
        RowKeyDecoder decoder = new RowKeyDecoder(cube.getFirstSegment());
        decoder.decode(key);
        Assert.assertEquals((Object)"[123456789, 2012-12-15, 11848, Health & Beauty, Fragrances, null, Auction, 0, 15]", (Object)decoder.getValues().toString());
        Assert.assertTrue((boolean)Bytes.toString((byte[])sellerId).startsWith("123456789"));
        Assert.assertEquals((long)511L, (long)Bytes.toLong((byte[])cuboidId));
        Assert.assertEquals((long)22L, (long)restKey.length);
        this.verifyMeasures(cube.getDescriptor().getMeasures(), (Text)((Pair)result.get(0)).getSecond(), "0", "0", "0");
    }
}

