/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.hadoop.cube;

import java.io.File;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.kylin.common.util.LocalFileMetadataTestCase;
import org.apache.kylin.job.hadoop.cube.BaseCuboidJob;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BaseCuboidJobTest
extends LocalFileMetadataTestCase {
    private Configuration conf;

    @Before
    public void setup() throws Exception {
        this.conf = new Configuration();
        this.conf.set("fs.default.name", "file:///");
        this.conf.set("mapred.job.tracker", "local");
        this.conf.set("mapreduce.task.io.sort.mb", "10");
        this.createTestMetadata();
    }

    @After
    public void after() throws Exception {
        this.cleanupTestMetadata();
    }

    @Test
    public void testJob() throws Exception {
        String input = "src/test/resources/data/flat_table/";
        String output = "target/test-output/base_cuboid/";
        String cubeName = "test_kylin_cube_with_slr_1_new_segment";
        String segmentName = "20130331080000_20131212080000";
        String jobname = "base_cuboid_job";
        String level = "0";
        FileUtil.fullyDelete((File)new File(output));
        String[] args = new String[]{"-input", input, "-cubename", cubeName, "-segmentname", segmentName, "-output", output, "-jobname", jobname, "-level", level};
        Assert.assertEquals((String)"Job failed", (long)0L, (long)ToolRunner.run((Configuration)this.conf, (Tool)new BaseCuboidJob(), (String[])args));
    }
}

