/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.dataGen;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.job.dataGen.ColumnConfig;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class GenConfig {
    @JsonProperty(value="columnConfigs")
    private ArrayList<ColumnConfig> columnConfigs;
    private HashMap<String, ColumnConfig> cache = new HashMap();

    public ArrayList<ColumnConfig> getColumnConfigs() {
        return this.columnConfigs;
    }

    public void setColumnConfigs(ArrayList<ColumnConfig> columnConfigs) {
        this.columnConfigs = columnConfigs;
    }

    public ColumnConfig getColumnConfigByName(String columnName) {
        if (this.cache.containsKey(columnName = columnName.toLowerCase())) {
            return this.cache.get(columnName);
        }
        for (ColumnConfig cConfig : this.columnConfigs) {
            if (!cConfig.getColumnName().toLowerCase().equals(columnName)) continue;
            this.cache.put(columnName, cConfig);
            return cConfig;
        }
        this.cache.put(columnName, null);
        return null;
    }

    public static GenConfig loadConfig(InputStream stream) {
        try {
            GenConfig config = (GenConfig)JsonUtil.readValue((InputStream)stream, GenConfig.class);
            return config;
        }
        catch (JsonMappingException e) {
            e.printStackTrace();
        }
        catch (JsonParseException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}

