/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.dataGen;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.util.Array;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.cube.model.DimensionDesc;
import org.apache.kylin.job.dataGen.ColumnConfig;
import org.apache.kylin.job.dataGen.GenConfig;
import org.apache.kylin.metadata.MetadataManager;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.DataType;
import org.apache.kylin.metadata.model.JoinDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.TblColRef;

public class FactTableGenerator {
    CubeInstance cube = null;
    CubeDesc desc = null;
    ResourceStore store = null;
    String factTableName = null;
    GenConfig genConf = null;
    Random r = null;
    String cubeName;
    long randomSeed;
    int rowCount;
    int unlinkableRowCount;
    int unlinkableRowCountMax;
    double conflictRatio;
    double linkableRatio;
    TreeMap<String, LinkedList<String>> lookupTableKeys = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    TreeMap<String, ArrayList<String>> feasibleValues = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    TreeMap<String, HashSet<Array<String>>> lookupTableCompositeKeyValues = new TreeMap(String.CASE_INSENSITIVE_ORDER);

    private void init(String cubeName, int rowCount, double conflictRaio, double linkableRatio, long randomSeed) {
        this.rowCount = rowCount;
        this.conflictRatio = conflictRaio;
        this.cubeName = cubeName;
        this.randomSeed = randomSeed;
        this.linkableRatio = linkableRatio;
        this.unlinkableRowCountMax = (int)((double)this.rowCount * (1.0 - linkableRatio));
        this.unlinkableRowCount = 0;
        this.r = new Random(randomSeed);
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        this.cube = CubeManager.getInstance((KylinConfig)config).getCube(cubeName);
        this.desc = this.cube.getDescriptor();
        this.factTableName = this.desc.getFactTable();
        this.store = ResourceStore.getStore((KylinConfig)config);
    }

    private void loadConfig() {
        try {
            InputStream configStream = null;
            configStream = this.store.getResource("/data/data_gen_config.json");
            this.genConf = GenConfig.loadConfig(configStream);
            if (configStream != null) {
                configStream.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadLookupTableValues(String lookupTableName, LinkedList<String> columnNames, int distinctRowCount) throws Exception {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        if (columnNames.size() > 1 && !this.lookupTableCompositeKeyValues.containsKey(lookupTableName)) {
            this.lookupTableCompositeKeyValues.put(lookupTableName, new HashSet());
        }
        InputStream tableStream = null;
        BufferedReader tableReader = null;
        try {
            String curRow;
            TreeMap<String, Integer> zeroBasedInice = new TreeMap<String, Integer>(String.CASE_INSENSITIVE_ORDER);
            for (String columnName : columnNames) {
                ColumnDesc cDesc = MetadataManager.getInstance((KylinConfig)config).getTableDesc(lookupTableName).findColumnByName(columnName);
                zeroBasedInice.put(columnName, cDesc.getZeroBasedIndex());
            }
            String path = "/data/" + lookupTableName + ".csv";
            tableStream = this.store.getResource(path);
            tableReader = new BufferedReader(new InputStreamReader(tableStream));
            tableReader.mark(0);
            int rowCount = 0;
            int curRowNum = 0;
            while (tableReader.readLine() != null) {
                ++rowCount;
            }
            HashSet<Integer> rows = new HashSet<Integer>();
            int n = distinctRowCount = distinctRowCount < rowCount ? distinctRowCount : rowCount;
            while (rows.size() < distinctRowCount) {
                rows.add(this.r.nextInt(rowCount));
            }
            tableStream.close();
            tableReader.close();
            tableStream = null;
            tableReader = null;
            tableStream = this.store.getResource(path);
            tableReader = new BufferedReader(new InputStreamReader(tableStream));
            while ((curRow = tableReader.readLine()) != null) {
                if (rows.contains(curRowNum)) {
                    String[] tokens = curRow.split(",");
                    Object[] comboKeys = null;
                    int index = 0;
                    if (columnNames.size() > 1) {
                        comboKeys = new String[columnNames.size()];
                    }
                    for (String columnName : columnNames) {
                        int zeroBasedIndex = (Integer)zeroBasedInice.get(columnName);
                        if (!this.feasibleValues.containsKey(lookupTableName + "/" + columnName)) {
                            this.feasibleValues.put(lookupTableName + "/" + columnName, new ArrayList());
                        }
                        this.feasibleValues.get(lookupTableName + "/" + columnName).add(tokens[zeroBasedIndex]);
                        if (columnNames.size() <= 1) continue;
                        comboKeys[index] = tokens[zeroBasedIndex];
                        ++index;
                    }
                    if (columnNames.size() > 1) {
                        Array wrap = new Array(comboKeys);
                        if (this.lookupTableCompositeKeyValues.get(lookupTableName).contains(wrap)) {
                            throw new Exception("The composite key already exist in the lookup table");
                        }
                        this.lookupTableCompositeKeyValues.get(lookupTableName).add((Array<String>)wrap);
                    }
                }
                ++curRowNum;
            }
            if (tableStream != null) {
                tableStream.close();
            }
            if (tableReader != null) {
                tableReader.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void prepare() throws Exception {
        this.loadConfig();
        TreeSet<String> factTableColumns = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (DimensionDesc dim : this.desc.getDimensions()) {
            for (TblColRef col : dim.getColumnRefs()) {
                if (!col.getTable().equals(this.factTableName)) continue;
                factTableColumns.add(col.getName());
            }
            JoinDesc join = dim.getJoin();
            if (join == null) continue;
            String lookupTable = dim.getTable();
            for (String column : join.getPrimaryKey()) {
                if (!this.lookupTableKeys.containsKey(lookupTable)) {
                    this.lookupTableKeys.put(lookupTable, new LinkedList());
                }
                if (this.lookupTableKeys.get(lookupTable).contains(column)) continue;
                this.lookupTableKeys.get(lookupTable).add(column);
            }
        }
        int distinctRowCount = (int)((double)this.rowCount / this.conflictRatio);
        distinctRowCount = distinctRowCount == 0 ? 1 : distinctRowCount;
        for (String lookupTable : this.lookupTableKeys.keySet()) {
            this.loadLookupTableValues(lookupTable, this.lookupTableKeys.get(lookupTable), distinctRowCount);
        }
    }

    private List<DimensionDesc> getSortedDimentsionDescs() {
        List dimensions = this.desc.getDimensions();
        Collections.sort(dimensions, new Comparator<DimensionDesc>(){

            @Override
            public int compare(DimensionDesc o1, DimensionDesc o2) {
                JoinDesc j1 = o2.getJoin();
                JoinDesc j2 = o1.getJoin();
                return Integer.valueOf(j1 != null ? j1.getPrimaryKey().length : 0).compareTo(j2 != null ? j2.getPrimaryKey().length : 0);
            }
        });
        return dimensions;
    }

    private String cookData() throws Exception {
        JoinDesc jDesc;
        TreeMap<String, String> factTableCol2LookupCol = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        TreeSet<String> usedCols = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        TreeMap<String, String> lookupCol2factTableCol = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        List<DimensionDesc> dimensions = this.getSortedDimentsionDescs();
        for (DimensionDesc dim : dimensions) {
            jDesc = dim.getJoin();
            if (jDesc == null) continue;
            String[] fks = jDesc.getForeignKey();
            String[] pks = jDesc.getPrimaryKey();
            int num = fks.length;
            for (int i = 0; i < num; ++i) {
                String value = dim.getTable() + "/" + pks[i];
                lookupCol2factTableCol.put(value, fks[i]);
                if (factTableCol2LookupCol.containsKey(fks[i]) && !factTableCol2LookupCol.get(fks[i]).equals(value)) {
                    System.out.println("Warning: Disambiguation on the mapping of column " + fks[i] + ", " + factTableCol2LookupCol.get(fks[i]) + "(chosen) or " + value);
                    continue;
                }
                factTableCol2LookupCol.put(fks[i], value);
            }
        }
        for (DimensionDesc dim : dimensions) {
            jDesc = dim.getJoin();
            if (jDesc != null) continue;
            for (String aColumn : dim.getColumn()) {
                if (factTableCol2LookupCol.containsKey(aColumn)) continue;
                usedCols.add(aColumn);
            }
        }
        for (MeasureDesc mDesc : this.desc.getMeasures()) {
            List pcols = mDesc.getFunction().getParameter().getColRefs();
            if (pcols == null) continue;
            for (TblColRef col : pcols) {
                if (factTableCol2LookupCol.containsKey(col.getName())) continue;
                usedCols.add(col.getName());
            }
        }
        return this.createTable(this.rowCount, factTableCol2LookupCol, lookupCol2factTableCol, usedCols);
    }

    private String normToTwoDigits(int v) {
        if (v < 10) {
            return "0" + v;
        }
        return Integer.toString(v);
    }

    private String randomPick(ArrayList<String> candidates) {
        int index = this.r.nextInt(candidates.size());
        return candidates.get(index);
    }

    private String createRandomCell(ColumnDesc cDesc, ArrayList<String> range) throws Exception {
        DataType type = cDesc.getType();
        if (type.isStringFamily()) {
            throw new Exception("Can't handle range values for string");
        }
        if (type.isIntegerFamily()) {
            int low = Integer.parseInt(range.get(0));
            int high = Integer.parseInt(range.get(1));
            return Integer.toString(this.r.nextInt(high - low) + low);
        }
        if (type.isDouble()) {
            double low = Double.parseDouble(range.get(0));
            double high = Double.parseDouble(range.get(1));
            return String.format("%.4f", this.r.nextDouble() * (high - low) + low);
        }
        if (type.isFloat()) {
            float low = Float.parseFloat(range.get(0));
            float high = Float.parseFloat(range.get(1));
            return String.format("%.4f", Float.valueOf(this.r.nextFloat() * (high - low) + low));
        }
        if (type.isDecimal()) {
            double low = Double.parseDouble(range.get(0));
            double high = Double.parseDouble(range.get(1));
            return String.format("%.4f", this.r.nextDouble() * (high - low) + low);
        }
        if (type.isDateTimeFamily()) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            Date start = format.parse(range.get(0));
            Date end = format.parse(range.get(1));
            long diff = end.getTime() - start.getTime();
            Date temp = new Date(start.getTime() + (long)((double)diff * this.r.nextDouble()));
            Calendar cal = Calendar.getInstance();
            cal.setTime(temp);
            cal.set(7, cal.getFirstDayOfWeek());
            return cal.get(1) + "-" + this.normToTwoDigits(cal.get(2) + 1) + "-" + this.normToTwoDigits(cal.get(5));
        }
        System.out.println("The data type " + type + "is not recognized");
        System.exit(1);
        return null;
    }

    private String createRandomCell(ColumnDesc cDesc) {
        String type = cDesc.getTypeName();
        String s = type.toLowerCase();
        if (s.equals("string") || s.equals("char") || s.equals("varchar")) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < 2; ++i) {
                sb.append((char)(97 + this.r.nextInt(10)));
            }
            return sb.toString();
        }
        if (s.equals("bigint") || s.equals("int") || s.equals("tinyint") || s.equals("smallint")) {
            return Integer.toString(this.r.nextInt(128));
        }
        if (s.equals("double")) {
            return String.format("%.4f", this.r.nextDouble() * 100.0);
        }
        if (s.equals("float")) {
            return String.format("%.4f", Float.valueOf(this.r.nextFloat() * 100.0f));
        }
        if (s.equals("decimal")) {
            return String.format("%.4f", this.r.nextDouble() * 100.0);
        }
        if (s.equals("date")) {
            long date20131231 = 61349312153265L;
            long date20010101 = 60939158400000L;
            long diff = date20131231 - date20010101;
            Date temp = new Date(date20010101 + (long)((double)diff * this.r.nextDouble()));
            Calendar cal = Calendar.getInstance();
            cal.setTime(temp);
            cal.set(7, cal.getFirstDayOfWeek());
            return cal.get(1) + "-" + this.normToTwoDigits(cal.get(2) + 1) + "-" + this.normToTwoDigits(cal.get(5));
        }
        System.out.println("The data type " + type + "is not recognized");
        System.exit(1);
        return null;
    }

    private String createDefaultsCell(String type) {
        String s = type.toLowerCase();
        if (s.equals("string") || s.equals("char") || s.equals("varchar")) {
            return "abcde";
        }
        if (s.equals("bigint") || s.equals("int") || s.equals("tinyint") || s.equals("smallint")) {
            return "0";
        }
        if (s.equals("double")) {
            return "0";
        }
        if (s.equals("float")) {
            return "0";
        }
        if (s.equals("decimal")) {
            return "0";
        }
        if (s.equals("date")) {
            return "1970-01-01";
        }
        System.out.println("The data type " + type + "is not recognized");
        System.exit(1);
        return null;
    }

    private void printColumnMappings(TreeMap<String, String> factTableCol2LookupCol, TreeSet<String> usedCols, TreeSet<String> defaultColumns) {
        System.out.println("=======================================================================");
        System.out.format("%-30s %s", "FACT_TABLE_COLUMN", "MAPPING");
        System.out.println();
        System.out.println();
        for (Map.Entry<String, String> entry : factTableCol2LookupCol.entrySet()) {
            System.out.format("%-30s %s", entry.getKey(), entry.getValue());
            System.out.println();
        }
        for (String key : usedCols) {
            System.out.format("%-30s %s", key, "Random Values");
            System.out.println();
        }
        for (String key : defaultColumns) {
            System.out.format("%-30s %s", key, "Default Values");
            System.out.println();
        }
        System.out.println("=======================================================================");
        System.out.println("Parameters:");
        System.out.println();
        System.out.println("CubeName:        " + this.cubeName);
        System.out.println("RowCount:        " + this.rowCount);
        System.out.println("ConflictRatio:   " + this.conflictRatio);
        System.out.println("LinkableRatio:   " + this.linkableRatio);
        System.out.println("Seed:            " + this.randomSeed);
        System.out.println();
        System.out.println("The number of actual unlinkable fact rows is: " + this.unlinkableRowCount);
        System.out.println("You can vary the above parameters to generate different datasets.");
        System.out.println();
    }

    private boolean matchAllCompositeKeys(TreeMap<String, String> lookupCol2FactTableCol, LinkedList<String> columnValues) {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        for (String lookupTable : this.lookupTableKeys.keySet()) {
            if (this.lookupTableKeys.get(lookupTable).size() == 1) continue;
            Object[] comboKey = new String[this.lookupTableKeys.get(lookupTable).size()];
            int index = 0;
            for (String column : this.lookupTableKeys.get(lookupTable)) {
                String key = lookupTable + "/" + column;
                String factTableCol = lookupCol2FactTableCol.get(key);
                int cardinal = MetadataManager.getInstance((KylinConfig)config).getTableDesc(this.factTableName).findColumnByName(factTableCol).getZeroBasedIndex();
                comboKey[index] = columnValues.get(cardinal);
                ++index;
            }
            Array wrap = new Array(comboKey);
            if (this.lookupTableCompositeKeyValues.get(lookupTable).contains(wrap)) continue;
            return false;
        }
        return true;
    }

    private String createCell(ColumnDesc cDesc) throws Exception {
        ColumnConfig cConfig = null;
        cConfig = this.genConf.getColumnConfigByName(cDesc.getName());
        if (cConfig == null) {
            return this.createRandomCell(cDesc);
        }
        if (!cConfig.isAsRange() && !cConfig.isExclusive() && this.r.nextBoolean()) {
            return this.createRandomCell(cDesc);
        }
        ArrayList<String> valueSet = cConfig.getValueSet();
        if (valueSet == null || valueSet.size() == 0) {
            throw new Exception("Did you forget to specify value set for " + cDesc.getName());
        }
        if (!cConfig.isAsRange()) {
            return this.randomPick(valueSet);
        }
        if (valueSet.size() != 2) {
            throw new Exception("Only two values can be set for range values, the column: " + cDesc.getName());
        }
        return this.createRandomCell(cDesc, valueSet);
    }

    private LinkedList<String> createRow(TreeMap<String, String> factTableCol2LookupCol, TreeSet<String> usedCols, TreeSet<String> defaultColumns) throws Exception {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        LinkedList<String> columnValues = new LinkedList<String>();
        for (ColumnDesc cDesc : MetadataManager.getInstance((KylinConfig)config).getTableDesc(this.factTableName).getColumns()) {
            String colName = cDesc.getName();
            if (factTableCol2LookupCol.containsKey(colName)) {
                ArrayList<String> candidates = this.feasibleValues.get(factTableCol2LookupCol.get(colName));
                columnValues.add(candidates.get(this.r.nextInt(candidates.size())));
                continue;
            }
            if (usedCols.contains(colName)) {
                columnValues.add(this.createCell(cDesc));
                continue;
            }
            columnValues.add(this.createDefaultsCell(cDesc.getTypeName()));
            defaultColumns.add(colName);
        }
        return columnValues;
    }

    private String createTable(int rowCount, TreeMap<String, String> factTableCol2LookupCol, TreeMap<String, String> lookupCol2FactTableCol, TreeSet<String> usedCols) throws Exception {
        try {
            TreeSet<String> defaultColumns = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < rowCount) {
                LinkedList<String> columnValues = this.createRow(factTableCol2LookupCol, usedCols, defaultColumns);
                if (!this.matchAllCompositeKeys(lookupCol2FactTableCol, columnValues)) {
                    if (this.unlinkableRowCount >= this.unlinkableRowCountMax) continue;
                    ++this.unlinkableRowCount;
                }
                for (String c : columnValues) {
                    sb.append(c + ",");
                }
                sb.deleteCharAt(sb.length() - 1);
                sb.append(System.getProperty("line.separator"));
                ++i;
            }
            this.printColumnMappings(factTableCol2LookupCol, usedCols, defaultColumns);
            return sb.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
            return null;
        }
    }

    public static String generate(String cubeName, String rowCount, String linkableRatio, String randomSeed, String joinType) throws Exception {
        long seed;
        if (cubeName == null) {
            cubeName = "test_kylin_cube_with_slr_ready";
        }
        if (rowCount == null) {
            rowCount = "10000";
        }
        if (linkableRatio == null) {
            linkableRatio = "0.6";
        }
        FactTableGenerator generator = new FactTableGenerator();
        if (randomSeed != null) {
            seed = Long.parseLong(randomSeed);
        } else {
            Random r = new Random();
            seed = r.nextLong();
        }
        generator.init(cubeName, Integer.parseInt(rowCount), 5.0, Double.parseDouble(linkableRatio), seed);
        generator.prepare();
        return generator.cookData();
    }
}

