/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job;

import java.io.File;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.common.util.HBaseMetadataTestCase;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.job.DeployUtil;
import org.apache.kylin.job.engine.JobEngineConfig;
import org.codehaus.plexus.util.FileUtils;
import org.junit.Before;
import org.junit.Test;

public class SampleCubeSetupTest
extends HBaseMetadataTestCase {
    @Before
    public void before() throws Exception {
        String confPaths = System.getenv("KYLIN_HBASE_CONF_PATH");
        System.out.println("The conf paths is " + confPaths);
        if (confPaths != null) {
            String[] paths;
            for (String path : paths = confPaths.split(":")) {
                if (StringUtils.isEmpty((CharSequence)path)) continue;
                try {
                    ClassUtil.addClasspath((String)new File(path).getAbsolutePath());
                }
                catch (Exception e) {
                    System.out.println(e.getLocalizedMessage());
                    System.out.println(e.getStackTrace());
                }
            }
        }
    }

    @Test
    public void testCubes() throws Exception {
        DeployUtil.initCliWorkDir();
        DeployUtil.deployMetadata();
        DeployUtil.deployJobJars();
        this.deployJobConfToEtc();
        DeployUtil.prepareTestData("inner", "test_kylin_cube_with_slr_empty");
        CubeManager cubeManager = CubeManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
        for (CubeInstance cubeInstance : cubeManager.listAllCubes()) {
            if (cubeInstance.getName().equalsIgnoreCase("test_kylin_cube_without_slr_empty") || cubeInstance.getName().equalsIgnoreCase("test_kylin_cube_with_slr_empty")) continue;
            cubeManager.dropCube(cubeInstance.getName(), false);
        }
    }

    private void deployJobConfToEtc() throws IOException {
        File src = new File("../examples/test_case_data/sandbox", JobEngineConfig.HADOOP_JOB_CONF_FILENAME + ".xml");
        File dst = new File("/etc/kylin", src.getName());
        FileUtils.copyFile((File)src, (File)dst);
    }
}

