/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.HBaseConnection;
import org.apache.kylin.common.persistence.HBaseResourceStore;
import org.apache.kylin.common.util.CliCommandExecutor;
import org.apache.kylin.common.util.SSHClient;
import org.apache.kylin.common.util.TarGZUtil;

public class ImportHBaseData {
    KylinConfig kylinConfig;
    HTableDescriptor[] allTables;
    Configuration config;
    HBaseAdmin hbase;
    CliCommandExecutor cli = null;
    String importFolder = "/tmp/hbase-export/";
    String backupArchive = null;
    String tableNameBase;

    public void setup() throws IOException {
        KylinConfig.destoryInstance();
        System.setProperty("KYLIN_CONF", "../examples/test_case_data/sandbox");
        this.kylinConfig = KylinConfig.getInstanceFromEnv();
        this.cli = this.kylinConfig.getCliCommandExecutor();
        String metadataUrl = this.kylinConfig.getMetadataUrl();
        int cut = metadataUrl.indexOf(64);
        this.tableNameBase = metadataUrl.substring(0, cut);
        String hbaseUrl = cut < 0 ? metadataUrl : metadataUrl.substring(cut + 1);
        HConnection conn = HBaseConnection.get((String)hbaseUrl);
        try {
            this.hbase = new HBaseAdmin(conn);
            this.config = this.hbase.getConfiguration();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        this.uploadTarballToRemote();
    }

    public void tearDown() {
        try {
            if (this.cli != null && this.importFolder != null) {
                this.cli.execute("rm -r " + this.importFolder);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        KylinConfig.destoryInstance();
    }

    public void importTables() throws IOException {
        new HBaseResourceStore(KylinConfig.getInstanceFromEnv());
        List<String> tablelocations = this.getTablesBackupLocations(this.importFolder);
        for (String tableLocation : tablelocations) {
            String table = tableLocation.substring(tableLocation.lastIndexOf("/") + 1);
            if (!table.equalsIgnoreCase(this.tableNameBase) && !table.startsWith("KYLIN_")) continue;
            if (table.startsWith("KYLIN_")) {
                HBaseConnection.createHTableIfNeeded((String)KylinConfig.getInstanceFromEnv().getStorageUrl(), (String)table, (String[])new String[]{"F1", "F2"});
            }
            this.cli.execute("hbase org.apache.hadoop.hbase.mapreduce.Import " + table + " file://" + tableLocation);
        }
    }

    public void uploadTarballToRemote() throws IOException {
        this.cli.execute("mkdir -p /tmp/hbase-export/");
        SSHClient ssh = new SSHClient(this.kylinConfig.getRemoteHadoopCliHostname(), this.kylinConfig.getRemoteHadoopCliUsername(), this.kylinConfig.getRemoteHadoopCliPassword());
        this.cli.execute("tar -xzf /tmp/hbase-export/hbase-export.tar.gz  --directory=" + this.importFolder);
    }

    private List<String> getTablesBackupLocations(String exportBase) throws IOException {
        File exportFile = new File("../examples/test_case_data/minicluster/hbase-export.tar.gz");
        if (!exportFile.exists()) {
            return null;
        }
        File folder = new File("/tmp/hbase-export/");
        if (folder.exists()) {
            folder.delete();
        }
        folder.mkdirs();
        folder.deleteOnExit();
        TarGZUtil.uncompressTarGZ((File)exportFile, (File)folder);
        String[] child = folder.list();
        assert (child.length == 1);
        String backupTime = child[0];
        File backupFolder = new File(folder, backupTime);
        String[] tableNames = backupFolder.list();
        ArrayList<String> locations = new ArrayList<String>(15);
        for (String t : tableNames) {
            locations.add(exportBase + backupTime + "/" + t);
        }
        return locations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        ImportHBaseData export = new ImportHBaseData();
        try {
            export.setup();
            export.importTables();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

