/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.HBaseConnection;
import org.apache.kylin.common.util.CliCommandExecutor;
import org.apache.kylin.common.util.SSHClient;
import org.codehaus.plexus.util.FileUtils;

public class ExportHBaseData {
    KylinConfig kylinConfig;
    HTableDescriptor[] allTables;
    Configuration config;
    HBaseAdmin hbase;
    CliCommandExecutor cli = null;
    String exportFolder;
    String backupArchive = null;
    String tableNameBase;

    public ExportHBaseData() {
        try {
            this.setup();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void setup() throws IOException {
        long currentTIME = System.currentTimeMillis();
        this.exportFolder = "/tmp/hbase-export/" + currentTIME + "/";
        this.backupArchive = "/tmp/kylin_" + currentTIME + ".tar.gz";
        KylinConfig.destoryInstance();
        System.setProperty("KYLIN_CONF", "../examples/test_case_data/sandbox");
        this.kylinConfig = KylinConfig.getInstanceFromEnv();
        this.cli = this.kylinConfig.getCliCommandExecutor();
        String metadataUrl = this.kylinConfig.getMetadataUrl();
        int cut = metadataUrl.indexOf(64);
        this.tableNameBase = metadataUrl.substring(0, cut);
        String hbaseUrl = cut < 0 ? metadataUrl : metadataUrl.substring(cut + 1);
        HConnection conn = HBaseConnection.get((String)hbaseUrl);
        try {
            this.hbase = new HBaseAdmin(conn);
            this.config = this.hbase.getConfiguration();
            this.allTables = this.hbase.listTables();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void tearDown() {
        try {
            if (this.cli != null && this.exportFolder != null) {
                this.cli.execute("hadoop fs -rm -r " + this.exportFolder);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            if (this.cli != null && this.exportFolder != null) {
                this.cli.execute("rm -r " + this.exportFolder);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            if (this.cli != null && this.backupArchive != null) {
                this.cli.execute("rm " + this.backupArchive);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        KylinConfig.destoryInstance();
    }

    public void exportTables() throws IOException {
        this.cli.execute("mkdir -p " + this.exportFolder);
        for (HTableDescriptor table : this.allTables) {
            String tName = table.getNameAsString();
            if (!tName.equals(this.tableNameBase) && !tName.startsWith("KYLIN_")) continue;
            this.cli.execute("hbase org.apache.hadoop.hbase.mapreduce.Export " + tName + " " + this.exportFolder + tName);
        }
        this.cli.execute("hadoop fs -copyToLocal " + this.exportFolder + " " + this.exportFolder);
        this.cli.execute("tar -zcvf " + this.backupArchive + " --directory=" + this.exportFolder + " .");
        this.downloadToLocal();
    }

    public void downloadToLocal() throws IOException {
        String localArchive = "../examples/test_case_data/minicluster/hbase-export.tar.gz";
        if (this.kylinConfig.getRunAsRemoteCommand()) {
            SSHClient ssh = new SSHClient(this.kylinConfig.getRemoteHadoopCliHostname(), this.kylinConfig.getRemoteHadoopCliUsername(), this.kylinConfig.getRemoteHadoopCliPassword());
            try {
                ssh.scpFileToLocal(this.backupArchive, localArchive);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            FileUtils.copyFile((File)new File(this.backupArchive), (File)new File(localArchive));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        ExportHBaseData export = new ExportHBaseData();
        try {
            export.exportTables();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            export.tearDown();
        }
    }
}

