/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.ResourceTool;
import org.apache.kylin.common.util.CliCommandExecutor;
import org.apache.kylin.common.util.HiveClient;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.job.dataGen.FactTableGenerator;
import org.apache.kylin.job.hadoop.hive.SqlHiveDataTypeMapping;
import org.apache.kylin.metadata.MetadataManager;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.tools.ant.filters.StringInputStream;
import org.codehaus.plexus.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployUtil {
    private static final Logger logger = LoggerFactory.getLogger(DeployUtil.class);
    static final String TABLE_CAL_DT = "edw.test_cal_dt";
    static final String TABLE_CATEGORY_GROUPINGS = "default.test_category_groupings";
    static final String TABLE_KYLIN_FACT = "default.test_kylin_fact";
    static final String TABLE_SELLER_TYPE_DIM = "edw.test_seller_type_dim";
    static final String TABLE_SITES = "edw.test_sites";
    static final String[] TABLE_NAMES = new String[]{"edw.test_cal_dt", "default.test_category_groupings", "default.test_kylin_fact", "edw.test_seller_type_dim", "edw.test_sites"};

    public static void initCliWorkDir() throws IOException {
        DeployUtil.execCliCommand("rm -rf " + DeployUtil.getHadoopCliWorkingDir());
        DeployUtil.execCliCommand("mkdir -p " + DeployUtil.config().getKylinJobLogDir());
    }

    public static void deployMetadata() throws IOException {
        ResourceTool.reset((KylinConfig)DeployUtil.config());
        ResourceTool.copy((KylinConfig)KylinConfig.createInstanceFromUri((String)"../examples/test_case_data/localmeta"), (KylinConfig)DeployUtil.config());
        for (CubeInstance cube : CubeManager.getInstance((KylinConfig)DeployUtil.config()).listAllCubes()) {
            cube.getDescriptor().setSignature(cube.getDescriptor().calculateSignature());
            CubeManager.getInstance((KylinConfig)DeployUtil.config()).updateCube(cube);
        }
    }

    public static void overrideJobJarLocations() {
        Pair<File, File> files = DeployUtil.getJobJarFiles();
        File jobJar = (File)files.getFirst();
        File coprocessorJar = (File)files.getSecond();
        DeployUtil.config().overrideKylinJobJarPath(jobJar.getAbsolutePath());
        DeployUtil.config().overrideCoprocessorLocalJar(coprocessorJar.getAbsolutePath());
    }

    public static void deployJobJars() throws IOException {
        Pair<File, File> files = DeployUtil.getJobJarFiles();
        File originalJobJar = (File)files.getFirst();
        File originalCoprocessorJar = (File)files.getSecond();
        String jobJarPath = DeployUtil.config().getKylinJobJarPath();
        if (StringUtils.isEmpty((String)jobJarPath)) {
            throw new RuntimeException("deployJobJars cannot find job jar");
        }
        File targetJobJar = new File(jobJarPath);
        File jobJarRenamedAsTarget = new File(originalJobJar.getParentFile(), targetJobJar.getName());
        if (!originalJobJar.equals(jobJarRenamedAsTarget)) {
            FileUtils.copyFile((File)originalJobJar, (File)jobJarRenamedAsTarget);
        }
        File targetCoprocessorJar = new File(DeployUtil.config().getCoprocessorLocalJar());
        File coprocessorJarRenamedAsTarget = new File(originalCoprocessorJar.getParentFile(), targetCoprocessorJar.getName());
        if (!originalCoprocessorJar.equals(coprocessorJarRenamedAsTarget)) {
            FileUtils.copyFile((File)originalCoprocessorJar, (File)coprocessorJarRenamedAsTarget);
        }
        CliCommandExecutor cmdExec = DeployUtil.config().getCliCommandExecutor();
        cmdExec.copyFile(jobJarRenamedAsTarget.getAbsolutePath(), targetJobJar.getParent());
        cmdExec.copyFile(coprocessorJarRenamedAsTarget.getAbsolutePath(), targetCoprocessorJar.getParent());
    }

    private static Pair<File, File> getJobJarFiles() {
        String version;
        try {
            MavenXpp3Reader pomReader = new MavenXpp3Reader();
            Model model = pomReader.read((Reader)new FileReader("../pom.xml"));
            version = model.getVersion();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        File jobJar = new File("../job/target", "kylin-job-" + version + "-job.jar");
        File coprocessorJar = new File("../storage/target", "kylin-storage-" + version + "-coprocessor.jar");
        return new Pair((Object)jobJar, (Object)coprocessorJar);
    }

    private static void execCliCommand(String cmd) throws IOException {
        DeployUtil.config().getCliCommandExecutor().execute(cmd);
    }

    private static String getHadoopCliWorkingDir() {
        return DeployUtil.config().getCliWorkingDir();
    }

    private static KylinConfig config() {
        return KylinConfig.getInstanceFromEnv();
    }

    public static void prepareTestData(String joinType, String cubeName) throws Exception {
        String factTableName = TABLE_KYLIN_FACT.toUpperCase();
        String content = null;
        boolean buildCubeUsingProvidedData = Boolean.parseBoolean(System.getProperty("buildCubeUsingProvidedData"));
        if (!buildCubeUsingProvidedData) {
            System.out.println("build cube with random dataset");
            if (joinType.equalsIgnoreCase("inner")) {
                content = FactTableGenerator.generate(cubeName, "10000", "1", null, "inner");
            } else if (joinType.equalsIgnoreCase("left")) {
                content = FactTableGenerator.generate(cubeName, "10000", "0.6", null, "left");
            } else {
                throw new IllegalArgumentException("Unsupported join type : " + joinType);
            }
            assert (content != null);
            DeployUtil.overrideFactTableData(content, factTableName);
        } else {
            System.out.println("build cube with provided dataset");
        }
        DeployUtil.duplicateFactTableData(factTableName, joinType);
        DeployUtil.deployHiveTables();
    }

    public static void overrideFactTableData(String factTableContent, String factTableName) throws IOException {
        ResourceStore store = ResourceStore.getStore((KylinConfig)DeployUtil.config());
        StringInputStream in = new StringInputStream(factTableContent);
        String factTablePath = "/data/" + factTableName + ".csv";
        store.deleteResource(factTablePath);
        store.putResource(factTablePath, (InputStream)in, System.currentTimeMillis());
        in.close();
    }

    public static void duplicateFactTableData(String factTableName, String joinType) throws IOException {
        ResourceStore store = ResourceStore.getStore((KylinConfig)DeployUtil.config());
        InputStream in = store.getResource("/data/" + factTableName + ".csv");
        String factTablePathWithJoinType = "/data/" + factTableName + ".csv." + joinType.toLowerCase();
        store.deleteResource(factTablePathWithJoinType);
        store.putResource(factTablePathWithJoinType, in, System.currentTimeMillis());
        in.close();
    }

    private static void deployHiveTables() throws Exception {
        MetadataManager metaMgr = MetadataManager.getInstance((KylinConfig)DeployUtil.config());
        File temp = File.createTempFile("temp", ".csv");
        temp.createNewFile();
        for (String tablename : TABLE_NAMES) {
            tablename = tablename.toUpperCase();
            File localBufferFile = new File(temp.getParent() + "/" + tablename + ".csv");
            localBufferFile.createNewFile();
            InputStream hbaseDataStream = metaMgr.getStore().getResource("/data/" + tablename + ".csv");
            FileOutputStream localFileStream = new FileOutputStream(localBufferFile);
            IOUtils.copy((InputStream)hbaseDataStream, (OutputStream)localFileStream);
            hbaseDataStream.close();
            localFileStream.close();
            localBufferFile.deleteOnExit();
        }
        String tableFileDir = temp.getParent();
        temp.delete();
        HiveClient hiveClient = new HiveClient();
        hiveClient.executeHQL("CREATE DATABASE IF NOT EXISTS EDW");
        hiveClient.executeHQL(DeployUtil.generateCreateTableHql(metaMgr.getTableDesc(TABLE_CAL_DT.toUpperCase())));
        hiveClient.executeHQL(DeployUtil.generateCreateTableHql(metaMgr.getTableDesc(TABLE_CATEGORY_GROUPINGS.toUpperCase())));
        hiveClient.executeHQL(DeployUtil.generateCreateTableHql(metaMgr.getTableDesc(TABLE_KYLIN_FACT.toUpperCase())));
        hiveClient.executeHQL(DeployUtil.generateCreateTableHql(metaMgr.getTableDesc(TABLE_SELLER_TYPE_DIM.toUpperCase())));
        hiveClient.executeHQL(DeployUtil.generateCreateTableHql(metaMgr.getTableDesc(TABLE_SITES.toUpperCase())));
        hiveClient.executeHQL(DeployUtil.generateLoadDataHql(TABLE_CAL_DT, tableFileDir));
        hiveClient.executeHQL(DeployUtil.generateLoadDataHql(TABLE_CATEGORY_GROUPINGS, tableFileDir));
        hiveClient.executeHQL(DeployUtil.generateLoadDataHql(TABLE_KYLIN_FACT, tableFileDir));
        hiveClient.executeHQL(DeployUtil.generateLoadDataHql(TABLE_SELLER_TYPE_DIM, tableFileDir));
        hiveClient.executeHQL(DeployUtil.generateLoadDataHql(TABLE_SITES, tableFileDir));
    }

    private static String generateLoadDataHql(String tableName, String tableFileDir) {
        return "LOAD DATA LOCAL INPATH '" + tableFileDir + "/" + tableName.toUpperCase() + ".csv' OVERWRITE INTO TABLE " + tableName.toUpperCase();
    }

    private static String[] generateCreateTableHql(TableDesc tableDesc) {
        String dropsql = "DROP TABLE IF EXISTS " + tableDesc.getIdentity();
        StringBuilder ddl = new StringBuilder();
        ddl.append("CREATE TABLE " + tableDesc.getIdentity() + "\n");
        ddl.append("(\n");
        for (int i = 0; i < tableDesc.getColumns().length; ++i) {
            ColumnDesc col = tableDesc.getColumns()[i];
            if (i > 0) {
                ddl.append(",");
            }
            ddl.append(col.getName() + " " + SqlHiveDataTypeMapping.getHiveDataType((String)col.getDatatype()) + "\n");
        }
        ddl.append(")\n");
        ddl.append("ROW FORMAT DELIMITED FIELDS TERMINATED BY ','\n");
        ddl.append("STORED AS TEXTFILE");
        return new String[]{dropsql, ddl.toString()};
    }
}

