/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.common.util.HBaseMetadataTestCase;
import org.apache.kylin.invertedindex.IIInstance;
import org.apache.kylin.invertedindex.IIManager;
import org.apache.kylin.invertedindex.IISegment;
import org.apache.kylin.job.BuildCubeWithEngineTest;
import org.apache.kylin.job.DeployUtil;
import org.apache.kylin.job.ExportHBaseData;
import org.apache.kylin.job.engine.JobEngineConfig;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.job.hadoop.cube.StorageCleanupJob;
import org.apache.kylin.job.impl.threadpool.DefaultScheduler;
import org.apache.kylin.job.invertedindex.IIJob;
import org.apache.kylin.job.invertedindex.IIJobBuilder;
import org.apache.kylin.job.manager.ExecutableManager;
import org.apache.kylin.metadata.realization.RealizationStatusEnum;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class BuildIIWithEngineTest {
    private JobEngineConfig jobEngineConfig;
    private IIManager iiManager;
    private DefaultScheduler scheduler;
    protected ExecutableManager jobService;
    protected static final String TEST_II_NAME = "test_kylin_ii";
    private static final Log logger = LogFactory.getLog(BuildCubeWithEngineTest.class);

    protected void waitForJob(String jobId) {
        AbstractExecutable job;
        while ((job = this.jobService.getJob(jobId)).getStatus() != ExecutableState.SUCCEED && job.getStatus() != ExecutableState.ERROR) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    @BeforeClass
    public static void beforeClass() throws Exception {
        logger.info((Object)("Adding to classpath: " + new File("../examples/test_case_data/sandbox").getAbsolutePath()));
        ClassUtil.addClasspath((String)new File("../examples/test_case_data/sandbox").getAbsolutePath());
        System.setProperty("hdp.version", "2.2.4.2-2");
    }

    @Before
    public void before() throws Exception {
        HBaseMetadataTestCase.staticCreateTestMetadata((String)"../examples/test_case_data/sandbox");
        DeployUtil.initCliWorkDir();
        DeployUtil.overrideJobJarLocations();
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        this.jobService = ExecutableManager.getInstance((KylinConfig)kylinConfig);
        this.scheduler = DefaultScheduler.getInstance();
        this.scheduler.init(new JobEngineConfig(kylinConfig));
        if (!this.scheduler.hasStarted()) {
            throw new RuntimeException("scheduler has not been started");
        }
        this.iiManager = IIManager.getInstance((KylinConfig)kylinConfig);
        this.jobEngineConfig = new JobEngineConfig(kylinConfig);
        for (String jobId : this.jobService.getAllJobIds()) {
            if (!(this.jobService.getJob(jobId) instanceof IIJob)) continue;
            this.jobService.deleteJob(jobId);
        }
        IIInstance ii = this.iiManager.getII(TEST_II_NAME);
        if (ii.getStatus() != RealizationStatusEnum.DISABLED) {
            ii.setStatus(RealizationStatusEnum.DISABLED);
            this.iiManager.updateII(ii);
        }
    }

    @After
    public void after() throws Exception {
        IIInstance ii = this.iiManager.getII(TEST_II_NAME);
        if (ii.getStatus() != RealizationStatusEnum.READY) {
            ii.setStatus(RealizationStatusEnum.READY);
            this.iiManager.updateII(ii);
        }
        this.backup();
    }

    @Test
    public void testBuildII() throws Exception {
        int i;
        String[] testCase = new String[]{"buildII"};
        ExecutorService executorService = Executors.newFixedThreadPool(testCase.length);
        CountDownLatch countDownLatch = new CountDownLatch(testCase.length);
        ArrayList tasks = Lists.newArrayListWithExpectedSize((int)testCase.length);
        for (i = 0; i < testCase.length; ++i) {
            tasks.add(executorService.submit(new TestCallable(testCase[i], countDownLatch)));
        }
        countDownLatch.await();
        for (i = 0; i < tasks.size(); ++i) {
            Future task = (Future)tasks.get(i);
            List jobIds = (List)task.get();
            for (String jobId : jobIds) {
                this.assertJobSucceed(jobId);
            }
        }
    }

    private void assertJobSucceed(String jobId) {
        Assert.assertEquals((Object)ExecutableState.SUCCEED, (Object)this.jobService.getOutput(jobId).getState());
    }

    protected List<String> buildII() throws Exception {
        this.clearSegment(TEST_II_NAME);
        SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd");
        f.setTimeZone(TimeZone.getTimeZone("GMT"));
        long date1 = 0L;
        long date2 = f.parse("2015-01-01").getTime();
        ArrayList result = Lists.newArrayList();
        result.add(this.buildSegment(TEST_II_NAME, date1, date2));
        return result;
    }

    private void clearSegment(String iiName) throws Exception {
        IIInstance ii = this.iiManager.getII(iiName);
        ii.getSegments().clear();
        this.iiManager.updateII(ii);
    }

    private String buildSegment(String iiName, long startDate, long endDate) throws Exception {
        IIInstance iiInstance = this.iiManager.getII(iiName);
        IISegment segment = this.iiManager.buildSegment(iiInstance, startDate, endDate);
        iiInstance.getSegments().add(segment);
        this.iiManager.updateII(iiInstance);
        IIJobBuilder iiJobBuilder = new IIJobBuilder(this.jobEngineConfig);
        IIJob job = iiJobBuilder.buildJob(segment);
        this.jobService.addJob((AbstractExecutable)job);
        this.waitForJob(job.getId());
        return job.getId();
    }

    private int cleanupOldStorage() throws Exception {
        String[] args = new String[]{"--delete", "true"};
        int exitCode = ToolRunner.run((Tool)new StorageCleanupJob(), (String[])args);
        return exitCode;
    }

    private void backup() throws Exception {
        int exitCode = this.cleanupOldStorage();
        if (exitCode == 0) {
            this.exportHBaseData();
        }
    }

    private void exportHBaseData() throws IOException {
        ExportHBaseData export = new ExportHBaseData();
        export.exportTables();
    }

    public static void main(String[] args) throws Exception {
        BuildIIWithEngineTest instance = new BuildIIWithEngineTest();
        BuildIIWithEngineTest.beforeClass();
        instance.before();
        instance.testBuildII();
        instance.after();
    }

    private class TestCallable
    implements Callable<List<String>> {
        private final String methodName;
        private final CountDownLatch countDownLatch;

        public TestCallable(String methodName, CountDownLatch countDownLatch) {
            this.methodName = methodName;
            this.countDownLatch = countDownLatch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<String> call() throws Exception {
            try {
                Method method = BuildIIWithEngineTest.class.getDeclaredMethod(this.methodName, new Class[0]);
                method.setAccessible(true);
                List list = (List)method.invoke((Object)BuildIIWithEngineTest.this, new Object[0]);
                return list;
            }
            finally {
                this.countDownLatch.countDown();
            }
        }
    }
}

