/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job;

import com.google.common.collect.Lists;
import java.io.File;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.common.util.HBaseMetadataTestCase;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.job.DeployUtil;
import org.apache.kylin.job.cube.CubingJob;
import org.apache.kylin.job.cube.CubingJobBuilder;
import org.apache.kylin.job.engine.JobEngineConfig;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.job.impl.threadpool.DefaultScheduler;
import org.apache.kylin.job.manager.ExecutableManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class BuildCubeWithEngineTest {
    private JobEngineConfig jobEngineConfig;
    private CubeManager cubeManager;
    private DefaultScheduler scheduler;
    protected ExecutableManager jobService;
    private static final Log logger = LogFactory.getLog(BuildCubeWithEngineTest.class);

    protected void waitForJob(String jobId) {
        AbstractExecutable job;
        while ((job = this.jobService.getJob(jobId)).getStatus() != ExecutableState.SUCCEED && job.getStatus() != ExecutableState.ERROR) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    @BeforeClass
    public static void beforeClass() throws Exception {
        logger.info((Object)("Adding to classpath: " + new File("../examples/test_case_data/sandbox").getAbsolutePath()));
        ClassUtil.addClasspath((String)new File("../examples/test_case_data/sandbox").getAbsolutePath());
        System.setProperty("KYLIN_CONF", "../examples/test_case_data/sandbox");
        System.setProperty("hdp.version", "2.2.4.2-2");
    }

    @Before
    public void before() throws Exception {
        HBaseMetadataTestCase.staticCreateTestMetadata((String)"../examples/test_case_data/sandbox");
        DeployUtil.initCliWorkDir();
        DeployUtil.deployMetadata();
        DeployUtil.overrideJobJarLocations();
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        this.jobService = ExecutableManager.getInstance((KylinConfig)kylinConfig);
        this.scheduler = DefaultScheduler.getInstance();
        this.scheduler.init(new JobEngineConfig(kylinConfig));
        if (!this.scheduler.hasStarted()) {
            throw new RuntimeException("scheduler has not been started");
        }
        this.cubeManager = CubeManager.getInstance((KylinConfig)kylinConfig);
        this.jobEngineConfig = new JobEngineConfig(kylinConfig);
        for (String jobId : this.jobService.getAllJobIds()) {
            if (!(this.jobService.getJob(jobId) instanceof CubingJob)) continue;
            this.jobService.deleteJob(jobId);
        }
    }

    @After
    public void after() {
        HBaseMetadataTestCase.staticCleanupTestMetadata();
    }

    @Test
    public void test() throws Exception {
        this.testInner();
        this.testLeft();
    }

    private void testInner() throws Exception {
        DeployUtil.prepareTestData("inner", "test_kylin_cube_with_slr_empty");
        String[] testCase = new String[]{"testInnerJoinCube", "testInnerJoinCube2"};
        this.runTestAndAssertSucceed(testCase);
    }

    private void testLeft() throws Exception {
        DeployUtil.prepareTestData("left", "test_kylin_cube_with_slr_left_join_empty");
        String[] testCase = new String[]{"testLeftJoinCube", "testLeftJoinCube2"};
        this.runTestAndAssertSucceed(testCase);
    }

    private void runTestAndAssertSucceed(String[] testCase) throws Exception {
        int i;
        ExecutorService executorService = Executors.newFixedThreadPool(testCase.length);
        CountDownLatch countDownLatch = new CountDownLatch(testCase.length);
        ArrayList tasks = Lists.newArrayListWithExpectedSize((int)testCase.length);
        for (i = 0; i < testCase.length; ++i) {
            tasks.add(executorService.submit(new TestCallable(testCase[i], countDownLatch)));
        }
        countDownLatch.await();
        try {
            for (i = 0; i < tasks.size(); ++i) {
                Future task = (Future)tasks.get(i);
                List jobIds = (List)task.get();
                for (String jobId : jobIds) {
                    this.assertJobSucceed(jobId);
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            throw ex;
        }
    }

    private void assertJobSucceed(String jobId) {
        Assert.assertEquals((String)("The job '" + jobId + "' is failed."), (Object)ExecutableState.SUCCEED, (Object)this.jobService.getOutput(jobId).getState());
    }

    private List<String> testInnerJoinCube2() throws Exception {
        this.clearSegment("test_kylin_cube_with_slr_empty");
        SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd");
        f.setTimeZone(TimeZone.getTimeZone("GMT"));
        long date1 = 0L;
        long date2 = f.parse("2013-01-01").getTime();
        long date3 = f.parse("2022-01-01").getTime();
        ArrayList result = Lists.newArrayList();
        result.add(this.buildSegment("test_kylin_cube_with_slr_empty", date1, date2));
        result.add(this.buildSegment("test_kylin_cube_with_slr_empty", date2, date3));
        return result;
    }

    private List<String> testInnerJoinCube() throws Exception {
        this.clearSegment("test_kylin_cube_without_slr_empty");
        SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd");
        f.setTimeZone(TimeZone.getTimeZone("GMT"));
        long date1 = 0L;
        long date2 = f.parse("2013-01-01").getTime();
        ArrayList result = Lists.newArrayList();
        result.add(this.buildSegment("test_kylin_cube_without_slr_empty", date1, date2));
        return result;
    }

    private List<String> testLeftJoinCube2() throws Exception {
        SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd");
        f.setTimeZone(TimeZone.getTimeZone("GMT"));
        ArrayList result = Lists.newArrayList();
        String cubeName = "test_kylin_cube_without_slr_left_join_empty";
        long dateStart = this.cubeManager.getCube("test_kylin_cube_without_slr_left_join_empty").getDescriptor().getModel().getPartitionDesc().getPartitionDateStart();
        long dateEnd = f.parse("2012-06-01").getTime();
        this.clearSegment("test_kylin_cube_without_slr_left_join_empty");
        result.add(this.buildSegment("test_kylin_cube_without_slr_left_join_empty", dateStart, dateEnd));
        dateStart = f.parse("2012-06-01").getTime();
        dateEnd = f.parse("2022-01-01").getTime();
        result.add(this.buildSegment("test_kylin_cube_without_slr_left_join_empty", dateStart, dateEnd));
        return result;
    }

    private List<String> testLeftJoinCube() throws Exception {
        String cubeName = "test_kylin_cube_with_slr_left_join_empty";
        this.clearSegment(cubeName);
        SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd");
        f.setTimeZone(TimeZone.getTimeZone("GMT"));
        long dateStart = this.cubeManager.getCube(cubeName).getDescriptor().getModel().getPartitionDesc().getPartitionDateStart();
        long dateEnd = f.parse("2050-11-12").getTime();
        ArrayList result = Lists.newArrayList();
        result.add(this.buildSegment(cubeName, dateStart, dateEnd));
        return result;
    }

    private void clearSegment(String cubeName) throws Exception {
        CubeInstance cube = this.cubeManager.getCube(cubeName);
        cube.getSegments().clear();
        this.cubeManager.updateCube(cube);
    }

    private String buildSegment(String cubeName, long startDate, long endDate) throws Exception {
        CubeSegment segment = this.cubeManager.appendSegments(this.cubeManager.getCube(cubeName), endDate);
        CubingJobBuilder cubingJobBuilder = new CubingJobBuilder(this.jobEngineConfig);
        CubingJob job = cubingJobBuilder.buildJob(segment);
        this.jobService.addJob((AbstractExecutable)job);
        this.waitForJob(job.getId());
        return job.getId();
    }

    private class TestCallable
    implements Callable<List<String>> {
        private final String methodName;
        private final CountDownLatch countDownLatch;

        public TestCallable(String methodName, CountDownLatch countDownLatch) {
            this.methodName = methodName;
            this.countDownLatch = countDownLatch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<String> call() throws Exception {
            try {
                Method method = BuildCubeWithEngineTest.class.getDeclaredMethod(this.methodName, new Class[0]);
                method.setAccessible(true);
                List list = (List)method.invoke((Object)BuildCubeWithEngineTest.this, new Object[0]);
                return list;
            }
            finally {
                this.countDownLatch.countDown();
            }
        }
    }
}

