/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.TimeZone;
import org.apache.calcite.avatica.DriverVersion;
import org.apache.kylin.jdbc.Driver;
import org.apache.kylin.jdbc.DummyDriver;
import org.apache.kylin.jdbc.KylinConnection;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class DriverTest {
    @Test
    public void testVersion() {
        DummyDriver driver = new DummyDriver();
        DriverVersion version = driver.getDriverVersion();
        Assert.assertNotEquals((Object)"unknown version", (Object)version.productVersion);
    }

    @Test
    public void testStatementWithMockData() throws SQLException {
        DummyDriver driver = new DummyDriver();
        Connection conn = driver.connect("jdbc:kylin://test_url/test_db", null);
        ResultSet tables = conn.getMetaData().getTables(null, null, null, null);
        while (tables.next()) {
            int i;
            for (i = 0; i < 4; ++i) {
                Assert.assertEquals((Object)"dummy", (Object)tables.getString(i + 1));
            }
            for (i = 4; i < 10; ++i) {
                Assert.assertNull((Object)tables.getString(i + 1));
            }
        }
        Statement state = conn.createStatement();
        ResultSet resultSet = state.executeQuery("select * from test_table");
        ResultSetMetaData metadata = resultSet.getMetaData();
        Assert.assertEquals((long)12L, (long)metadata.getColumnType(1));
        Assert.assertEquals((Object)"varchar", (Object)metadata.getColumnTypeName(1));
        Assert.assertEquals((long)1L, (long)metadata.isNullable(1));
        while (resultSet.next()) {
            Assert.assertEquals((Object)"foo", (Object)resultSet.getString(1));
            Assert.assertEquals((Object)"bar", (Object)resultSet.getString(2));
            Assert.assertEquals((Object)"tool", (Object)resultSet.getString(3));
        }
        resultSet.close();
        state.close();
        conn.close();
    }

    @Test
    public void testStatementWithQuestionMask() throws SQLException {
        DummyDriver driver = new DummyDriver();
        Connection conn = driver.connect("jdbc:kylin://test_url/test_db", null);
        Statement state = conn.createStatement();
        ResultSet resultSet = state.executeQuery("select * from test_table where url not in ('http://a.b.com/?a=b')");
        ResultSetMetaData metadata = resultSet.getMetaData();
        Assert.assertEquals((long)12L, (long)metadata.getColumnType(1));
        Assert.assertEquals((Object)"varchar", (Object)metadata.getColumnTypeName(1));
        Assert.assertEquals((long)1L, (long)metadata.isNullable(1));
        while (resultSet.next()) {
            Assert.assertEquals((Object)"foo", (Object)resultSet.getString(1));
            Assert.assertEquals((Object)"bar", (Object)resultSet.getString(2));
            Assert.assertEquals((Object)"tool", (Object)resultSet.getString(3));
        }
        resultSet.close();
        state.close();
        conn.close();
    }

    @Test
    public void testPreparedStatementWithMockData() throws SQLException {
        DummyDriver driver = new DummyDriver();
        Connection conn = driver.connect("jdbc:kylin://test_url/test_db", null);
        PreparedStatement state = conn.prepareStatement("select * from test_table where id=?");
        state.setInt(1, 10);
        ResultSet resultSet = state.executeQuery();
        ResultSetMetaData metadata = resultSet.getMetaData();
        Assert.assertEquals((long)12L, (long)metadata.getColumnType(1));
        Assert.assertEquals((Object)"varchar", (Object)metadata.getColumnTypeName(1));
        Assert.assertEquals((long)1L, (long)metadata.isNullable(1));
        while (resultSet.next()) {
            Assert.assertEquals((Object)"foo", (Object)resultSet.getString(1));
            Assert.assertEquals((Object)"bar", (Object)resultSet.getString(2));
            Assert.assertEquals((Object)"tool", (Object)resultSet.getString(3));
        }
        resultSet.close();
        state.close();
        conn.close();
    }

    @Test
    public void testDateAndTimeStampWithMockData() throws Exception {
        TimeZone timeZone = TimeZone.getDefault();
        TimeZone.setDefault(TimeZone.getTimeZone("America/New_York"));
        DummyDriver driver = new DummyDriver();
        Connection conn = driver.connect("jdbc:kylin://test_url/test_db", null);
        PreparedStatement state = conn.prepareStatement("select * from test_table where id=?");
        state.setInt(1, 10);
        ResultSet resultSet = state.executeQuery();
        ResultSetMetaData metadata = resultSet.getMetaData();
        Assert.assertEquals((Object)"date", (Object)metadata.getColumnTypeName(4));
        Assert.assertEquals((Object)"time", (Object)metadata.getColumnTypeName(5));
        Assert.assertEquals((Object)"timestamp", (Object)metadata.getColumnTypeName(6));
        while (resultSet.next()) {
            Assert.assertEquals((Object)"2019-04-27", (Object)resultSet.getString(4));
            Assert.assertEquals((Object)"2019-04-27", (Object)resultSet.getDate(4).toString());
            Assert.assertEquals((Object)"17:30:03", (Object)resultSet.getString(5));
            Assert.assertEquals((Object)"17:30:03", (Object)resultSet.getTime(5).toString());
            Assert.assertEquals((Object)"2019-04-27 17:30:03", (Object)resultSet.getString(6));
            Assert.assertEquals((Object)"2019-04-27 17:30:03.123", (Object)resultSet.getTimestamp(6).toString());
        }
        resultSet.close();
        state.close();
        conn.close();
        TimeZone.setDefault(timeZone);
    }

    @Ignore(value="require dev sandbox")
    @Test
    public void testWithCubeData() throws Exception {
        Driver driver = new Driver();
        Properties info = new Properties();
        info.put("user", "ADMIN");
        info.put("password", "KYLIN");
        Connection conn = driver.connect("jdbc:kylin://localhost:7070/default", info);
        ResultSet catalogs = conn.getMetaData().getCatalogs();
        System.out.println("CATALOGS");
        this.printResultSetMetaData(catalogs);
        this.printResultSet(catalogs);
        ResultSet schemas = conn.getMetaData().getSchemas();
        System.out.println("SCHEMAS");
        this.printResultSetMetaData(schemas);
        this.printResultSet(schemas);
        ResultSet tables = conn.getMetaData().getTables(null, null, null, null);
        System.out.println("TABLES");
        this.printResultSetMetaData(tables);
        this.printResultSet(tables);
        for (int j = 0; j < 3; ++j) {
            Statement state = conn.createStatement();
            ResultSet resultSet = state.executeQuery("select * from test_kylin_fact");
            this.printResultSetMetaData(resultSet);
            this.printResultSet(resultSet);
            resultSet.close();
        }
        catalogs.close();
        schemas.close();
        tables.close();
        conn.close();
    }

    @Ignore(value="require dev sandbox")
    @Test
    public void testPreparedStatementWithCubeData() throws SQLException {
        Driver driver = new Driver();
        Properties info = new Properties();
        info.put("user", "ADMIN");
        info.put("password", "KYLIN");
        Connection conn = driver.connect("jdbc:kylin://localhost:7070/default", info);
        PreparedStatement state = conn.prepareStatement("select cal_dt, count(*) from test_kylin_fact where seller_id=? group by cal_dt");
        state.setLong(1, 10000001L);
        ResultSet resultSet = state.executeQuery();
        this.printResultSetMetaData(resultSet);
        this.printResultSet(resultSet);
        resultSet.close();
        state.close();
        conn.close();
    }

    @Test
    public void testSSLFromURL() throws SQLException {
        DummyDriver driver = new DummyDriver();
        Connection conn = driver.connect("jdbc:kylin:ssl=True;//test_url/test_db", null);
        Assert.assertEquals((Object)"test_url", (Object)((KylinConnection)conn).getBaseUrl());
        Assert.assertEquals((Object)"test_db", (Object)((KylinConnection)conn).getProject());
        Assert.assertTrue((boolean)Boolean.parseBoolean((String)((KylinConnection)conn).getConnectionProperties().get("ssl")));
    }

    private void printResultSet(ResultSet rs) throws SQLException {
        ResultSetMetaData meta = rs.getMetaData();
        System.out.println("Data:");
        while (rs.next()) {
            StringBuilder buf = new StringBuilder();
            buf.append("[");
            for (int i = 0; i < meta.getColumnCount(); ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(rs.getString(i + 1));
            }
            buf.append("]");
            System.out.println(buf);
        }
    }

    private void printResultSetMetaData(ResultSet rs) throws SQLException {
        ResultSetMetaData metadata = rs.getMetaData();
        System.out.println("Metadata:");
        for (int i = 0; i < metadata.getColumnCount(); ++i) {
            String metaStr = metadata.getCatalogName(i + 1) + " " + metadata.getColumnClassName(i + 1) + " " + metadata.getColumnDisplaySize(i + 1) + " " + metadata.getColumnLabel(i + 1) + " " + metadata.getColumnName(i + 1) + " " + metadata.getColumnType(i + 1) + " " + metadata.getColumnTypeName(i + 1) + " " + metadata.getPrecision(i + 1) + " " + metadata.getScale(i + 1) + " " + metadata.getSchemaName(i + 1) + " " + metadata.getTableName(i + 1);
            System.out.println(metaStr);
        }
    }
}

