/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.util;

import java.sql.Array;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.AvaticaResultSet;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.AvaticaResultSetMetaData;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.ColumnMetaData;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.Meta;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.QueryState;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.util.AbstractCursor;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.util.ArrayImpl;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.util.Cursor;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.util.ListIteratorCursor;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.util.Unsafe;

public class ArrayFactoryImpl
implements ArrayImpl.Factory {
    private TimeZone timeZone;

    public ArrayFactoryImpl(TimeZone timeZone) {
        this.timeZone = Objects.requireNonNull(timeZone);
    }

    @Override
    public ResultSet create(ColumnMetaData.AvaticaType elementType, Iterable<Object> elements) {
        List<Object> rows;
        ColumnMetaData.ScalarType arrayOffsetType = ColumnMetaData.scalar(4, "INTEGER", ColumnMetaData.Rep.PRIMITIVE_INT);
        List<ColumnMetaData> types = Arrays.asList(ColumnMetaData.dummy(arrayOffsetType, false), ColumnMetaData.dummy(elementType, true));
        List<Object> untypedRows = rows = this.createResultSetRowsForArrayData(elements);
        try (ListIteratorCursor cursor = new ListIteratorCursor(rows.iterator());){
            String sql = "MOCKED";
            QueryState state = new QueryState("MOCKED");
            Meta.Signature signature = new Meta.Signature(types, "MOCKED", Collections.emptyList(), Collections.emptyMap(), Meta.CursorFactory.LIST, Meta.StatementType.SELECT);
            AvaticaResultSetMetaData resultSetMetaData = new AvaticaResultSetMetaData(null, "MOCKED", signature);
            Meta.Frame frame = new Meta.Frame(0L, true, untypedRows);
            AvaticaResultSet resultSet = new AvaticaResultSet(null, state, signature, resultSetMetaData, this.timeZone, frame);
            resultSet.execute2(cursor, types);
            AvaticaResultSet avaticaResultSet = resultSet;
            return avaticaResultSet;
        }
    }

    @Override
    public Array createArray(ColumnMetaData.AvaticaType elementType, Iterable<Object> elements) {
        ArrayList<Object> elementList;
        ColumnMetaData.ArrayType array = ColumnMetaData.array(elementType, elementType.name, ColumnMetaData.Rep.ARRAY);
        List<ColumnMetaData> types = Collections.singletonList(ColumnMetaData.dummy(array, true));
        if (elements instanceof List) {
            elementList = (ArrayList<Object>)elements;
        } else {
            elementList = new ArrayList<Object>();
            for (Object element : elements) {
                elementList.add(element);
            }
        }
        try (ListIteratorCursor cursor = new ListIteratorCursor(this.createRowForArrayData(elementList));){
            List<Cursor.Accessor> accessor = cursor.createAccessors(types, Unsafe.localCalendar(), this);
            assert (1 == accessor.size());
            ArrayImpl arrayImpl = new ArrayImpl(elementList, (AbstractCursor.ArrayAccessor)accessor.get(0));
            return arrayImpl;
        }
    }

    private List<List<Object>> createResultSetRowsForArrayData(Iterable<Object> elements) {
        ArrayList<List<Object>> rows = new ArrayList<List<Object>>();
        int i = 0;
        for (Object element : elements) {
            rows.add(Arrays.asList(i + 1, element));
            ++i;
        }
        return rows;
    }

    private Iterator<List<Object>> createRowForArrayData(List<Object> elements) {
        List<List<Object>> row = Collections.singletonList(elements);
        return Collections.singletonList(row).iterator();
    }
}

