/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.jdbc;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.bind.DatatypeConverter;
import org.apache.kylin.jdbc.IRemoteClient;
import org.apache.kylin.jdbc.KylinConnectionInfo;
import org.apache.kylin.jdbc.KylinMeta;
import org.apache.kylin.jdbc.json.PreparedQueryRequest;
import org.apache.kylin.jdbc.json.SQLResponseStub;
import org.apache.kylin.jdbc.json.StatementParameter;
import org.apache.kylin.jdbc.json.TableMetaStub;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.ColumnMetaData;
import org.apache.kylin.jdbc.shaded.org.apache.http.HttpResponse;
import org.apache.kylin.jdbc.shaded.org.apache.http.client.HttpClient;
import org.apache.kylin.jdbc.shaded.org.apache.http.client.methods.HttpGet;
import org.apache.kylin.jdbc.shaded.org.apache.http.client.methods.HttpPost;
import org.apache.kylin.jdbc.shaded.org.apache.http.client.methods.HttpRequestBase;
import org.apache.kylin.jdbc.shaded.org.apache.http.conn.scheme.Scheme;
import org.apache.kylin.jdbc.shaded.org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.kylin.jdbc.shaded.org.apache.http.conn.ssl.TrustStrategy;
import org.apache.kylin.jdbc.shaded.org.apache.http.entity.ContentType;
import org.apache.kylin.jdbc.shaded.org.apache.http.entity.StringEntity;
import org.apache.kylin.jdbc.shaded.org.apache.http.impl.client.DefaultHttpClient;
import org.apache.kylin.jdbc.shaded.org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KylinClient
implements IRemoteClient {
    private static final Logger logger = LoggerFactory.getLogger(KylinClient.class);
    private final KylinConnectionInfo connInfo;
    private final Properties connProps;
    private HttpClient httpClient;
    private final ObjectMapper jsonMapper;

    public KylinClient(KylinConnectionInfo connInfo) {
        this.connInfo = connInfo;
        this.connProps = connInfo.getConnectionProperties();
        this.jsonMapper = new ObjectMapper();
        this.httpClient = new DefaultHttpClient();
        if (this.isSSL()) {
            try {
                SSLSocketFactory sslsf;
                if (this.isSetKeyTrustStore()) {
                    KeyStore ks = KeyStore.getInstance(this.getSSLProperty("javax.net.ssl.keyStoreType"));
                    File ksFile = new File(this.getSSLProperty("javax.net.ssl.keyStore"));
                    try (FileInputStream is = new FileInputStream(ksFile);){
                        ks.load(is, this.getSSLProperty("javax.net.ssl.keyStorePassword").toCharArray());
                    }
                    KeyStore ts = KeyStore.getInstance(this.getSSLProperty("javax.net.ssl.trustStoreType"));
                    File tsFile = new File(this.getSSLProperty("javax.net.ssl.trustStore"));
                    try (FileInputStream is = new FileInputStream(tsFile);){
                        ts.load(is, this.getSSLProperty("javax.net.ssl.trustStorePassword").toCharArray());
                    }
                    sslsf = new SSLSocketFactory(ks, this.getSSLProperty("javax.net.ssl.keyStorePassword"), ts);
                } else {
                    sslsf = new SSLSocketFactory(new TrustStrategy(){

                        @Override
                        public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                            return true;
                        }
                    });
                }
                this.httpClient.getConnectionManager().getSchemeRegistry().register(new Scheme("https", 443, sslsf));
            }
            catch (Exception e) {
                throw new RuntimeException("Initialize HTTPS client failed", e);
            }
        }
    }

    @VisibleForTesting
    void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public static Class convertType(int sqlType) {
        Class<Object> result = Object.class;
        switch (sqlType) {
            case -1: 
            case 1: 
            case 12: {
                result = String.class;
                break;
            }
            case 2: 
            case 3: {
                result = BigDecimal.class;
                break;
            }
            case -7: 
            case 16: {
                result = Boolean.class;
                break;
            }
            case -6: {
                result = Byte.class;
                break;
            }
            case 5: {
                result = Short.class;
                break;
            }
            case 4: {
                result = Integer.class;
                break;
            }
            case -5: {
                result = Long.class;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                result = Double.class;
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                result = Byte[].class;
                break;
            }
            case 91: {
                result = Date.class;
                break;
            }
            case 92: {
                result = Time.class;
                break;
            }
            case 93: {
                result = Timestamp.class;
                break;
            }
        }
        return result;
    }

    public static Object wrapObject(String value, int sqlType) {
        if (null == value) {
            return null;
        }
        switch (sqlType) {
            case -1: 
            case 1: 
            case 12: {
                return value;
            }
            case 2: 
            case 3: {
                return new BigDecimal(value);
            }
            case -7: 
            case 16: {
                return Boolean.valueOf(value);
            }
            case -6: {
                return Byte.valueOf(value);
            }
            case 5: {
                return Short.valueOf(value);
            }
            case 4: {
                return Integer.valueOf(value);
            }
            case -5: {
                return Long.valueOf(value);
            }
            case 6: {
                return Float.valueOf(value);
            }
            case 7: 
            case 8: {
                return Double.valueOf(value);
            }
            case -4: 
            case -3: 
            case -2: {
                return value.getBytes(StandardCharsets.UTF_8);
            }
            case 91: {
                return Date.valueOf(value);
            }
            case 92: {
                return Time.valueOf(value);
            }
            case 93: {
                return Timestamp.valueOf(value);
            }
        }
        return value;
    }

    private boolean isSSL() {
        return Boolean.parseBoolean(this.connProps.getProperty("ssl", "false"));
    }

    private boolean isSetKeyTrustStore() {
        return this.isSetKeyStore() && this.isSetTrustStore();
    }

    private boolean isSetKeyStore() {
        return this.getSSLProperty("javax.net.ssl.keyStoreType") != null && this.getSSLProperty("javax.net.ssl.keyStore") != null && this.getSSLProperty("javax.net.ssl.keyStorePassword") != null;
    }

    private boolean isSetTrustStore() {
        return this.getSSLProperty("javax.net.ssl.trustStoreType") != null && this.getSSLProperty("javax.net.ssl.trustStore") != null && this.getSSLProperty("javax.net.ssl.trustStorePassword") != null;
    }

    private String getSSLProperty(String key) {
        return this.connProps.getProperty(key) != null ? this.connProps.getProperty(key) : System.getProperty(key);
    }

    private String baseUrl() {
        return (this.isSSL() ? "https://" : "http://") + this.connInfo.getBaseUrl();
    }

    private void addHttpHeaders(HttpRequestBase method) {
        method.addHeader("Accept", "application/json, text/plain, */*");
        method.addHeader("Content-Type", "application/json");
        method.addHeader("User-Agent", "KylinJDBCDriver");
        String username = this.connProps.getProperty("user");
        String password = this.connProps.getProperty("password");
        String basicAuth = DatatypeConverter.printBase64Binary((byte[])(username + ":" + password).getBytes(StandardCharsets.UTF_8));
        method.addHeader("Authorization", "Basic " + basicAuth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect() throws IOException {
        HttpPost post = new HttpPost(this.baseUrl() + "/kylin/api/user/authentication");
        this.addHttpHeaders(post);
        StringEntity requestEntity = new StringEntity("{}", ContentType.create("application/json", "UTF-8"));
        post.setEntity(requestEntity);
        try {
            HttpResponse response = this.httpClient.execute(post);
            if (response.getStatusLine().getStatusCode() != 200 && response.getStatusLine().getStatusCode() != 201) {
                throw this.asIOException(post, response);
            }
        }
        finally {
            post.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KylinMeta.KMetaProject retrieveMetaData(String project) throws IOException {
        assert (this.connInfo.getProject().equals(project));
        String url = this.baseUrl() + "/kylin/api/tables_and_columns?project=" + project;
        HttpGet get = new HttpGet(url);
        this.addHttpHeaders(get);
        HttpResponse response = this.httpClient.execute(get);
        try {
            if (response.getStatusLine().getStatusCode() != 200 && response.getStatusLine().getStatusCode() != 201) {
                throw this.asIOException(get, response);
            }
            List tableMetaStubs = (List)this.jsonMapper.readValue(response.getEntity().getContent(), (TypeReference)new TypeReference<List<TableMetaStub>>(){});
            List<KylinMeta.KMetaTable> tables = this.convertMetaTables(tableMetaStubs);
            List<KylinMeta.KMetaSchema> schemas = this.convertMetaSchemas(tables);
            List<KylinMeta.KMetaCatalog> catalogs = this.convertMetaCatalogs(schemas);
            KylinMeta.KMetaProject kMetaProject = new KylinMeta.KMetaProject(project, catalogs);
            return kMetaProject;
        }
        finally {
            get.releaseConnection();
        }
    }

    private List<KylinMeta.KMetaCatalog> convertMetaCatalogs(List<KylinMeta.KMetaSchema> schemas) {
        LinkedHashMap<String, ArrayList<KylinMeta.KMetaSchema>> catalogMap = new LinkedHashMap<String, ArrayList<KylinMeta.KMetaSchema>>();
        for (KylinMeta.KMetaSchema schema : schemas) {
            ArrayList<KylinMeta.KMetaSchema> list = (ArrayList<KylinMeta.KMetaSchema>)catalogMap.get(schema.tableCatalog);
            if (list == null) {
                list = new ArrayList<KylinMeta.KMetaSchema>();
                catalogMap.put(schema.tableCatalog, list);
            }
            list.add(schema);
        }
        ArrayList<KylinMeta.KMetaCatalog> result = new ArrayList<KylinMeta.KMetaCatalog>();
        for (List catSchemas : catalogMap.values()) {
            String catalog = ((KylinMeta.KMetaSchema)catSchemas.get((int)0)).tableCatalog;
            result.add(new KylinMeta.KMetaCatalog(catalog, catSchemas));
        }
        return result;
    }

    private List<KylinMeta.KMetaSchema> convertMetaSchemas(List<KylinMeta.KMetaTable> tables) {
        LinkedHashMap<String, ArrayList<KylinMeta.KMetaTable>> schemaMap = new LinkedHashMap<String, ArrayList<KylinMeta.KMetaTable>>();
        for (KylinMeta.KMetaTable table : tables) {
            String key = table.tableCat + "!!" + table.tableSchem;
            ArrayList<KylinMeta.KMetaTable> list = (ArrayList<KylinMeta.KMetaTable>)schemaMap.get(key);
            if (list == null) {
                list = new ArrayList<KylinMeta.KMetaTable>();
                schemaMap.put(key, list);
            }
            list.add(table);
        }
        ArrayList<KylinMeta.KMetaSchema> result = new ArrayList<KylinMeta.KMetaSchema>();
        for (List schemaTables : schemaMap.values()) {
            String catalog = ((KylinMeta.KMetaTable)schemaTables.get((int)0)).tableCat;
            String schema = ((KylinMeta.KMetaTable)schemaTables.get((int)0)).tableSchem;
            result.add(new KylinMeta.KMetaSchema(catalog, schema, schemaTables));
        }
        return result;
    }

    private List<KylinMeta.KMetaTable> convertMetaTables(List<TableMetaStub> tableMetaStubs) {
        ArrayList<KylinMeta.KMetaTable> result = new ArrayList<KylinMeta.KMetaTable>(tableMetaStubs.size());
        for (TableMetaStub tableStub : tableMetaStubs) {
            result.add(this.convertMetaTable(tableStub));
        }
        return result;
    }

    private KylinMeta.KMetaTable convertMetaTable(TableMetaStub tableStub) {
        ArrayList<KylinMeta.KMetaColumn> columns = new ArrayList<KylinMeta.KMetaColumn>(tableStub.getColumns().size());
        for (TableMetaStub.ColumnMetaStub columnStub : tableStub.getColumns()) {
            columns.add(this.convertMetaColumn(columnStub));
        }
        return new KylinMeta.KMetaTable(tableStub.getTABLE_CAT(), tableStub.getTABLE_SCHEM(), tableStub.getTABLE_NAME(), tableStub.getTABLE_TYPE(), columns);
    }

    private KylinMeta.KMetaColumn convertMetaColumn(TableMetaStub.ColumnMetaStub columnStub) {
        return new KylinMeta.KMetaColumn(columnStub.getTABLE_CAT(), columnStub.getTABLE_SCHEM(), columnStub.getTABLE_NAME(), columnStub.getCOLUMN_NAME(), columnStub.getDATA_TYPE(), columnStub.getTYPE_NAME(), columnStub.getCOLUMN_SIZE(), (Integer)columnStub.getDECIMAL_DIGITS(), columnStub.getNUM_PREC_RADIX(), columnStub.getNULLABLE(), columnStub.getCHAR_OCTET_LENGTH(), columnStub.getORDINAL_POSITION(), columnStub.getIS_NULLABLE());
    }

    @Override
    public IRemoteClient.QueryResult executeQuery(String sql, List<Object> paramValues, Map<String, String> queryToggles) throws IOException {
        SQLResponseStub queryResp = this.executeKylinQuery(sql, this.convertParameters(paramValues), queryToggles);
        if (queryResp.getIsException()) {
            throw new IOException(queryResp.getExceptionMessage());
        }
        List<ColumnMetaData> metas = this.convertColumnMeta(queryResp);
        List<Object> data = this.convertResultData(queryResp, metas);
        return new IRemoteClient.QueryResult(metas, data);
    }

    private List<StatementParameter> convertParameters(List<Object> paramValues) {
        if (paramValues == null) {
            return null;
        }
        ArrayList<StatementParameter> result = new ArrayList<StatementParameter>();
        for (Object v : paramValues) {
            result.add(new StatementParameter(v.getClass().getCanonicalName(), String.valueOf(v)));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SQLResponseStub executeKylinQuery(String sql, List<StatementParameter> params, Map<String, String> queryToggles) throws IOException {
        String url = this.baseUrl() + "/kylin/api/query";
        String project = this.connInfo.getProject();
        PreparedQueryRequest request = new PreparedQueryRequest();
        if (null != params) {
            request.setParams(params);
        }
        request.setSql(sql);
        request.setProject(project);
        request.setBackdoorToggles(queryToggles);
        HttpPost post = new HttpPost(url);
        this.addHttpHeaders(post);
        String postBody = this.jsonMapper.writeValueAsString(request);
        logger.debug("Post body:\n {}", (Object)postBody);
        StringEntity requestEntity = new StringEntity(postBody, ContentType.create("application/json", "UTF-8"));
        post.setEntity(requestEntity);
        HttpResponse response = this.httpClient.execute(post);
        try {
            SQLResponseStub stub;
            if (response.getStatusLine().getStatusCode() != 200 && response.getStatusLine().getStatusCode() != 201) {
                throw this.asIOException(post, response);
            }
            SQLResponseStub sQLResponseStub = stub = this.jsonMapper.readValue(response.getEntity().getContent(), SQLResponseStub.class);
            return sQLResponseStub;
        }
        finally {
            post.releaseConnection();
        }
    }

    private List<ColumnMetaData> convertColumnMeta(SQLResponseStub queryResp) {
        ArrayList<ColumnMetaData> metas = new ArrayList<ColumnMetaData>();
        for (int i = 0; i < queryResp.getColumnMetas().size(); ++i) {
            SQLResponseStub.ColumnMetaStub scm = queryResp.getColumnMetas().get(i);
            Class columnClass = KylinClient.convertType(scm.getColumnType());
            ColumnMetaData.ScalarType type = ColumnMetaData.scalar(scm.getColumnType(), scm.getColumnTypeName(), ColumnMetaData.Rep.of(columnClass));
            ColumnMetaData meta = new ColumnMetaData(i, scm.isAutoIncrement(), scm.isCaseSensitive(), scm.isSearchable(), scm.isCurrency(), scm.getIsNullable(), scm.isSigned(), scm.getDisplaySize(), scm.getLabel(), scm.getName(), scm.getSchemaName(), scm.getPrecision(), scm.getScale(), scm.getTableName(), scm.getSchemaName(), type, scm.isReadOnly(), scm.isWritable(), scm.isWritable(), columnClass.getCanonicalName());
            metas.add(meta);
        }
        return metas;
    }

    private List<Object> convertResultData(SQLResponseStub queryResp, List<ColumnMetaData> metas) {
        List<String[]> stringResults = queryResp.getResults();
        ArrayList<Object> data = new ArrayList<Object>(stringResults.size());
        for (String[] result : stringResults) {
            Object[] row = new Object[result.length];
            for (int i = 0; i < result.length; ++i) {
                ColumnMetaData meta = metas.get(i);
                row[i] = KylinClient.wrapObject(result[i], meta.type.id);
            }
            data.add(row);
        }
        return data;
    }

    private IOException asIOException(HttpRequestBase request, HttpResponse response) throws IOException {
        return new IOException(request.getMethod() + " failed, error code " + response.getStatusLine().getStatusCode() + " and response: " + EntityUtils.toString(response.getEntity()));
    }

    @Override
    public void close() throws IOException {
    }
}

