/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.jdbc;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicStatusLine;
import org.mockito.Mockito;

public final class TestUtil {
    private TestUtil() {
    }

    public static String getResourceContent(String path) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        StringWriter writer = new StringWriter();
        InputStream is = loader.getResourceAsStream(path);
        if (is == null) {
            throw new IllegalArgumentException(new FileNotFoundException(path + " not found in class path"));
        }
        try {
            IOUtils.copy((InputStream)is, (Writer)writer, (String)"utf-8");
            return writer.toString();
        }
        catch (IOException e) {
            IOUtils.closeQuietly((InputStream)is);
            throw new RuntimeException(e);
        }
    }

    public static HttpResponse mockHttpResponse(int statusCode, String message, String body) {
        HttpResponse response = (HttpResponse)Mockito.mock(HttpResponse.class);
        Mockito.when((Object)response.getStatusLine()).thenReturn((Object)new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, statusCode, message));
        Mockito.when((Object)response.getEntity()).thenReturn((Object)new StringEntity(body, StandardCharsets.UTF_8));
        return response;
    }

    public static HttpResponse mockHttpResponseWithFile(int statusCode, String message, String path) {
        return TestUtil.mockHttpResponse(statusCode, message, TestUtil.getResourceContent(path));
    }
}

