/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.jdbc;

import java.io.IOException;
import java.io.StringReader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import org.apache.calcite.avatica.ColumnMetaData;
import org.apache.calcite.avatica.UnregisteredDriver;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicStatusLine;
import org.apache.kylin.jdbc.Driver;
import org.apache.kylin.jdbc.IRemoteClient;
import org.apache.kylin.jdbc.JdbcFactory;
import org.apache.kylin.jdbc.KylinClient;
import org.apache.kylin.jdbc.KylinConnection;
import org.apache.kylin.jdbc.KylinConnectionInfo;
import org.apache.kylin.jdbc.KylinJdbcFactory;
import org.apache.kylin.jdbc.TestUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class KylinConnectionTest {
    private final Driver driver = new Driver();
    private final KylinJdbcFactory factory = (KylinJdbcFactory)Mockito.spy((Object)new KylinJdbcFactory.Version41());
    private final IRemoteClient client = (IRemoteClient)Mockito.mock(IRemoteClient.class);
    private final HttpClient httpClient = (HttpClient)Mockito.mock(HttpClient.class);

    @Before
    public void setUp() throws Exception {
    }

    @Test
    public void testPrepareStatementWithMockKylinClient() throws SQLException, IOException {
        String sql = "select 1 as val";
        Mockito.when((Object)this.client.executeQuery(Mockito.anyString(), (List)Mockito.any(), (Map)Mockito.any())).thenReturn((Object)this.getMockResult());
        try (KylinConnection conn = this.getConnectionWithMockClient();){
            PreparedStatement preparedStatement = conn.prepareStatement(sql);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                ((IRemoteClient)Mockito.verify((Object)this.client)).executeQuery((String)Mockito.eq((Object)sql), (List)Mockito.any(), (Map)Mockito.any());
                Assert.assertTrue((boolean)resultSet.next());
                ResultSetMetaData metaData = resultSet.getMetaData();
                Assert.assertEquals((Object)"VAL", (Object)metaData.getColumnName(1));
                Assert.assertEquals((long)1L, (long)resultSet.getInt("VAL"));
            }
        }
    }

    @Test
    public void testPrepareStatementWithMockHttp() throws IOException, SQLException {
        String sql = "select 1 as val";
        try (KylinConnection connection = this.getConnectionWithMockHttp();){
            HttpResponse response = TestUtil.mockHttpResponseWithFile(200, "OK", "query.json");
            Mockito.when((Object)this.httpClient.execute((HttpUriRequest)Mockito.any(HttpUriRequest.class))).thenReturn((Object)response);
            try (ResultSet resultSet = connection.prepareStatement(sql).executeQuery();){
                Assert.assertTrue((boolean)resultSet.next());
                ResultSetMetaData metaData = resultSet.getMetaData();
                Assert.assertEquals((Object)"VAL", (Object)metaData.getColumnName(1));
                Assert.assertEquals((long)1L, (long)resultSet.getInt("VAL"));
            }
        }
    }

    private KylinConnection getConnectionWithMockClient() throws SQLException {
        return this.getConnectionWithMockClient("jdbc:kylin:test_url/test_db", new Properties());
    }

    private KylinConnection getConnectionWithMockClient(String url, @Nonnull Properties info) throws SQLException {
        info.setProperty("user", "ADMIN");
        info.setProperty("password", "KYLIN");
        ((KylinJdbcFactory)Mockito.doReturn((Object)this.client).when((Object)this.factory)).newRemoteClient((KylinConnectionInfo)Mockito.any(KylinConnectionInfo.class));
        return new KylinConnection((UnregisteredDriver)this.driver, (JdbcFactory)this.factory, url, info);
    }

    private KylinConnection getConnectionWithMockHttp() throws SQLException, IOException {
        Properties info = new Properties();
        info.setProperty("user", "ADMIN");
        info.setProperty("password", "KYLIN");
        ((KylinJdbcFactory)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invo) throws Throwable {
                KylinConnectionInfo connInfo = (KylinConnectionInfo)invo.getArgument(0);
                KylinClient client = new KylinClient(connInfo);
                client.setHttpClient(KylinConnectionTest.this.httpClient);
                return client;
            }
        }).when((Object)this.factory)).newRemoteClient((KylinConnectionInfo)Mockito.any(KylinConnectionInfo.class));
        HttpResponse response = (HttpResponse)Mockito.mock(HttpResponse.class);
        Mockito.when((Object)this.httpClient.execute((HttpUriRequest)Mockito.any(HttpUriRequest.class))).thenReturn((Object)response);
        Mockito.when((Object)response.getStatusLine()).thenReturn((Object)new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK"));
        return new KylinConnection((UnregisteredDriver)this.driver, (JdbcFactory)this.factory, "jdbc:kylin:test_url/test_db", info);
    }

    @Test
    public void testJdbcClientCalcitePropsInUrl() throws Exception {
        String sql = "select 1 as val";
        Mockito.when((Object)this.client.executeQuery(Mockito.anyString(), (List)Mockito.any(), (Map)Mockito.any())).thenReturn((Object)this.getMockResult());
        HashMap toggles = new HashMap();
        Properties info = new Properties();
        info.setProperty("caseSensitive", "false");
        info.setProperty("unquotedCasing", "UNCHANGED");
        try (KylinConnection conn = this.getConnectionWithMockClient("jdbc:kylin:test_url/test_db", info);){
            PreparedStatement preparedStatement = conn.prepareStatement(sql);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                ((IRemoteClient)Mockito.verify((Object)this.client)).executeQuery((String)Mockito.eq((Object)sql), (List)Mockito.any(), (Map)ArgumentMatchers.argThat((ArgumentMatcher)new ArgumentMatcher<Map<String, String>>(){

                    public boolean matches(Map<String, String> argument) {
                        String propsStr = argument.get("JDBC_CLIENT_CALCITE_PROPS");
                        Assert.assertNotNull((Object)propsStr);
                        Properties props = new Properties();
                        try {
                            props.load(new StringReader(propsStr));
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                        Assert.assertEquals((Object)"false", (Object)props.getProperty("caseSensitive"));
                        Assert.assertEquals((Object)"UNCHANGED", (Object)props.getProperty("unquotedCasing"));
                        return true;
                    }
                }));
                Assert.assertTrue((boolean)resultSet.next());
                ResultSetMetaData metaData = resultSet.getMetaData();
                Assert.assertEquals((Object)"VAL", (Object)metaData.getColumnName(1));
                Assert.assertEquals((long)1L, (long)resultSet.getInt("VAL"));
            }
        }
    }

    private IRemoteClient.QueryResult getMockResult() {
        ArrayList<ColumnMetaData> columnMeta = new ArrayList<ColumnMetaData>();
        columnMeta.add(new ColumnMetaData(0, false, true, false, false, 1, true, 1, "VAL", "VAL", null, 10, 0, null, null, (ColumnMetaData.AvaticaType)ColumnMetaData.scalar((int)4, (String)"INTEGER", (ColumnMetaData.Rep)ColumnMetaData.Rep.INTEGER), true, false, false, "java.lang.Integer"));
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        list.add(new Object[]{1});
        return new IRemoteClient.QueryResult(columnMeta, list);
    }
}

