/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.jdbc;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicStatusLine;
import org.apache.kylin.jdbc.IRemoteClient;
import org.apache.kylin.jdbc.KylinClient;
import org.apache.kylin.jdbc.KylinConnectionInfo;
import org.apache.kylin.jdbc.KylinMeta;
import org.apache.kylin.jdbc.TestUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class KylinClientTest {
    KylinConnectionInfo connInfo = new KylinConnectionInfo(){

        public String getProject() {
            return "default";
        }

        public String getBaseUrl() {
            return "http://localhost:7070";
        }

        public Properties getConnectionProperties() {
            Properties props = new Properties();
            props.setProperty("user", "ADMIN");
            props.setProperty("password", "KYLIN");
            return props;
        }
    };
    KylinClient client = new KylinClient(this.connInfo);
    HttpClient httpClient = (HttpClient)Mockito.mock(HttpClient.class);

    @Before
    public void setUp() throws Exception {
        this.client.setHttpClient(this.httpClient);
    }

    @Test
    public void connect() throws IOException {
        HttpResponse response = (HttpResponse)Mockito.mock(HttpResponse.class);
        Mockito.when((Object)this.httpClient.execute((HttpUriRequest)Mockito.any(HttpUriRequest.class))).thenReturn((Object)response);
        Mockito.when((Object)response.getStatusLine()).thenReturn((Object)new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK"));
        this.client.connect();
    }

    @Test
    public void retrieveMetaData() throws IOException {
        HttpResponse response = TestUtil.mockHttpResponseWithFile(200, "OK", "tables_and_columns.json");
        Mockito.when((Object)this.httpClient.execute((HttpUriRequest)Mockito.any(HttpUriRequest.class))).thenReturn((Object)response);
        KylinMeta.KMetaProject metaData = this.client.retrieveMetaData(this.connInfo.getProject());
        Assert.assertEquals((Object)this.connInfo.getProject(), (Object)metaData.projectName);
        Assert.assertTrue((!metaData.catalogs.isEmpty() ? 1 : 0) != 0);
        KylinMeta.KMetaCatalog catalog = (KylinMeta.KMetaCatalog)metaData.catalogs.get(0);
        Assert.assertEquals((Object)"defaultCatalog", (Object)catalog.getName());
        Assert.assertEquals((long)1L, (long)catalog.schemas.size());
        KylinMeta.KMetaSchema schema = (KylinMeta.KMetaSchema)catalog.schemas.get(0);
        Assert.assertEquals((Object)"DEFAULT", (Object)schema.getName());
        Assert.assertEquals((long)5L, (long)schema.tables.size());
    }

    @Test(expected=AssertionError.class)
    public void retrieveMetaDataWithWrongProject() throws IOException {
        this.client.retrieveMetaData("defualt2");
    }

    @Test
    public void executeQuery() throws IOException {
        HttpResponse response = TestUtil.mockHttpResponseWithFile(200, "OK", "query.json");
        Mockito.when((Object)this.httpClient.execute((HttpUriRequest)Mockito.any(HttpUriRequest.class))).thenReturn((Object)response);
        IRemoteClient.QueryResult queryResult = this.client.executeQuery("SELECT 1 as val", Collections.emptyList(), new HashMap());
        Assert.assertEquals((long)1L, (long)queryResult.columnMeta.size());
        Iterable iterable = queryResult.iterable;
        ArrayList list = Lists.newArrayList((Iterable)iterable);
        Assert.assertEquals((long)1L, (long)list.size());
    }
}

